/**********************************************************************
 *
 * depositoraction.h -- 
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_DEPOSITOR_ACTION

#ifndef DEPOSITORACTION_H
#define DEPOSITORACTION_H

#include "wizardaction.h"
#include "receptionist.h"

class depositoraction : public wizardaction {
  
protected:

  int lastpage; 

public:
  depositoraction ();
  virtual ~depositoraction ();

  void write_metadata_file(cgiargsclass &args, text_t filename_str, text_t& timestamp_str);

  void write_manifest_file(cgiargsclass &args, text_t filename, text_t& timestamp_str);

  text_t get_action_name () {return "depositor";}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass *protos, ostream &logout);

  //we need to redefine this
  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  //and this
  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

  text_t get_button(cgiargsclass &args, const text_t &thispage, 
		    const text_t &color, 
		    const text_t &type, bool enabled);

};

#endif //!DEPOSITORACTION_H
#endif //GSDL_USE_DEPOSITOR_ACTION
