/**********************************************************************
 *
 * dublincore.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _DUBLINCORE_H_
#define _DUBLINCORE_H_
#include "metaformat.h"

class dublin_core : public metaformat
{
 protected:
  virtual void output_metadata_header(ostream &output);
  virtual void output_metadata_footer(ostream &output);
  virtual bool output_custom_metadata(ostream &output, outconvertclass &outconvert, bool &headerDone, const text_t &collection, ResultDocInfo_t &docInfo);
 public:
  dublin_core(); 
  virtual const text_t formatName();
  virtual const text_t formatPrefix();
  virtual bool output_record(ostream &output, recptproto *protocol, const text_t &collection, 
			     const text_t &record_OID);
  virtual bool output_formatdata(ostream &output);
};


#endif 
