/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.server;

import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.greenstone.gsdl3.util.GSEntityResolver;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.greenstone.server.BaseServer;
import org.greenstone.server.BaseServerSettings;
import org.greenstone.util.GlobalProperties;
import org.greenstone.util.ScriptReadWrite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class Server3Settings
extends BaseServerSettings {
    protected String servletDefault = null;
    protected JComboBox servlet_combobox;
    protected HashMap<String, String> url_mappings = null;

    public Server3Settings(BaseServer server) {
        super(server);
    }

    @Override
    protected JPanel createServletPanel() {
        JLabel servlet_label = new JLabel(BaseServer.dictionary.get(BaseServer.Property.SERVER_SETTINGS + ".URL"));
        this.servletDefault = BaseServer.config_properties.getProperty(BaseServer.Property.DEFAULT_SERVLET);
        this.servlet_combobox = new JComboBox();
        this.servlet_combobox.setMaximumRowCount(5);
        this.servlet_combobox.setBackground(bg_color);
        File web_xml = new File(GlobalProperties.getGSDL3Home() + File.separator + "WEB-INF" + File.separator + "web.xml");
        XMLConverter converter = new XMLConverter();
        Document web_config = XMLConverter.getDOM((File)web_xml, (EntityResolver)new GSEntityResolver(web_xml.getParentFile()));
        if (web_config == null) {
            logger.error((Object)("web.xml is null! " + web_xml.getAbsolutePath()));
            return null;
        }
        NodeList servlet_mappings = web_config.getElementsByTagName("servlet-mapping");
        this.url_mappings = new HashMap();
        for (int i = 0; i < servlet_mappings.getLength(); ++i) {
            Element map = (Element)servlet_mappings.item(i);
            Element servlet_name_elem = (Element)GSXML.getChildByTagName((Node)map, (String)"servlet-name");
            String name = GSXML.getNodeText((Element)servlet_name_elem);
            Element url_pattern_elem = (Element)GSXML.getChildByTagName((Node)map, (String)"url-pattern");
            String pattern = GSXML.getNodeText((Element)url_pattern_elem);
            if (name.equals("AxisServlet") || name.equals("oaiserver") || name.equals("mat") || name.equals("grabtext")) continue;
            this.servlet_combobox.addItem(name.trim());
            this.url_mappings.put(name, pattern);
            if (!pattern.replaceAll("/\\*", "").equals(this.servletDefault)) continue;
            this.servlet_combobox.setSelectedItem(name);
        }
        JPanel comb_panel = new JPanel();
        comb_panel.setLayout(new FlowLayout(0));
        comb_panel.add(servlet_label);
        comb_panel.add(this.servlet_combobox);
        return comb_panel;
    }

    @Override
    public boolean[] onSave() {
        boolean hasChanged = false;
        boolean requireRestart = false;
        String urlMapping = this.url_mappings.get(this.servlet_combobox.getSelectedItem());
        if (urlMapping.endsWith("/*")) {
            urlMapping = urlMapping.substring(0, urlMapping.length() - 2);
        }
        if (!this.servletDefault.equals(urlMapping)) {
            hasChanged = true;
            requireRestart = true;
        }
        boolean[] returnValues = new boolean[]{hasChanged, requireRestart};
        return returnValues;
    }

    @Override
    public void save(ScriptReadWrite scriptReadWrite, ArrayList<String> newFileLines) {
        String newAutoEnter = String.valueOf(this.autoEnter.isSelected());
        newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.AUTOSTART, newAutoEnter);
        String newKeepPort = String.valueOf(this.keepPortToggle.isSelected());
        newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.KEEPPORT, newKeepPort);
        newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.ALLOW_EXTERNAL_ACCESS, this.externalaccess ? "true" : "false");
        String newServletDef = (String)this.servlet_combobox.getSelectedItem();
        String servletDefName = this.url_mappings.get(newServletDef);
        if (servletDefName.endsWith("/*")) {
            servletDefName = servletDefName.substring(0, servletDefName.length() - 2);
        }
        newFileLines = scriptReadWrite.queryReplace(newFileLines, BaseServer.Property.DEFAULT_SERVLET, servletDefName);
    }
}

