/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.DefaultLogFormat;
import de.qfs.lib.log.LogEntry;
import de.qfs.lib.log.LogFormat;
import de.qfs.lib.log.LogWriter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class StreamLogWriter
implements LogWriter {
    protected LogFormat format;
    protected PrintStream ps;
    protected PrintWriter pw;
    protected boolean mustClose;
    protected boolean closed;

    public StreamLogWriter() {
        this.format = new DefaultLogFormat();
    }

    public StreamLogWriter(LogFormat logFormat) {
        this.format = logFormat;
    }

    public StreamLogWriter(PrintStream printStream, boolean bl) {
        this.ps = printStream;
        this.mustClose = bl;
        this.format = new DefaultLogFormat();
    }

    public StreamLogWriter(PrintStream printStream, boolean bl, LogFormat logFormat) {
        this.ps = printStream;
        this.mustClose = bl;
        this.format = logFormat;
    }

    public StreamLogWriter(PrintWriter printWriter, boolean bl) {
        this.pw = printWriter;
        this.mustClose = bl;
        this.format = new DefaultLogFormat();
    }

    public StreamLogWriter(PrintWriter printWriter, boolean bl, LogFormat logFormat) {
        this.pw = printWriter;
        this.mustClose = bl;
        this.format = logFormat;
    }

    public void write(LogEntry logEntry) {
        if (this.closed) {
            return;
        }
        if (this.ps != null) {
            this.ps.println(this.format.format(logEntry));
            this.ps.flush();
        } else if (this.pw != null) {
            this.pw.println(this.format.format(logEntry));
            this.pw.flush();
        }
    }

    public void write(LogEntry[] logEntryArray) {
        if (this.closed) {
            return;
        }
        if (this.ps != null) {
            int n = 0;
            while (n < logEntryArray.length) {
                this.ps.println(this.format.format(logEntryArray[n]));
                ++n;
            }
            this.ps.flush();
        } else if (this.pw != null) {
            int n = 0;
            while (n < logEntryArray.length) {
                this.pw.println(this.format.format(logEntryArray[n]));
                ++n;
            }
            this.pw.flush();
        } else {
            int n = 0;
            while (n < logEntryArray.length) {
                ++n;
            }
        }
    }

    public synchronized void close() {
        if (this.mustClose) {
            if (this.ps != null) {
                this.ps.close();
                this.ps = null;
            } else if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
            this.mustClose = false;
        }
        this.closed = true;
    }

    public final LogFormat getFormat() {
        return this.format;
    }

    public final void setFormat(LogFormat logFormat) {
        this.format = logFormat;
    }
}

