@echo off

set MGPPHOME=..\..\..\..

rem ---- Where to put class files ----
set JAVACLASSDIR=classes

rem ---- Name and location of java programs ----
set JAVAC="%JAVA_HOME%\bin\javac"
rem set JAVAH="%JAVA_HOME%\bin\javah"
set JAVA="%JAVA_HOME%\bin\java"
set JAVADOC="%JAVA_HOME%\bin\javadoc"
set JAR="%JAVA_HOME%\bin\jar"

set JAVACOPTIONS= -deprecation -g -O

if "%DEBUG%" == "" (
  set MAKE_VARS=DEBUG=0
) else (
  set MAKE_VARS=DEBUG=%DEBUG%
)


if ""%1"" == """" goto all
if ""%1"" == ""all"" goto all
if ""%1"" == ""install"" goto install
if ""%1"" == ""clean"" goto clean

:unknown
	echo Error: Unrecognized argument %1.
	goto done

:all
	if not exist %JAVACLASSDIR% mkdir %JAVACLASSDIR%
	echo Compiling MGPP Java classes ...
        %JAVAC% -d %JAVACLASSDIR% %JAVACOPTIONS% *.java
rem        %JAVAH% -classpath %JAVACLASSDIR% -d %MGPPHOME%\jni org.greenstone.mgpp.MGPPPassesWrapper
rem        %JAVAH% -classpath %JAVACLASSDIR% -d %MGPPHOME%\jni org.greenstone.mgpp.MGPPSearchWrapper
rem        %JAVAH% -classpath %JAVACLASSDIR% -d %MGPPHOME%\jni org.greenstone.mgpp.MGPPRetrieveWrapper
        %JAVAC% -classpath %JAVACLASSDIR% -h %MGPPHOME%\jni MGPPPassesWrapper.java
        %JAVAC% -classpath %JAVACLASSDIR% -h %MGPPHOME%\jni MGPPSearchWrapper.java
        %JAVAC% -classpath %JAVACLASSDIR% -h %MGPPHOME%\jni MGPPRetrieveWrapper.java
        %JAR% cf %MGPPHOME%\mgpp.jar -C %JAVACLASSDIR% org
	goto done

:install
	goto done

:clean
	echo Cleaning up...
	if exist %JAVACLASSDIR% rmdir /S /Q %JAVACLASSDIR%
        if exist %MGPPHOME%\mgpp.jar del %MGPPHOME%\mgpp.jar
        if exist %MGPPHOME%\jni\org_greenstone_mgpp_MGPPPassesWrapper.h del %MGPPHOME%\jni\org_greenstone_mgpp_MGPPPassesWrapper.h
        if exist %MGPPHOME%\jni\org_greenstone_mgpp_MGPPSearchWrapper.h del %MGPPHOME%\jni\org_greenstone_mgpp_MGPPSearchWrapper.h
        if exist %MGPPHOME%\jni\org_greenstone_mgpp_MGPPRetrieveWrapper.h del %MGPPHOME%\jni\org_greenstone_mgpp_MGPPRetrieveWrapper.h
	goto done

:done
