/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2022 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.StaticStrings;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.*;


/** This class encapsulates a single search metadata assignment, which constitutes a name, language and value and type
 */
public class SearchMeta
    extends CollectionMeta {

    public static final String TYPE_INDEX = "index";
    public static final String TYPE_LEVEL = "level";
    public static final String TYPE_PARTITION = "partition";
    public static final String TYPE_LANGUAGE = "language";
  public static final String TYPE_SORT = "sort";
  public static final String TYPE_FACET = "facet";

    // gs2 all meta have the same type, as there is currently no distinction in
    // config file
    public static final String TYPE_SEARCH = "search";
 
    //    public SearchMeta() {
    //}
    /** Constructor.
     * @param element the Element from which we will determine metadata details
     */
    public SearchMeta(Element element) {
	this.element = element;
    }

    public SearchMeta(String name) {
	System.err.println("error calling new search meta with only a name");
    }
    /** Constructor to create a new piece of metadata given its name. */
    public SearchMeta(String name, String type) {
	this(name, type, Configuration.getLanguage());
    }

    /** Constructor to create a new piece of metadata given its name. */
    public SearchMeta(String name, String type, String language) {
	element = CollectionConfiguration.createElement(StaticStrings.SEARCHMETADATA_ELEMENT);
	element.setAttribute(StaticStrings.NAME_ATTRIBUTE, name);
	element.setAttribute(StaticStrings.LANGUAGE_ATTRIBUTE, language);
	element.setAttribute(StaticStrings.ASSIGNED_ATTRIBUTE, StaticStrings.FALSE_STR);
	if (Gatherer.GS3) {
	    element.setAttribute(StaticStrings.TYPE_ATTRIBUTE, type);
	} else {
	    element.setAttribute(StaticStrings.TYPE_ATTRIBUTE, TYPE_SEARCH);
	}
    }

    /** Constructor to create a new piece of metadata given its name. */
    public SearchMeta(String name, String type, String language, boolean dummy) {
	this(name, type, language);
	this.dummy = dummy;
    }

    /** Method to compare two collection metadata objects to calculate their respective ordering.
     * @param object the other metadata to compare to, as an Object
     * @return an int which is less than 0 if this object proceeds the given object, 0 if they are equal and greater than 0 otherwise.
     * @see org.greenstone.gatherer.cdm.Language
     */
    // todo this soesn't look at type
     public int compareTo(Object object) {
     	return toString().compareTo(object.toString());
     }

    /** Factory constructor. */
    public DOMProxyListEntry create(Element element) {
	return new SearchMeta(element);
    }

    /** Method to compare two collection metadata objects for equality.
     * @param object The other metadata to compare to, as an <strong>Object</strong>.
     * @return A <i>boolean</i> value of <i>true</i> if the object are equal, <i>false</i> otherwise.
     */
    public boolean equals(Object object) {
	return (compareTo(object) == 0);
     }


  public void setType(String type) {
    if(element != null) {
	if (Gatherer.GS3) {
	    element.setAttribute(StaticStrings.TYPE_ATTRIBUTE, type);
	} else {
	    element.setAttribute(StaticStrings.TYPE_ATTRIBUTE, TYPE_SEARCH);
	}
    }
  }
    public String getType() {
	if (element != null) {

	    return element.getAttribute(StaticStrings.TYPE_ATTRIBUTE);
	}
	return null;
    }
    public boolean hasType() {
	return element.hasAttribute(StaticStrings.TYPE_ATTRIBUTE);
    }
    /** Method to print out this class as it would appear within the collection configuration file.
     * @return A <strong>String</strong> containing the text value of this class.
     */
  /** what is this used for???? */
    public String toString() {
	if(text == null) {
          text = "searchmeta ["+getType()+"] [l="+getLanguage()+"] \""+getName()+"\"";
        }
	//     text = CollectCfgReadWrite.toString(element); // this puts a dot in now. don't want that. but it also adds the language
	//     if (text.equals("")){
	// 	text = getName();
        //     }
	// }
	return text;
    }
}
