/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class FoldIndicator
extends AbstractGutterComponent {
    private Insets textAreaInsets;
    private Rectangle visibleRect;
    private Fold foldWithOutlineShowing;
    private Color foldIconBackground;
    private Icon collapsedFoldIcon;
    private Icon expandedFoldIcon;
    private boolean showFoldRegionTips;
    static final Color DEFAULT_FOREGROUND = Color.gray;
    static final Color DEFAULT_FOLD_BACKGROUND = Color.white;
    private Listener listener;
    private static final int WIDTH = 12;

    public FoldIndicator(RTextArea rTextArea) {
        super(rTextArea);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setFoldIconBackground(DEFAULT_FOLD_BACKGROUND);
        this.collapsedFoldIcon = new FoldIcon(true);
        this.expandedFoldIcon = new FoldIcon(false);
        this.listener = new Listener(this);
        this.visibleRect = new Rectangle();
        this.setShowCollapsedRegionToolTips(true);
    }

    public JToolTip createToolTip() {
        Color color;
        JToolTip jToolTip = super.createToolTip();
        Color color2 = this.textArea.getBackground();
        if (color2 != null && !Color.white.equals(color2) && (color = TipUtil.getToolTipBackground()).getRed() >= 240 && color.getGreen() >= 240 && color.getBlue() >= 200) {
            jToolTip.setBackground(color2);
        }
        return jToolTip;
    }

    private Fold findOpenFoldClosestTo(Point point) {
        int n;
        Fold fold = null;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        if (rSyntaxTextArea.isCodeFoldingEnabled() && (n = rSyntaxTextArea.viewToModel(point)) > -1) {
            try {
                int n2 = rSyntaxTextArea.getLineOfOffset(n);
                FoldManager foldManager = rSyntaxTextArea.getFoldManager();
                fold = foldManager.getFoldForLine(n2);
                if (fold == null) {
                    fold = foldManager.getDeepestOpenFoldContaining(n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return fold;
    }

    public Color getFoldIconBackground() {
        return this.foldIconBackground;
    }

    public Dimension getPreferredSize() {
        int n = this.textArea != null ? this.textArea.getHeight() : 100;
        return new Dimension(12, n);
    }

    public boolean getShowCollapsedRegionToolTips() {
        return this.showFoldRegionTips;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.y = point.y / this.textArea.getLineHeight() * this.textArea.getLineHeight();
        point.x = this.getWidth();
        return point;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        if (rSyntaxTextArea.isCodeFoldingEnabled()) {
            FoldManager foldManager = rSyntaxTextArea.getFoldManager();
            int n = rSyntaxTextArea.viewToModel(new Point(0, mouseEvent.getY()));
            if (n >= 0) {
                int n2 = 0;
                try {
                    n2 = rSyntaxTextArea.getLineOfOffset(n);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return null;
                }
                Fold fold = foldManager.getFoldForLine(n2);
                if (fold != null && fold.isCollapsed()) {
                    int n3 = fold.getEndLine();
                    if (fold.getLineCount() > 25) {
                        n3 = fold.getStartLine() + 25;
                    }
                    StringBuffer stringBuffer = new StringBuffer("<html><nobr>");
                    while (n2 <= n3 && n2 < rSyntaxTextArea.getLineCount()) {
                        for (Token token = rSyntaxTextArea.getTokenListForLine(n2); token != null && token.isPaintable(); token = token.getNextToken()) {
                            token.appendHTMLRepresentation(stringBuffer, rSyntaxTextArea, true, true);
                        }
                        stringBuffer.append("<br>");
                        ++n2;
                    }
                    string = stringBuffer.toString();
                }
            }
        }
        return string;
    }

    void handleDocumentEvent(DocumentEvent documentEvent) {
        int n = this.textArea.getLineCount();
        if (n != this.currentLineCount) {
            this.currentLineCount = n;
            this.repaint();
        }
    }

    void lineHeightsChanged() {
    }

    protected void paintComponent(Graphics graphics) {
        boolean bl;
        if (this.textArea == null) {
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        Color color = this.getBackground();
        if (this.getGutter() != null) {
            color = this.getGutter().getBackground();
        }
        graphics.setColor(color);
        graphics.fillRect(0, this.visibleRect.y, this.getWidth(), this.visibleRect.height);
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        if (!rSyntaxTextArea.isCodeFoldingEnabled()) {
            return;
        }
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(graphics);
            return;
        }
        int n = this.textArea.getLineHeight();
        int n2 = this.visibleRect.y / n;
        int n3 = n2 * n + (n - this.collapsedFoldIcon.getIconHeight()) / 2;
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.textAreaInsets != null) {
            n3 += this.textAreaInsets.top;
        }
        FoldManager foldManager = rSyntaxTextArea.getFoldManager();
        n2 += foldManager.getHiddenLineCountAbove(n2, true);
        int n4 = this.getWidth();
        int n5 = n4 - 10;
        int n6 = n2;
        boolean bl2 = bl = this.foldWithOutlineShowing != null && this.foldWithOutlineShowing.containsLine(n6);
        while (n3 < this.visibleRect.y + this.visibleRect.height) {
            Fold fold;
            int n7;
            if (bl) {
                graphics.setColor(this.getForeground());
                int n8 = n4 / 2;
                if (n6 == this.foldWithOutlineShowing.getEndLine()) {
                    n7 = n3 + n / 2;
                    graphics.drawLine(n8, n3, n8, n7);
                    graphics.drawLine(n8, n7, n4 - 2, n7);
                    bl = false;
                } else {
                    graphics.drawLine(n8, n3, n8, n3 + n);
                }
            }
            if ((fold = foldManager.getFoldForLine(n6)) != null) {
                if (fold == this.foldWithOutlineShowing && !fold.isCollapsed()) {
                    graphics.setColor(this.getForeground());
                    n7 = n4 / 2;
                    graphics.drawLine(n7, n3 + n / 2, n7, n3 + n);
                    bl = true;
                }
                if (fold.isCollapsed()) {
                    this.collapsedFoldIcon.paintIcon(this, graphics, n5, n3);
                    while ((n7 = fold.getLineCount()) != 0 && (fold = foldManager.getFoldForLine(n6 += n7)) != null && fold.isCollapsed()) {
                    }
                } else {
                    this.expandedFoldIcon.paintIcon(this, graphics, n5, n3);
                }
            }
            ++n6;
            n3 += n;
        }
    }

    private void paintComponentWrapped(Graphics graphics) {
        int n = this.getWidth();
        RTextAreaUI rTextAreaUI = (RTextAreaUI)this.textArea.getUI();
        View view = rTextAreaUI.getRootView(this.textArea).getView(0);
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int n3 = element.getElementIndex(n2);
        int n4 = this.textArea.getLineHeight();
        FoldManager foldManager = ((RSyntaxTextArea)this.textArea).getFoldManager();
        Rectangle rectangle = rTextAreaUI.getVisibleEditorRect();
        Rectangle rectangle2 = LineNumberList.getChildViewBounds(view, n3, rectangle);
        int n5 = rectangle2.y;
        n5 += (n4 - this.collapsedFoldIcon.getIconHeight()) / 2;
        int n6 = this.visibleRect.y + this.visibleRect.height;
        int n7 = n - 10;
        int n8 = n3;
        boolean bl = this.foldWithOutlineShowing != null && this.foldWithOutlineShowing.containsLine(n8);
        int n9 = element.getElementCount();
        while (n5 < n6 && n8 < n9) {
            Fold fold;
            int n10;
            int n11 = LineNumberList.getChildViewBounds((View)view, (int)n8, (Rectangle)rectangle).height;
            if (bl) {
                graphics.setColor(this.getForeground());
                int n12 = n / 2;
                if (n8 == this.foldWithOutlineShowing.getEndLine()) {
                    n10 = n5 + n11 - n4 / 2;
                    graphics.drawLine(n12, n5, n12, n10);
                    graphics.drawLine(n12, n10, n - 2, n10);
                    bl = false;
                } else {
                    graphics.drawLine(n12, n5, n12, n5 + n11);
                }
            }
            if ((fold = foldManager.getFoldForLine(n8)) != null) {
                if (fold == this.foldWithOutlineShowing && !fold.isCollapsed()) {
                    graphics.setColor(this.getForeground());
                    n10 = n / 2;
                    graphics.drawLine(n10, n5 + n4 / 2, n10, n5 + n11);
                    bl = true;
                }
                if (fold.isCollapsed()) {
                    this.collapsedFoldIcon.paintIcon(this, graphics, n7, n5);
                    n5 += LineNumberList.getChildViewBounds((View)view, (int)n8, (Rectangle)rectangle).height;
                    n8 += fold.getLineCount() + 1;
                    continue;
                }
                this.expandedFoldIcon.paintIcon(this, graphics, n7, n5);
                n5 += n11;
                ++n8;
                continue;
            }
            n5 += n11;
            ++n8;
        }
    }

    private int rowAtPoint(Point point) {
        int n = 0;
        try {
            int n2 = this.textArea.viewToModel(point);
            if (n2 > -1) {
                n = this.textArea.getLineOfOffset(n2);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return n;
    }

    public void setFoldIconBackground(Color color) {
        this.foldIconBackground = color;
    }

    public void setFoldIcons(Icon icon, Icon icon2) {
        this.collapsedFoldIcon = icon;
        this.expandedFoldIcon = icon2;
        this.revalidate();
        this.repaint();
    }

    public void setShowCollapsedRegionToolTips(boolean bl) {
        if (bl != this.showFoldRegionTips) {
            if (bl) {
                ToolTipManager.sharedInstance().registerComponent(this);
            } else {
                ToolTipManager.sharedInstance().unregisterComponent(this);
            }
            this.showFoldRegionTips = bl;
        }
    }

    public void setTextArea(RTextArea rTextArea) {
        if (this.textArea != null) {
            this.textArea.removePropertyChangeListener("RSTA.codeFolding", this.listener);
        }
        super.setTextArea(rTextArea);
        if (this.textArea != null) {
            this.textArea.addPropertyChangeListener("RSTA.codeFolding", this.listener);
        }
    }

    private class Listener
    extends MouseInputAdapter
    implements PropertyChangeListener {
        public Listener(FoldIndicator foldIndicator2) {
            foldIndicator2.addMouseListener(this);
            foldIndicator2.addMouseMotionListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = FoldIndicator.this.rowAtPoint(point);
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)FoldIndicator.this.textArea;
            FoldManager foldManager = rSyntaxTextArea.getFoldManager();
            Fold fold = foldManager.getFoldForLine(n);
            if (fold != null) {
                fold.toggleCollapsedState();
                FoldIndicator.this.getGutter().repaint();
                FoldIndicator.this.textArea.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (FoldIndicator.this.foldWithOutlineShowing != null) {
                FoldIndicator.this.foldWithOutlineShowing = null;
                FoldIndicator.this.repaint();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Fold fold = FoldIndicator.this.findOpenFoldClosestTo(mouseEvent.getPoint());
            if (fold != FoldIndicator.this.foldWithOutlineShowing) {
                FoldIndicator.this.foldWithOutlineShowing = fold;
                FoldIndicator.this.repaint();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FoldIndicator.this.repaint();
        }
    }

    private class FoldIcon
    implements Icon {
        private boolean collapsed;

        public FoldIcon(boolean bl) {
            this.collapsed = bl;
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(FoldIndicator.this.foldIconBackground);
            graphics.fillRect(n, n2, 8, 8);
            graphics.setColor(FoldIndicator.this.getForeground());
            graphics.drawRect(n, n2, 8, 8);
            graphics.drawLine(n + 2, n2 + 4, n + 2 + 4, n2 + 4);
            if (this.collapsed) {
                graphics.drawLine(n + 4, n2 + 2, n + 4, n2 + 6);
            }
        }
    }
}

