/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractGS2Search;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.mg.MGDocInfo;
import org.greenstone.mg.MGEquivTermInfo;
import org.greenstone.mg.MGQueryResult;
import org.greenstone.mg.MGSearchWrapper;
import org.greenstone.mg.MGTermInfo;
import org.w3c.dom.Element;

public class GS2MGSearch
extends AbstractGS2Search {
    protected static MGSearchWrapper mg_src = null;
    static Logger logger = Logger.getLogger((String)GS2MGSearch.class.getName());

    public GS2MGSearch() {
        if (mg_src == null) {
            mg_src = new MGSearchWrapper();
        }
    }

    public void cleanUp() {
        super.cleanUp();
        mg_src.unloadIndexData();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        mg_src.setMaxNumeric(this.maxnumeric);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element processTextQuery(Element request) {
        MGSearchWrapper mGSearchWrapper = mg_src;
        synchronized (mGSearchWrapper) {
            String indexSub;
            Element result = this.doc.createElement("response");
            result.setAttribute("from", "TextQuery");
            result.setAttribute("type", "process");
            Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
            if (param_list == null) {
                logger.error((Object)"TextQuery request had no paramList.");
                return result;
            }
            HashMap params = GSXML.extractParams(param_list, false);
            String query = (String)params.get("query");
            if (query == null || query.equals("")) {
                return result;
            }
            String index = (String)params.get("index");
            if (index == null) {
                index = this.default_index;
            }
            if ((indexSub = (String)params.get("indexSubcollection")) != null) {
                index = index + indexSub;
            } else if (!this.default_index_subcollection.equals("")) {
                index = index + this.default_index_subcollection;
            }
            String indexLang = (String)params.get("indexLanguage");
            if (indexLang != null) {
                index = index + indexLang;
            } else if (!this.default_index_language.equals("")) {
                index = index + this.default_index_language;
            }
            String basedir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separatorChar;
            String textdir = GSFile.collectionTextPath(this.index_stem);
            String indexpath = GSFile.collectionIndexPath(this.index_stem, index);
            mg_src.setIndex(indexpath);
            System.err.println("index path = " + indexpath);
            this.setStandardQueryParams(params);
            mg_src.runQuery(basedir, textdir, query);
            MGQueryResult mqr = mg_src.getQueryResult();
            if (mqr.isClear()) {
                GSXML.addError(this.doc, result, "Couldn't query the mg database", "system");
                return result;
            }
            long totalDocs = mqr.getTotalDocs();
            Vector docs = mqr.getDocs();
            if (docs.size() == 0) {
                logger.error((Object)"No results found...\n");
            }
            Element metadata_list = this.doc.createElement("metadataList");
            result.appendChild(metadata_list);
            GSXML.addMetadata(this.doc, metadata_list, "numDocsReturned", "" + totalDocs);
            GSXML.addMetadata(this.doc, metadata_list, "query", query);
            if (docs.size() > 0) {
                Element document_list = this.doc.createElement("documentNodeList");
                result.appendChild(document_list);
                for (int d = 0; d < docs.size(); ++d) {
                    long docnum = ((MGDocInfo)docs.elementAt((int)d)).num_;
                    float rank = ((MGDocInfo)docs.elementAt((int)d)).rank_;
                    String doc_id = this.internalNum2OID(docnum);
                    Element doc_node = this.createDocNode(doc_id, Float.toString(rank));
                    document_list.appendChild(doc_node);
                }
            }
            Element term_list = this.doc.createElement("termList");
            result.appendChild(term_list);
            Vector terms = mqr.getTerms();
            for (int t = 0; t < terms.size(); ++t) {
                MGTermInfo term_info = (MGTermInfo)terms.get(t);
                String term = term_info.term_;
                int stem_method = term_info.stem_method_;
                Vector equiv_terms = term_info.equiv_terms_;
                Element term_elem = this.doc.createElement("term");
                term_elem.setAttribute("name", term);
                term_elem.setAttribute("stem", "" + stem_method);
                Element equiv_term_list = this.doc.createElement("equivTermList");
                term_elem.appendChild(equiv_term_list);
                long total_term_freq = 0L;
                for (int et = 0; et < equiv_terms.size(); ++et) {
                    MGEquivTermInfo equiv_term_info = (MGEquivTermInfo)equiv_terms.get(et);
                    Element equiv_term_elem = this.doc.createElement("term");
                    equiv_term_elem.setAttribute("name", equiv_term_info.term_);
                    equiv_term_elem.setAttribute("numDocsMatch", "" + equiv_term_info.match_docs_);
                    equiv_term_elem.setAttribute("freq", "" + equiv_term_info.term_freq_);
                    equiv_term_list.appendChild(equiv_term_elem);
                    total_term_freq += equiv_term_info.term_freq_;
                }
                term_elem.setAttribute("freq", "" + total_term_freq);
                term_list.appendChild(term_elem);
            }
            return result;
        }
    }

    protected boolean setStandardQueryParams(HashMap params) {
        mg_src.setReturnTerms(true);
        mg_src.setCase(true);
        Set entries = params.entrySet();
        Iterator i = entries.iterator();
        mg_src.setCase(false);
        mg_src.setStem(false);
        while (i.hasNext()) {
            boolean val;
            Map.Entry m = i.next();
            String name = (String)m.getKey();
            String value = (String)m.getValue();
            if (name.equals("case") && this.does_case) {
                val = value.equals("1");
                mg_src.setCase(val);
                continue;
            }
            if (name.equals("stem") && this.does_stem) {
                val = value.equals("1");
                mg_src.setStem(val);
                continue;
            }
            if (name.equals("matchMode")) {
                int mode = value.equals("all") ? 1 : 0;
                mg_src.setMatchMode(mode);
                continue;
            }
            if (!name.equals("maxDocs")) continue;
            int docs = Integer.parseInt(value);
            mg_src.setMaxDocs(docs);
        }
        return true;
    }
}

