###########################################################################
#
# win32 makefile -- sqlite3
# Copyright (C) 2008  DL Consulting Ltd
#
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

AR = lib
CC = cl
CPPFLAGS =
DEFS = -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = 

COMPILE = $(CC) -nologo -c $(CPPFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo -Fe"$@" $(LDFLAGS)


.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

HEADERS = \
  sqlite3.h

SOURCES = \
  shell.c \
  sqlite3.c

OBJECTS = \
  shell.obj \
  sqlite3.obj

LIBRARY = sqlite3.lib

EXECUTABLE_OBJECTS = \
  $(OBJECTS)

EXECUTABLE = sqlite3.exe

all: $(LIBRARY) $(EXECUTABLE)

sqlite3.lib: $(OBJECTS)
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

sqlite3.exe: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS)

clean:
	del $(OBJECTS)
	del $(LIBRARY)
	del $(EXECUTABLE)

install: $(LIBRARY)
        if NOT EXIST "..\include" mkdir "..\include"
	copy *.h "..\include"
        if NOT EXIST "..\lib" mkdir "..\lib"
	copy $(LIBRARY) "..\lib"
	copy $(EXECUTABLE) "$(GSDLHOME)\bin\windows"
