/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Shaoqun Wu, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gems;


/**
 *  Wrapper class for attributes displayed in the table 
 * @author Shaoqun Wu, Greenstone Digital Library, University of Waikato
 */
public class Attribute
{
    private String name="";
    private String value="";
    private String lang="";
    private boolean isRequired;
    //private boolean isLanguageDependent;

    public Attribute() {}

    public Attribute(String name, String value, String lang, boolean isRequired /*, boolean isLangDep*/){
	this.name = name;
	this.value = value;
	this.lang = lang;
	this.isRequired = isRequired;
	//this.isLanguageDependent = isLangDep;
    }

    public Attribute(String name, String value, boolean isRequired/*, boolean isLangDep*/){
	this.name = name;
	this.value = value;
	//this.lang = lang;
	this.isRequired = isRequired;
	//this.isLanguageDependent = isLangDep;
    }

    public Attribute(String name, String value){
	this.name = name;
	this.value = value;
    }

    public String getName(){
	return name;
    }

    public String getValue() {
	return value;
    }

    public String getLanguage() {
	return lang;
    }
  
    public boolean isRequired(){
	return this.isRequired;
    }

//     public boolean isLanguageDependent(){
// 	return this.isLanguageDependent;
//     }
       
    public void setName(String name) {
	if (name.trim().equals(this.name)) return;
	this.name = name.trim();
        
    }
    
    public void setValue(String value) {
	if (value.trim().equals(this.value)) return;
	this.value = value.trim();
    }

    public void setLanguage(String lang) {
	if (lang.trim().equals(this.lang)) return;
	this.lang = lang;
    }

    public void setRequired(boolean isRequired) {
	this.isRequired = isRequired;
    } 
    
//     public void setLanguageDependent(boolean isLangDep) {
// 	this.isLanguageDependent = isLangDep;
//     }

    public String toString() {
	return (this.name + " " + this.value +" " + this.lang);
    }
}
