###########################################################################
#
# win32 makefile -- gsdl + apache-httpd
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = $(GSDLHOME)
APACHEHOME = $(MAKEDIR)\httpd-2.2.11

compile: 
	if not exist "$(APACHEHOME)" if exist "$(GSDLHOME)\bin\windows\gunzip.exe" if exist "$(GSDLHOME)\bin\windows\tar.exe" "$(GSDLHOME)\bin\windows\gunzip.exe" -cd "$(APACHEHOME)-gs.tar.gz" | "$(GSDLHOME)\bin\windows\tar.exe" xv --directory=.
	@if not exist "$(APACHEHOME)" echo ****** Couldn't extract archive $(APACHEHOME)-gs.tar.gz. Extract it manually, or check that gunzip.exe and tar.exe exist in $(GSDLHOME)\bin\windows. ******
	@if not exist "$(APACHEHOME)" exit /b 1
	cd "$(APACHEHOME)"
	copy "$(GSDLHOME)\bin\windows\awk.exe" "$(APACHEHOME)\."
	set APACHEHOME=$(APACHEHOME)
	nmake /f Makefile.win _apacher
	cd "$(GSDLHOME)"

install: compile
	cd "$(APACHEHOME)"
	nmake /f Makefile.win installr INSTDIR=$(GSDLHOME)\apache-httpd\windows
	copy "$(MAKEDIR)\windows-httpd.conf.in" "$(GSDLHOME)\apache-httpd\windows\conf\httpd.conf.in
	cd "$(GSDLHOME)"

clean:
	if exist "$(APACHEHOME)\Release\buildmark.obj" del "$(APACHEHOME)\Release\buildmark.obj"
	if exist "$(APACHEHOME)\*.*" cd "$(APACHEHOME)"& nmake /f Makefile.win clean& cd "$(GSDLHOME)"

