/************************************************************
 * 
 * Collection set
 *
 ************************************************************/

#ifndef COLLECTSET_H
#define COLLECTSET_H

#include "collectserver.h"
#include "cnfgable.h"

#ifdef ENABLE_MG
#include "mgsearch.h"
#endif
#ifdef ENABLE_MGPP
#include "mgppsearch.h"
#endif
#ifdef ENABLE_LUCENE
#include "lucenesearch.h"
#endif

class collectset : public configurable
{
 protected:
  collectservermapclass cservers;
#ifdef ENABLE_MG
  mgsearchclass         *mgsearch;
#endif
#ifdef ENABLE_MGPP
  mgppsearchclass       *mgppsearch;
#endif
#ifdef ENABLE_LUCENE
  lucenesearchclass     *lucenesearch;
#endif

  text_t                httpdomain;
  text_t                httpprefix;

 public:
  collectset(text_t& gsdlhome, text_t& collecthome);

  // this constructor is used by the Firefox Greenstone
  collectset(text_t& httpprefix_arg);

  // this constructor is used by the local library
  collectset();

  virtual ~collectset();

  // initialise the collections
  bool init(ostream &logout);

  // configure all the servers as supplied
  virtual void configure (const text_t &key, const text_tarray &cfgline);

  // Add/remove collections
  void add_all_collections (const text_t &gsdlhome, const text_t& collecthome);
  void remove_all_collections ();
 
  void remove_collection (const text_t &collection);
  void remove_collection (const text_t &collection, ostream& logout);

  void add_collection (const text_t &collection, 
		       const text_t &gsdlhome, 
		       const text_t& collecthome);

  void add_collection_group(const text_t& collection, 
			    const text_t& gsdlhome, 
			    const text_t& collecthome);

  void add_all_collection_groups (const text_t& gsdlhome, 
				  const text_t& collecthome);

  // return the total number of servers in the set
  int size();

  void getCollectionList(text_tarray &collist);

  // return the component map
  collectservermapclass servers();

  // return an individual collection server
  collectserver *getCollectServer(const text_t &collection)
    {
      return cservers.getcollectserver(collection);
    }

 protected:
  bool collection_is_collect_group (const text_t& collect_dir);
};

#endif
