/**********************************************************************
 *
 * collectoraction.h -- 
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_COLLECTOR_ACTION

#ifndef COLLECTORACTION_H
#define COLLECTORACTION_H

#include "wizardaction.h"
#include "receptionist.h"

class collectoraction : public wizardaction {
  
protected:

  bool do_mkcol;

  bool badsources;
  text_tmap failedsources;

  void set_fullnamemenu (displayclass &disp, cgiargsclass &args, 
			 recptprotolistclass *protos, ostream &logout);


  void set_inputsourceboxes (displayclass &disp, cgiargsclass &args, 
			     ostream &logout);

  text_t get_source_box (text_t inputarglist, int numboxes, 
			 text_t inputtypelist);

  void set_cfgfile (displayclass &disp, cgiargsclass &args, ostream &logout);


  void update_cfgfile_clone (cgiargsclass &args, ostream &logout);

  void update_cfgfile_partial (cgiargsclass &args, bool clone, ostream &logout);

  void update_cfgfile_complete (cgiargsclass &args, ostream &logout);


  void gsdl_mkcol (cgiargsclass &args, ostream &logout);



  bool check_sources (cgiargsclass &args, ostream &logout);

  text_t get_button (cgiargsclass &args, const text_t &thispage, 
		     const text_t &color, 
		     const text_t &type, bool enabled);


public:
  collectoraction ();
  virtual ~collectoraction ();

  text_t get_action_name () {return "collector";}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass *protos, ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

};

#endif //!COLLECTORACTION_H
#endif //GSDL_USE_COLLECTOR_ACTION
