/**********************************************************************
 *
 * os_process_windows.h -- Windows version of osprocess.  See os_process.h
 *                         for more details
 *
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef OS_PROCESS_WINDOWS_H
#define OS_PROCESS_WINDOWS_H

#ifdef __WIN32__

#include "os_process.h"

#include <windows.h> 

class osprocesswindows : public osprocess
{
public:
  osprocesswindows(OSProcessPipeMode mode,
		   char* prog_name, char* argv[]=NULL, char* envp[]=NULL);
  virtual ~osprocesswindows();

  virtual int read(char* buffer, const int buffer_len);
  virtual int write(char* buffer, const int buffer_len);

  virtual void wait();

  virtual bool close_write_pipe(OSProcessWarnStatus warn_status=withWarning);
  virtual bool close_read_pipe(OSProcessWarnStatus warn_status=withWarning);

protected:
  PROCESS_INFORMATION pi_;

  HANDLE child_stdin_write_;
  HANDLE child_stdout_read_;
};

#endif

#endif
