/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.IconRowHeader;

public class FoldingAwareIconRowHeader
extends IconRowHeader {
    public FoldingAwareIconRowHeader(RSyntaxTextArea rSyntaxTextArea) {
        super(rSyntaxTextArea);
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.textArea == null) {
            return;
        }
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        FoldManager foldManager = rSyntaxTextArea.getFoldManager();
        if (!foldManager.isCodeFoldingSupportedAndEnabled()) {
            super.paintComponent(graphics);
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, this.visibleRect.y, this.width, this.visibleRect.height);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(graphics);
            return;
        }
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        int n4 = this.textArea.getLineHeight();
        int n5 = (this.visibleRect.y - this.textAreaInsets.top) / n4;
        n5 += foldManager.getHiddenLineCountAbove(n5, true);
        int n6 = n5 * n4 + this.textAreaInsets.top;
        if (this.activeLineRangeStart > -1 && this.activeLineRangeEnd > -1) {
            Color color = this.getActiveLineRangeColor();
            graphics.setColor(color);
            try {
                n3 = rSyntaxTextArea.yForLine(this.activeLineRangeStart);
                if (n3 > -1) {
                    int n7;
                    int n8 = rSyntaxTextArea.yForLine(this.activeLineRangeEnd);
                    if (n8 == -1) {
                        n8 = n3;
                    }
                    n8 += n4 - 1;
                    for (n2 = n3; n2 <= n8; n2 += 2) {
                        n = Math.min(n8, n2 + this.getWidth());
                        n7 = n - n2;
                        graphics.drawLine(0, n2, n7, n);
                    }
                    for (n = 2; n < this.getWidth(); n += 2) {
                        n7 = n3 + this.getWidth() - n;
                        graphics.drawLine(n, n3, this.getWidth(), n7);
                    }
                    if (n3 >= n6 && n3 < n6 + this.visibleRect.height) {
                        graphics.drawLine(0, n3, this.getWidth(), n3);
                    }
                    if (n8 >= n6 && n8 < n6 + this.visibleRect.height) {
                        graphics.drawLine(0, n8, this.getWidth(), n8);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (this.trackingIcons != null) {
            int n9 = this.textArea.getLineCount() - 1;
            for (n3 = this.trackingIcons.size() - 1; n3 >= 0; --n3) {
                IconRowHeader.GutterIconImpl gutterIconImpl = this.getTrackingIcon(n3);
                n2 = gutterIconImpl.getMarkedOffset();
                if (n2 < 0 || n2 > document.getLength()) continue;
                n = element.getElementIndex(n2);
                if (n <= n9 && n >= n5) {
                    try {
                        Icon icon;
                        int n10 = rSyntaxTextArea.yForLine(n);
                        if (n10 < n6 || n10 >= n6 + this.visibleRect.height || (icon = gutterIconImpl.getIcon()) == null) continue;
                        int n11 = n10 + (n4 - icon.getIconHeight()) / 2;
                        gutterIconImpl.getIcon().paintIcon(this, graphics, 0, n11);
                        n9 = n - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    continue;
                }
                if (n < n5) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics graphics) {
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int n2 = element.getElementIndex(n);
        int n3 = this.visibleRect.y;
        int n4 = this.visibleRect.y + this.visibleRect.height;
        int n5 = this.textArea.getLineHeight();
        if (this.trackingIcons != null) {
            int n6 = this.textArea.getLineCount() - 1;
            for (int i = this.trackingIcons.size() - 1; i >= 0; --i) {
                IconRowHeader.GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                int n7 = gutterIconImpl.getMarkedOffset();
                if (n7 < 0 || n7 > document.getLength()) continue;
                int n8 = element.getElementIndex(n7);
                if (n8 <= n6 && n8 >= n2) {
                    try {
                        Icon icon;
                        int n9 = rSyntaxTextArea.yForLine(n8);
                        if (n9 < n3 || n9 >= n4 || (icon = gutterIconImpl.getIcon()) == null) continue;
                        int n10 = n9 + (n5 - icon.getIconHeight()) / 2;
                        gutterIconImpl.getIcon().paintIcon(this, graphics, 0, n10);
                        n6 = n8 - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    continue;
                }
                if (n8 < n2) break;
            }
        }
    }
}

