/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.core;

import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.TransformingReceptionist;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultReceptionist
extends TransformingReceptionist {
    static Logger logger = Logger.getLogger((String)DefaultReceptionist.class.getName());

    protected void addExtraInfo(Element page) {
        Element service_list;
        Element coll_description;
        super.addExtraInfo(page);
        Element page_request = (Element)GSXML.getChildByTagName(page, "pageRequest");
        String action = page_request.getAttribute("action");
        if (action.equals("s")) {
            logger.error((Object)"HACK: don't ask for coll info if system action");
            return;
        }
        logger.debug((Object)("add extra info, page request=" + XMLConverter.getString(page_request)));
        Element param_list = (Element)GSXML.getChildByTagName(page_request, "paramList");
        if (param_list == null) {
            logger.debug((Object)" no param list, assuming home page");
            return;
        }
        Element coll_param = GSXML.getNamedElement(param_list, "param", "name", "c");
        if (coll_param == null) {
            logger.debug((Object)" coll param is null, returning");
            return;
        }
        String coll_name = coll_param.getAttribute("value");
        String lang = page_request.getAttribute("lang");
        String uid = page_request.getAttribute("uid");
        boolean get_service_description = false;
        Element page_response = (Element)GSXML.getChildByTagName(page, "pageResponse");
        if (this.language_list != null) {
            page_response.appendChild(this.language_list);
        }
        if ((coll_description = (Element)GSXML.getChildByTagName(page_response, "collection")) == null) {
            coll_description = (Element)GSXML.getChildByTagName(page_response, "serviceCluster");
        }
        if (coll_description == null) {
            Element coll_about_message = this.doc.createElement("message");
            Element coll_about_request = GSXML.createBasicRequest(this.doc, "describe", coll_name, lang, uid);
            coll_about_message.appendChild(coll_about_request);
            Node coll_about_response_message = this.mr.process(coll_about_message);
            Element coll_about_response = (Element)GSXML.getChildByTagName(coll_about_response_message, "response");
            if (coll_about_response == null) {
                return;
            }
            coll_description = (Element)GSXML.getChildByTagName(coll_about_response, "collection");
            if (coll_description == null) {
                coll_description = (Element)GSXML.getChildByTagName(coll_about_response, "serviceCluster");
            }
            if (coll_description == null) {
                logger.error((Object)" no collection description, returning");
                return;
            }
            coll_description = (Element)this.doc.importNode(coll_description, true);
            page_response.appendChild(coll_description);
            get_service_description = true;
        }
        if ((service_list = (Element)GSXML.getChildByTagName(coll_description, "serviceList")) == null) {
            logger.error((Object)" no service list, returning");
            return;
        }
        NodeList services = service_list.getElementsByTagName("service");
        if (services.getLength() == 0) {
            logger.error((Object)("DefaultReceoptionist: no services found for colllection/cluster " + coll_name));
            return;
        }
        if (!get_service_description) {
            int i;
            Element test_s = (Element)services.item(0);
            for (i = 1; i < services.getLength() && (test_s.getAttribute("type").equals("retrieve") || test_s.getAttribute("type").equals("oai")); ++i) {
                test_s = (Element)services.item(i);
            }
            if (i == services.getLength()) {
                return;
            }
            if (GSXML.getChildByTagName(test_s, "displayItem") != null) {
                return;
            }
        }
        Element info_message = this.doc.createElement("message");
        for (int i = 0; i < services.getLength(); ++i) {
            Element c = (Element)services.item(i);
            String name = c.getAttribute("name");
            String address = GSPath.appendLink(coll_name, name);
            Element info_request = GSXML.createBasicRequest(this.doc, "describe", address, lang, uid);
            Element req_param_list = this.doc.createElement("paramList");
            req_param_list.appendChild(GSXML.createParameter(this.doc, "subset", "displayItemList"));
            info_request.appendChild(req_param_list);
            info_message.appendChild(info_request);
        }
        Element info_response = (Element)this.mr.process(info_message);
        NodeList service_responses = info_response.getElementsByTagName("response");
        if (services.getLength() != service_responses.getLength()) {
            logger.error((Object)" didn't get a response for each service - somethings gone wrong!");
        } else {
            for (int i = 0; i < services.getLength(); ++i) {
                Element c1 = (Element)services.item(i);
                Element c2 = (Element)GSXML.getChildByTagName((Element)service_responses.item(i), "service");
                if (c1 != null && c2 != null && c1.getAttribute("name").equals(c2.getAttribute("name"))) {
                    GSXML.mergeElements(c1, c2);
                    continue;
                }
                logger.error((Object)" response does not correspond to request!");
            }
        }
    }
}

