/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.AbstractGS2DocumentRetrieve;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GS2LuceneRetrieve
extends AbstractGS2DocumentRetrieve {
    static Logger logger = Logger.getLogger((String)GS2LuceneRetrieve.class.getName());
    protected static final String DOC_LEVEL = "Doc";
    protected static final String SEC_LEVEL = "Sec";
    protected static final String ID_ATT = "gs2:id";
    private static final String LEVEL_PARAM = "level";
    private static final String DEFAULT_LEVEL_ELEM = "defaultLevel";
    private String default_level = null;
    private String text_dir = null;
    private boolean text_available = true;

    public void cleanUp() {
        super.cleanUp();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring GS2LuceneRetrieve...");
        this.text_dir = GSFile.collectionIndexDir(this.site_home, this.cluster_name) + File.separatorChar + "text" + File.separatorChar;
        if (!new File(this.text_dir).isDirectory()) {
            logger.error((Object)("Text directory " + this.text_dir + " does not exist, will be unable to retrieve text for " + this.cluster_name));
            this.text_available = false;
            return true;
        }
        Element def = (Element)GSXML.getChildByTagName(info, DEFAULT_LEVEL_ELEM);
        if (def != null) {
            this.default_level = def.getAttribute("shortname");
        }
        if (this.default_level == null || this.default_level.equals("")) {
            logger.error((Object)("Default level not specified for " + this.cluster_name + ", assuming " + DOC_LEVEL));
            this.default_level = DOC_LEVEL;
        }
        return true;
    }

    protected Element getNodeContent(String doc_id, String lang) throws GSException {
        String doc_content = this.getTextString("TextRetrievalError", lang);
        try {
            if (!this.text_available) {
                throw new Exception("No text directory available");
            }
            String doc_num = this.coll_db.OID2Docnum(doc_id);
            if (doc_num == null || doc_num.equals("")) {
                throw new Exception("OID " + doc_id + " couldn't be converted to lucene doc num");
            }
            DBInfo info = this.coll_db.getInfo(OID.getTop(doc_id));
            if (info == null) {
                throw new Exception("Couldn't get database entry for " + OID.getTop(doc_id));
            }
            String archivedir = info.getInfo("archivedir");
            File doc_xml_file = new File(this.text_dir + archivedir + File.separatorChar + "doc.xml");
            if (!doc_xml_file.isFile()) {
                throw new Exception("Doc XML file " + doc_xml_file.getPath() + " does not exist");
            }
            Document doc_xml_doc = this.converter.getDOM(doc_xml_file, "utf-8");
            if (doc_xml_doc == null) {
                throw new Exception("Couldn't parse file " + doc_xml_file.getPath());
            }
            Element full_document = doc_xml_doc.getDocumentElement();
            if (full_document == null) {
                throw new Exception("Couldn't parse file " + doc_xml_file.getPath());
            }
            Element current_section = null;
            current_section = this.default_level.equals(DOC_LEVEL) ? full_document : GSXML.getNamedElement(full_document, SEC_LEVEL, ID_ATT, doc_num);
            if (current_section == null) {
                throw new Exception("Couldn't find section " + doc_num + " in file " + doc_xml_file.getPath());
            }
            doc_content = GSXML.getNodeText(current_section);
            doc_content = doc_content == null ? "" : this.resolveTextMacros(doc_content, doc_id, lang);
        }
        catch (Exception e) {
            logger.error((Object)("Error trying to get document text for " + doc_id + " in collection " + this.cluster_name + ": " + e));
        }
        Element content_node = this.doc.createElement("nodeContent");
        Text t = this.doc.createTextNode(doc_content);
        content_node.appendChild(t);
        return content_node;
    }
}

