/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractSearch;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.Misc;
import org.w3c.dom.Element;

public class IViaSearch
extends AbstractSearch {
    static Logger logger = Logger.getLogger((String)IViaSearch.class.getName());
    protected static final String IM_HITS_PARAM = "no_of_records_per_page";
    protected static final String IM_START_PAGE_PARAM = "start_page_no";
    protected String ivia_server_url = null;
    protected ArrayList index_ids = null;

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        Element server_elem = (Element)GSXML.getChildByTagName(info, "iViaServer");
        if (server_elem == null) {
            logger.error((Object)"no iViaServer element found");
            return false;
        }
        this.ivia_server_url = server_elem.getAttribute("url");
        if (this.ivia_server_url.equals("")) {
            logger.error((Object)"no url for the iViaServer element");
            return false;
        }
        this.does_paging = true;
        this.does_multi_index_search = true;
        this.default_index = ",kw,au,su,ti,de,fu,";
        this.index_ids = new ArrayList();
        this.index_ids.add("kw");
        this.index_ids.add("au");
        this.index_ids.add("su");
        this.index_ids.add("ti");
        this.index_ids.add("de");
        this.index_ids.add("fu");
        return true;
    }

    protected Element processTextQuery(Element request) {
        String start_page;
        String hits_per_page;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", "TextQuery");
        result.setAttribute("type", "process");
        Element doc_node_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_node_list);
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String query = (String)params.get("query");
        if (query == null || query.equals("")) {
            return result;
        }
        query = query.replaceAll("\\s+", "+");
        String url_string = this.ivia_server_url + "/cgi-bin/canned_search?theme=gsdl3&query=" + query;
        String fields = (String)params.get("index");
        if (!(fields = this.checkFieldParam(fields)).equals("")) {
            url_string = url_string + "&fields=" + fields;
        }
        if ((hits_per_page = (String)params.get("hitsPerPage")) != null && !hits_per_page.equals("")) {
            url_string = url_string + "&no_of_records_per_page=" + hits_per_page;
        }
        if ((start_page = (String)params.get("startPage")) != null && !start_page.equals("")) {
            url_string = url_string + "&start_page_no=" + start_page;
        }
        String results_num = null;
        String doc_ids = null;
        BufferedReader reader = null;
        try {
            logger.debug((Object)("sending " + url_string));
            reader = Misc.makeHttpConnection(url_string);
            results_num = reader.readLine();
            doc_ids = reader.readLine();
        }
        catch (MalformedURLException e) {
            GSXML.addError(this.doc, result, "Malformed URL: " + url_string);
            return result;
        }
        catch (IOException e) {
            GSXML.addError(this.doc, result, "IOException during connection to " + url_string + ": " + e.toString());
            return result;
        }
        if (!results_num.startsWith("Resources: ") || !doc_ids.startsWith("Ids: ")) {
            logger.error((Object)"badly formatted results:");
            StringBuffer result_string = new StringBuffer();
            result_string.append("Error: badly formatted result from IVia server:\n ");
            result_string.append(results_num);
            result_string.append(doc_ids);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    result_string.append(line);
                }
            }
            catch (Exception e) {
                result_string.append("Exception: " + e);
            }
            GSXML.addError(this.doc, result, result_string.toString());
            return result;
        }
        results_num = results_num.substring(11);
        doc_ids = doc_ids.substring(5).trim();
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        long numdocs = Long.parseLong(results_num);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "" + numdocs);
        String[] ids = doc_ids.split(" ");
        for (int d = 0; d < ids.length; ++d) {
            Element doc_node = this.doc.createElement("documentNode");
            doc_node.setAttribute("nodeID", ids[d]);
            doc_node_list.appendChild(doc_node);
        }
        return result;
    }

    protected String checkFieldParam(String fields) {
        if (fields == null) {
            return "";
        }
        StringBuffer new_fields = new StringBuffer();
        String[] ids = fields.split(",");
        for (int i = 0; i < ids.length; ++i) {
            if (!this.index_ids.contains(ids[i])) continue;
            new_fields.append(ids[i]);
            new_fields.append(",");
        }
        if (new_fields.length() == 0) {
            return "";
        }
        return new_fields.toString();
    }

    protected void getIndexData(ArrayList index_ids, ArrayList index_names, String lang) {
        index_ids.addAll(this.index_ids);
        index_names.add(this.getTextString("param.index.kw", lang));
        index_names.add(this.getTextString("param.index.au", lang));
        index_names.add(this.getTextString("param.index.su", lang));
        index_names.add(this.getTextString("param.index.ti", lang));
        index_names.add(this.getTextString("param.index.de", lang));
        index_names.add(this.getTextString("param.index.fu", lang));
    }
}

