/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.AbstractSearch;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;

public class MapSearch
extends AbstractSearch {
    static Logger logger = Logger.getLogger((String)MapSearch.class.getName());
    protected String files_home_dir = null;
    protected static final String FREQ_ATT = "freq";
    public static Hashtable hashNames;

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring MapSearch...");
        this.files_home_dir = GSFile.collectionIndexDir(this.site_home, this.cluster_name) + File.separator + "assoc" + File.separator;
        hashNames = new Hashtable();
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.files_home_dir + "hashnames.dat"));
            hashNames = (Hashtable)in.readObject();
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException cnf) {
            cnf.printStackTrace();
            return false;
        }
        return true;
    }

    protected void getIndexData(ArrayList index_ids, ArrayList index_names, String lang) {
        index_ids.add("idx");
        index_names.add("maps");
    }

    protected Element processTextQuery(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", "TextQuery");
        result.setAttribute("type", "process");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String searchTerm = (String)params.get("query");
        if (searchTerm == null || searchTerm.equals("")) {
            return result;
        }
        searchTerm = searchTerm.replace(' ', '+');
        int place = -1;
        while (searchTerm.indexOf("&quot;", place + 1) != -1) {
            place = searchTerm.indexOf("&quot;", place + 1);
            searchTerm = searchTerm.substring(0, place) + "\"" + searchTerm.substring(place + 6, searchTerm.length());
        }
        place = -1;
        while (searchTerm.indexOf(34, place + 1) != -1) {
            if (searchTerm.indexOf(34, (place = searchTerm.indexOf(34, place + 1)) + 1) != -1) {
                searchTerm = searchTerm.substring(0, place) + searchTerm.substring(place, searchTerm.indexOf(34, place + 1)).replace('+', ' ') + searchTerm.substring(searchTerm.indexOf(34, place + 1), searchTerm.length());
            }
            place = searchTerm.indexOf(34, place);
        }
        place = 0;
        while (place != -1) {
            if ((place = searchTerm.indexOf(34, place)) == -1) continue;
            searchTerm = searchTerm.substring(0, place) + searchTerm.substring(place + 1, searchTerm.length());
            place = 0;
        }
        int words = 1;
        place = 0;
        while (place != -1) {
            if ((place = searchTerm.indexOf(43, place + 1)) == -1) continue;
            ++words;
        }
        place = 0;
        String[] terms = new String[words];
        String[] terms_freq = new String[words];
        for (int i = 0; i < words - 1; ++i) {
            terms[i] = searchTerm.substring(place, searchTerm.indexOf(43, place));
            place = searchTerm.indexOf(43, place) + 1;
        }
        terms[words - 1] = searchTerm.substring(place, searchTerm.length());
        Object[] nameArray = new Object[1];
        LinkedList<Object> mapList = new LinkedList<Object>();
        LinkedList placeList = new LinkedList();
        String readString = "";
        for (int i = 0; i < words; ++i) {
            terms[i] = terms[i].toUpperCase();
        }
        for (int k = 0; k < words; ++k) {
            int nameArraySize = 0;
            nameArray = (Object[])hashNames.get(terms[k].toLowerCase());
            if (nameArray != null) {
                logger.debug(hashNames.get(terms[k].toLowerCase()));
                nameArraySize = Arrays.asList(nameArray).size();
            }
            for (int h = 0; h < nameArraySize; ++h) {
                String nameData = (String)nameArray[h];
                double xco = Double.parseDouble(nameData.substring(nameData.lastIndexOf(96) + 1, nameData.length()));
                double yco = Double.parseDouble(nameData.substring(nameData.lastIndexOf(96, nameData.lastIndexOf(96) - 1) + 2, nameData.lastIndexOf(96)));
                try {
                    BufferedReader inmap = new BufferedReader(new FileReader(this.files_home_dir + "files" + File.separator + "maps" + File.separator + "mapdata.txt"));
                    inmap.readLine();
                    while (inmap.ready()) {
                        readString = inmap.readLine();
                        int indexer = 0;
                        indexer = readString.indexOf(96) + 2;
                        double ytop = Double.parseDouble(readString.substring(indexer, indexer + 5));
                        indexer = readString.indexOf(96, indexer) + 1;
                        double xtop = Double.parseDouble(readString.substring(indexer, indexer + 6));
                        indexer = readString.indexOf(96, indexer) + 2;
                        double ybot = Double.parseDouble(readString.substring(indexer, indexer + 5));
                        indexer = readString.indexOf(96, indexer) + 1;
                        double xbot = Double.parseDouble(readString.substring(indexer, indexer + 6));
                        if (!(xco >= xtop) || !(xco < xbot) || !(yco >= ytop) || !(yco < ybot)) continue;
                        mapList.add(readString + "```" + nameData);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Object[] mapListArray = mapList.toArray();
        Arrays.sort(mapListArray);
        mapList.clear();
        for (int mla = 0; mla < Array.getLength(mapListArray); ++mla) {
            mapList.addFirst(mapListArray[mla]);
        }
        LinkedList<Object> tempList = new LinkedList<Object>();
        String mapNumber = "";
        String[] currentMap = new String[]{"", ""};
        int mapFreq = 0;
        while (mapList.size() > 0) {
            readString = (String)mapList.removeFirst();
            if (mapNumber.equals(readString.substring(0, readString.indexOf(46)))) {
                currentMap[1] = currentMap[1] + readString.substring(readString.indexOf("```"), readString.length());
                ++mapFreq;
                continue;
            }
            if (!currentMap[0].equals("")) {
                tempList.add(currentMap[0] + "`" + mapFreq + currentMap[1]);
            }
            currentMap[0] = readString.substring(0, readString.indexOf("```"));
            currentMap[1] = readString.substring(readString.indexOf("```"), readString.length());
            mapNumber = readString.substring(0, readString.indexOf(46));
            mapFreq = 1;
        }
        if (!currentMap[0].equals("")) {
            tempList.add(currentMap[0] + "`" + mapFreq + currentMap[1]);
        }
        int totalDocs = tempList.size();
        Object[] tempListArray = tempList.toArray();
        Arrays.sort(tempListArray, new MapResultSorter());
        tempList.clear();
        for (int tla = 0; tla < Array.getLength(tempListArray); ++tla) {
            tempList.add(tempListArray[tla]);
        }
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "" + totalDocs);
        GSXML.addMetadata(this.doc, metadata_list, "numDocsReturned", "" + totalDocs);
        Element document_list = this.doc.createElement("documentNodeList");
        result.appendChild(document_list);
        for (int d = 0; d < totalDocs; ++d) {
            String doc_id = (String)tempList.get(d);
            Element doc_node = this.doc.createElement("documentNode");
            doc_node.setAttribute("nodeID", doc_id);
            doc_node.setAttribute("nodeType", "thumbnail");
            doc_node.setAttribute("docType", "map");
            document_list.appendChild(doc_node);
        }
        Element term_list = this.doc.createElement("termList");
        result.appendChild(term_list);
        for (int t = 0; t < words; ++t) {
            String term = terms[t];
            Element term_elem = this.doc.createElement("term");
            term_elem.setAttribute("name", term);
            term_elem.setAttribute(FREQ_ATT, "" + terms_freq[t]);
            term_list.appendChild(term_elem);
        }
        return result;
    }

    public class MapResultSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int secondInt;
            String first = (String)o1;
            String second = (String)o2;
            first = first.substring(first.lastIndexOf(96, first.indexOf("```") - 1) + 1, first.indexOf("```"));
            second = second.substring(second.lastIndexOf(96, second.indexOf("```") - 1) + 1, second.indexOf("```"));
            int firstInt = Integer.parseInt(first);
            if (firstInt > (secondInt = Integer.parseInt(second))) {
                return -1;
            }
            if (firstInt == secondInt) {
                return 0;
            }
            return 1;
        }
    }
}

