' This script is based on https://serverfault.com/questions/9038/run-a-bat-file-in-a-scheduled-task-without-a-window/9042
' to run a given command in the background.
' Usage: CScript //Nologo background-launcher.vbs <Program-To-Launch-In-Background> [arg1] [arg2] ... [argN]
' Going by docx2html.vbs, I think this script must be launched using CScript to make use of stderr
Option Explicit

' Reading on VBScript:
' The Option Explicit statement forces the explicit declaration of all variables using the Dim, Private, Public, or ReDim statements.
' Cmdline args: https://ss64.com/vb/syntax-args.html and https://ss64.com/vb/arguments.html for args.length
' Variables: https://www.tutorialspoint.com/vbscript/vbscript_variables.htm
' Set is used to store object refs in a variable: https://www.promotic.eu/en/pmdoc/ScriptLangs/VBScript/Statmn/Set.htm
' Chr(34) is double quote, Chr(32) is space
' Loops: https://ss64.com/vb/do.html

Dim WinScriptHost
Set WinScriptHost = CreateObject("WScript.Shell")


Dim objStdErr, args
Set objStdErr = WScript.StdErr
args = WScript.Arguments.Count
If args < 1 then
  'WScript.Echo Usage: CScript //Nologo background-launcher.vbs <Program-To-Launch-In-Background> [arg1] [arg2] ... [argN]
  objStdErr.Write ("ERROR. Usage: CScript //Nologo " & WScript.ScriptName & " <Program-To-Launch-In-Background> [arg1] [arg2] ... [argN]" & vbCrLf)
  WScript.Quit
end If


Dim strCommand
Dim i
strCommand = Chr(34) & WScript.Arguments.Item(0) & Chr(34)
If args > 1 then
	i = 1
	Do
	  strCommand = strCommand & Chr(32) & Chr(34) & WScript.Arguments.Item(i) & Chr(34)
	  i = i + 1
	Loop Until i = WScript.Arguments.Length
end If
'e.g. WinScriptHost.Run Chr(34) & "Notepad.exe" & Chr(34) & Chr(32) & Chr(34) & "C:\Users\Anupama\bla.html" & Chr(34), 1

' Set 2nd arg to 0 to run invisibly, pass additional 1 as 3rd arg if wanting to wait until spawned process returns
' See https://docs.microsoft.com/en-us/previous-versions//d5fk67ky(v=vs.85)?redirectedfrom=MSDN	
WinScriptHost.Run strCommand, 0
' e.g. To run Notepad in background but with its window visible pass in 1:
' WinScriptHost.Run Chr(34) & "Notepad.exe" & Chr(34), 1

Set WinScriptHost = Nothing
