/**********************************************************************
 *
 * OIDtools.h -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef OIDTOOLS_H
#define OIDTOOLS_H

#include "text_t.h"


void get_oid (const text_t &OID, text_t &to, size_t level);

// returns (in top) the top level of OID (i.e. everything
// up until the first dot)
void get_top (const text_t &OID, text_t &top);

// checks if OID is top level (i.e. contains no dots)
bool is_top (const text_t &OID);

// get_parents_array loads the parents array with all the parents of the
// document or classification specified by OID (not including OID itself)
void get_parents_array (const text_t &OID, text_tarray &parents);

// get_parent returns the parent of the document or classification
// specified by OID
text_t get_parent (const text_t& OID);

// takes an OID like ".2.3 and replaces the " with parent
void translate_parent (text_t &OID, const text_t &parent);

// shrink_parent does the opposite to translate_parent
void shrink_parent (text_t &OID);

// checks if OID uses ".fc", ".lc", ".pr", ".ns",
// or ".ps" syntax (first child, last child, parent,
// next sibling, previous sibling)
bool needs_translating (const text_t &OID);

// strips the ".fc", ".lc", ".pr", ".ns",
// or ".ps" suffix from the end of OID
void strip_suffix (text_t &OID);

// is_child_of returns true if OID2 is a child of OID1
bool is_child_of(const text_t &OID1, const text_t &OID2);


#endif
