/**********************************************************************
 *
 * oaiaction.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _oaiaction_h_
#define _oaiaction_h_
// standard c++ includes
//#include <ostream.h>

// generic gsdl stuff
#include "text_t.h"
#include "htmlutils.h" // For converting characters in a string to URL encoding. 

// connection to a receptionist
#include "receptionist.h"

// oaistuff
#include "oaiargs.h"
#include "oaiconfig.h"
#include <time.h>

// Define hours & mins that separate local time from UTC (GMT) time; +ve is ahead of UTC, -ve behind
#define _LOCALTIME_ "+12:00"

class oaiaction
{
 public:
  oaiaction(const text_t &name);
  
  virtual void setConfiguration(oaiconfig *config) { this->configuration = config; }
  text_t getName();
  virtual text_t calcEarliestDatestamp(recptproto *protocol, oaiargs &params);
  text_t parseDatestamp(time_t &rawtime);// Convert date from raw time_t format to the string YYYY-MM-DD
  void   getResponseDate(text_t &date);  // Get the response date in UTC (GMT) time, plus local offset
  void   getRequestURL(oaiargs &params, text_t &requestURL); // Get the URL of the request
  void   getResponse(ostream &output, recptproto *protocol, oaiargs &params);
  void   output_action_tag(ostream &output, bool openTag);
  void   output_record_header(ostream &output, const text_t &oaiLabel, const text_t &lastModified, 
			      const text_t &deleted_status, const text_tarray &memberOf, int oaiVersion);
  void   output_error(ostream &output, text_t &errorType); // Output any error conditions
  bool   formatNotSupported(text_t &metaFormat);           // Return true if the supplied metadataPrefix
                                                           // format is not supported
  void   setErrorType(text_t &err){this->errorType = err;};
  text_t getErrorType(){return this->errorType;};
  void   getLastModifiedDate(ResultDocInfo_t &doc_info, text_t &lastModified);
  bool   getMeta(ResultDocInfo_t &doc_info, const text_t &metaname, text_t &metavalue);
  bool   inDateRange(const text_t &from, const text_t &until, const text_t &collection, 
		     const text_t &OID, recptproto *protocol, ostream &logout);
  /******
   * The following function sets the isInnerObject flag. It is used by the nested recordaction
   * object in the listrecs object. This flag provides a means for identifying whether the 
   * recordaction object is acting on its own or through a listrecsaction object. This is 
   * to allow for appropriate handling of errors regarding unsupported metadata formats. If 
   * we are using verb=GetRecord and the supplied metadata format is not supported by this 
   * particular item, then an error must be thrown. But if were using verb=ListRecords, we only
   * want to exclude the item in question from the list, not throw an error.
   */
  void       setAsInnerObject() { this->isInnerObject = true;}

 protected:
  oaiconfig *configuration;
  virtual    bool validateAction(recptproto *protocol, oaiargs &params); // Check that this is a valid action
  virtual    bool output_content(ostream &output, recptproto *protocol, oaiargs &params) = 0;
  bool       isInnerObject;
  text_t     name;
  text_t     errorType;
  ostream  * logout;
  text_t	mEarliestDatestamp;
};
#endif

