/**************************************************************************
 *
 * Weights.h -- Dealing with document weights
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef WEIGHTS_H
#define WEIGHTS_H

#include "mglong.h"
#include <stdio.h>


class ApproxWeightsData {
public:
  unsigned char bits;
  mg_u_long mask;
  double L;
  double B;
  mg_u_long numLevelDocs;
  mg_u_long *weightBuf;
  float *table;   // precomputed translation table
  
  ApproxWeightsData ();
  ~ApproxWeightsData ();

  void Free (); // frees any allocated memory
  
  bool Read (FILE *approxWeightsFile, mg_u_long diskPtr,
	     mg_u_long _numLevelDocs);

  float GetLowerApproxDocWeight (mg_u_long levelDocNum);
};


// diskPtr points to the start of the exact document weights
// for this level
float GetExactDocWeight (FILE *exactWeightsFile, mg_u_long diskPtr,
			 mg_u_long levelDocNum);


#endif
