/**********************************************************************
 *
 * cnfgator.cpp -- 
 *
 * Copyright (C) 2001-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace/std/iostream>
#  include <ospace/std/fstream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#  include <fstream.h>
#else
#  include <iostream>
#  include <fstream>
#endif

#include "cnfgator.h"

configurator::configurator(configurable *configureobject) {
  configureobjs.push_back(configureobject);
}

void configurator::add_configurable(configurable *configureobject) {
  configureobjs.push_back(configureobject);
}

bool configurator::configure(const text_t &filename) {
  // read in the build configuration file
  text_t key;
  text_tarray cfgline;
  char *cstr = filename.getcstr();
  ifstream confin (cstr);
  delete []cstr;

  if (confin) {
    while (read_cfg_line(confin, cfgline) >= 0) {
      if (cfgline.size () >= 2) {
	key = cfgline[0];
	cfgline.erase(cfgline.begin());

	// configure the configurables
	configurable *configureObject;
	vector<configurable *>::iterator configureIter = configureobjs.begin();

	while (configureIter != configureobjs.end()) {
	  configureObject = *configureIter;
	  ++configureIter;
    
	  configureObject->configure (key, cfgline);
	}
      }
    }
    confin.close ();
    return true;
  }
  return false;
}
