/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.util;

public class PatternTokenizer {
    private int index;
    private String content;
    private String pattern;
    public PatternTokenizer(String content, String pattern) {
	this.content = content;
	this.index = 0;
	this.pattern = pattern;
    }
    public boolean hasMoreTokens() {
	return (index != -1 && content.length() - index > 0);
    }
    public String nextToken() {
	// Special case when index is zero
	if(index == 0) {
	    index = content.indexOf(pattern);
	    // No occurance of pattern, return whole string
	    if(index == -1) {
		return content;
	    }
	    // Return the fragment from 0 to index
	    else {
		return content.substring(0, index);
	    }
	}
	// Otherwise
	else {
	    // We must first skip the pattern, as it should be at the head of our current view into content
	    index = index + pattern.length();
	    int end_index = content.indexOf(pattern, index);
	    String fragment;
	    // No occurance of pattern, return fragment from index to length
	    if(end_index == -1) {
		fragment = content.substring(index);
	    }
	    // Return the fragment from index to end index, then set index to end index
	    else {
		fragment = content.substring(index, end_index);
	    }
	    index = end_index;
	    return fragment;
	}
    }    
}
