/* ------------------------------------------------------------------- */
/* danMARC    : Convert a metatag struct to DANMARC2                   */
/*                                                                     */
/* Specs      : http://www.bibsys.no/meta/d2m/dancross.html            */
/*                                                                     */
/* Author     : Ole Husby                                              */
/* Last update: 1998-09-30                                             */
/* ------------------------------------------------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "d2m.h" 



/* Splits subject heading on ":". First occurence go into $a, second into $v */ 

int split_dk5(char *str)
{
  char *p, *q, subtag[5];

  if (!strstr(str, ":"))
    return 1;

  p = (char *) malloc(strlen(str) + 50);
  *p = 0;
  *subtag = 0;

  q = strtok(str, ":");
  if (q)
  {
    while ( ( q[0] == ' ' ) && ( strlen(q) ) )
      q++;

    while( ( q[strlen(q) - 1] == ' ' ) && ( strlen(q) ) )
      q[strlen(q) - 1] = '\0';

    if (*q)
    {
      strcat(p, subtag);
      strcat(p, q);
      strcpy(subtag, " $v ");
    }
  }

  strcpy(str, p);
  free(p);

  return 1;
}




int danMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], type_tag[4];
  int i;

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
      {
        strcat(mr->partitle, "$a ");
        strcat(mr->partitle, mt->value);

      }
      else
      {
        mr->ntitles++;
        strcpy(pre, "245  $a");
      }
    }
  }

  else if (strcasecmp(mt->name, "creator") == 0)
  {
    if ( strcasecmp(mt->type, "personal") == 0) 
    {
      strcpy(pre, "700  $a");
      split_name(mt->value);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }


  else if (strcasecmp(mt->name, "publisher") == 0)
    strcpy(pre, "260  $b");

  else if (strcasecmp(mt->name, "description") == 0)
    strcpy(pre, "504  $a");

  else if (strncasecmp(mt->name, "contributor", 11) == 0)   
  {
    if ( strcasecmp(mt->type, "personal") == 0 )
    {
      strcpy(pre, "700  $a");
      split_name(mt->value);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }

  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "559  $a");
    else if (strcasecmp(mt->type , "spatial") == 0)
    {
      strcpy(pre, "633  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->type,  "temporal") == 0)
    {
      strcpy(pre, "334  $b");
      for (i = 0; i < strlen(mt->value); i++)
      {
        if (!isdigit(mt->value[i]))
        {
          strcpy(pre, "334  $a");
        }
      } 
    }
  }

  else if (strcasecmp(mt->name, "source") == 0)
    strcpy(pre, "523  $a");

  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "856  $3 rights $u");
    else
      strcpy(pre, "518  $a");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $g urn:");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "021  $a");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "022  $a");
    else if (strcasecmp(mt->scheme, "isrc") == 0)
      strcpy(pre, "024  $a");
    else if (strcasecmp(mt->scheme, "ismn") == 0)
      strcpy(pre, "028  $a");
    else if (strcasecmp(mt->scheme, "isrn") == 0)
      strcpy(pre, "027  $a");
  }

  else if (strcasecmp(mt->name, "type") == 0)
    strcpy(pre, "505  $a");

  else if (strcasecmp(mt->name, "relation") == 0)
    strcpy(pre, "559  $a");

  else if (strcasecmp(mt->name, "language") == 0)  /* Only if repeated ! */
  {
    if (strcasecmp(mt->scheme, "z39.53") == 0)
    {
      strcpy(pre, "041  $a");
      put008(mr->s008, mt->value, F008_LANGUAGE);
    }
  }

  else if (strcasecmp(mt->name, "format") == 0)
  {
    if ( (!*mt->scheme)
      || (strcasecmp(mt->scheme, "imt") == 0)
      || (strcasecmp(mt->scheme, "mime") == 0) )
      strcpy(mr->fmat, mt->value); 
  }

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "631  $a");
    else if (strcasecmp(mt->scheme, "udc") == 0)
      strcpy(pre, "080  $a");
    else if (strcasecmp(mt->scheme, "lccs") == 0)
      strcpy(pre, "050  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
    else if (strcasecmp(mt->scheme, "nlm") == 0)
      strcpy(pre, "060  $a");
    else if (strcasecmp(mt->scheme, "agr") == 0)
      strcpy(pre, "662  $a");
    else if (strcasecmp(mt->scheme, "eudised") == 0)
      strcpy(pre, "661  $b");
    else if (strcasecmp(mt->scheme, "dbc") == 0)
      strcpy(pre, "666  $f");
    else if (strcasecmp(mt->scheme, "mesh") == 0)
      strcpy(pre, "690  $a");
    else if (strcasecmp(mt->scheme, "dk5") == 0)
    {
      strcpy(pre, "652  $m");
      split_dk5(mt->value);
    }
  }

  else if (strcasecmp(mt->name, "date") == 0)
  {
    if ( (!*mt->type) || ( strcasecmp(mt->type, "current") == 0) )
    {
      if ( (strncasecmp(mt->scheme, "ans", 3) == 0) 
         || (strncasecmp(mt->scheme, "iso", 3) == 0) )
      {
        if (find_year(mt->value))
        {
          strcpy(mr->year, mt->value);
          put008(mr->s008, mt->value, F008_DATE1);
        }
      }
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
