/**********************************************************************
 *
 * corbaproto.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef CORBAPROTO_H
#define CORBAPROTO_H

#include "gsdlconf.h"
#include "collectserver.h"
#include "recptproto.h"
#include "corbaiface.h"


using namespace gsdlInterface;

class corbaproto : public recptproto {
 private:
  corbaiface_var getCorbaClient();
 protected:
  collectservermapclass cservers;
  corbaiface_var        client;
  //CORBA::ORB_var        orb;
  //CORBA::BOA_var        boa;
  CORBA::Object_var     obj;
  text_t gsdlhome;
  text_t site_name;

 public:
  virtual ~corbaproto() {}
  corbaproto(char* site_name);

  // add_collectserver should be called for each collection server
  // before any configuration is done
  void add_collectserver (collectserver *thecserver) 
    {cservers.addcollectserver(thecserver);}

  // this configure will configure each of the collection servers
  void configure (const text_t &key, const text_tarray &cfgline, comerror_t &err);

  // this init will init each of the collection servers
  bool init (comerror_t &err,ostream &logout);

  // used to check for icons and retrieve them from the collection
  // site if they are missing
  void  cache_missing_icons(text_tmap& format_map,
			    text_t& httpdomain, 
			    text_t& httpprefix);

  text_t get_site_name (comerror_t &err);

  text_t get_protocol_name (comerror_t &err);
  void get_collection_list (text_tarray &collist, comerror_t &err, 
			    ostream &logout);
  void has_collection (const text_t &collection, bool &hascollection, 
		       comerror_t &err, ostream &logout);
  void ping (const text_t &collection, bool &wassuccess, 
	     comerror_t &err, ostream &logout);
  void get_collectinfo (const text_t &collection, 
			ColInfoResponse_t &collectinfo,
			comerror_t &err, ostream &logout);
  void get_filterinfo (const text_t &collection,
		       InfoFiltersResponse_t &response,
		       comerror_t &err, ostream &logout);
  void get_filteroptions (const text_t &collection,
			  const InfoFilterOptionsRequest_t &request,
			  InfoFilterOptionsResponse_t &response, 
			  comerror_t &err, ostream &logout);

  // returns the contents of a collection's rss-items.rdf file (generated by BasePlugout)
  void get_rss_items (const text_t &collection, 
		      const text_t &gsdlhome, 
		      text_t &rss_items, 
		      comerror_t &err, 
		      ostream &logout);

  void filter (const text_t &collection,
	       FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout);

  void get_document (const text_t &collection,
		     const DocumentRequest_t &request,
		     DocumentResponse_t &response,
		     comerror_t &err, ostream &logout);

};


#endif
