###########################################################################
#
# win32 makefile -- src/protocol
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
COLSERVR_DIR = $(RUNTIME_DIR)\src\colservr


GSDL_VC4 = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(USE_GDBM)
GDBM_DEFINES = -DUSE_GDBM
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\packages\gdbm\gdbm-1.8.3\windows"
!ELSE
GDBM_DEFINES = 
GDBM_INCLUDES = 
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES = 
!ENDIF

!IF $(USE_SQLITE)
SQLITE_DEFINES = -DUSE_SQLITE
!ELSE
SQLITE_DEFINES = 
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES = 
!ENDIF

!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
!ELSE
MG_DEFS=
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\text" -I"$(INDEXERS_DIR)\mgpp\lib"
!ELSE
MGPP_DEFS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS=
!ENDIF

AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
	$(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
# Do NOT add the "recpt" directory here: the protocol should be independent of the receptionist!
INCLUDES = -I"$(GSDL_DIR)" -I"$(COMMON_DIR)\src\lib" -I"$(COLSERVR_DIR)" $(MGPP_INCLUDES) \
	 $(GDBM_INCLUDES)

!IF $(GSDL_VC4)
DEFS=$(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)


.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


SOURCES = \
	nullproto.cpp \
	recptproto.cpp \
	recptprototools.cpp

OBJECTS = \
	nullproto.obj \
	recptproto.obj \
	recptprototools.obj

LIBRARY = gsdlprotocol.lib	
	

# Default target: make gsdlprotocol.lib
all: $(LIBRARY)

gsdlprotocol.lib: $(OBJECTS) 
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

install:

clean:
	del *.obj
	del $(LIBRARY)
