#ifndef SECURITYTOOLS_H
#define SECURITYTOOLS_H

#include "text_t.h"

// enums start numbering at 0 unless otherwise specified
enum SQLMode { STANDARD, ANSI }; // public static enum Mode { ANSI(1),STANDARD(0); ...}


// two bytes
static const text_t REPLACEMENT_HEX = "fffd";
//static const unsigned short REPLACEMENT_CHAR = '\ufffd';
static const text_t IMMUNE_CSS = "";
static const text_t IMMUNE_HTML = ",.-_ ";
static const text_t IMMUNE_HTMLATTR = ",.-_";
static const text_t IMMUNE_JAVASCRIPT = ",._";
static const text_t IMMUNE_URL = "*.-_"; // See http://docs.oracle.com/javase/6/docs/api/java/net/URLEncoder.html
static const text_t IMMUNE_SQL = " ";


// a very simple version of esapi's Validator.isValidInput()
bool isValidURLProtocol(const text_t& url);

// String conversion
text_t encodeForHTML(const text_t& input, const text_t& immuneChars=IMMUNE_HTML);
text_t encodeForURL(const text_t& input, const text_t& immuneChars=IMMUNE_URL);
text_t encodeForJavascript(const text_t& input, const text_t& immuneChars=IMMUNE_JAVASCRIPT, bool dmsafe=true);
text_t encodeForHTMLAttr(const text_t& input, const text_t& immuneChars=IMMUNE_HTMLATTR);
text_t encodeForCSS(const text_t& input, const text_t& immuneChars=IMMUNE_CSS);
// C++ port of OWASP-ESAPI for MySQL, not sure if this is is the same for SQLite
text_t encodeForSQL(const text_t& input, const text_t& immuneChars=IMMUNE_SQL, const SQLMode mode=STANDARD);

// Character conversions
text_t encodeForHTML(const text_t& immuneChars, const unsigned short input);
text_t encodeForURL(const text_t& immuneChars, const unsigned short input);
text_t encodeForJavascript(const text_t& immuneChars, const unsigned short input, bool dmsafe);
text_t encodeForCSS(const text_t& immuneChars, const unsigned short input);
text_t encodeForSQL(const text_t& immuneChars, const unsigned short input, const SQLMode mode);


#endif
