/**************************************************************************
 *
 * local_strings.h -- string routines
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef LOCAL_STRINGS_H
#define LOCAL_STRINGS_H

#include "sysfuncs.h"

class mgString
{
  u_char *data;
 public:
  inline int length()
    {
      return data[0];
    }
  inline u_char *rawdata()
    {
      return data;
    }
  inline void read(u_char **base)
    {
      unsigned int copy, suff;
      
      copy  = **base;
      *base = *base + 1;
      suff  = **base;
      *base = *base + 1;
      memcpy( (data + copy + 1), *base, suff);
      *data = copy + suff;
      *base += suff;
    }
  inline void read(FILE *dict)
    {
      unsigned int copy, suff;
      copy = fgetc(dict);
      suff = fgetc(dict);
      size_t numbytes = fread(data + copy + 1, sizeof(u_char), suff, dict);
      if(numbytes != suff)
	{
#ifdef DEBUG
	  fprintf(stderr, "[mgpp/lib/local_strings.h L59] number of bytes read by fread does not match the requested amount\n");
#endif
	}
      *data = copy + suff;
    }
  inline static void readString(u_char **base, u_char *prev)
    {
      ((mgString *) &prev)->read(base);
    }
  inline static void readString(FILE *dict, u_char *prev)
    { 
      ((mgString *) &prev)->read(dict);
    }
};

int arg_atoi (char *str);
int compare (u_char * s1, u_char * s2);
int casecompare (u_char * s1, u_char * s2);   /* [RPAP - Jan 97: Stem Index Change] */
u_char *copy_string (u_char * src_str);
char *str255_to_string (u_char * str255, char *str);
int prefixlen (u_char * s1, u_char * s2);
char *char2str (u_char c);
char *word2str (u_char * s);
char *de_escape_string (char *s);

#endif
