/**********************************************************************
 *
 * oaiconfig.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef _OAICONFIG_H_
#define _OAICONFIG_H_

#include "cnfgable.h"

#include <map>

class oaicollectconfig {
 public:
  oaicollectconfig(const text_t &collectname) { this->collection = collectname; }
  text_t    collection;
  text_t    setName; // A display name for the set (collection)
  text_t    setDescription; // A display description for the set (collection)
  text_tmap fieldMap;    // maps from OAI name to GSDL name
  text_tarray superCollectList; // a list of all super collections this belongs to
};

typedef map<text_t, oaicollectconfig *, lttext_t> oaicollectmap;

class oaisupercollectconfig {
 public:
  oaisupercollectconfig(const text_t &supercollectionname) { this->supercollection = supercollectionname; }
  text_t supercollection;
  text_t setName; // A display name for the set (supercollection)
  text_t setDescription; // A display description for the set (supercollection)
  text_tarray collectionList; // a list of collections contained in this super collection
};

typedef map<text_t, oaisupercollectconfig *, lttext_t> oaisupercollectmap;


class oaiconfig : configurable {
 public:
  oaiconfig();
  oaiconfig(text_t &gsdlhome, text_t &gsdlcollect);
  virtual ~oaiconfig();
  virtual void  configure(const text_t &key, const text_tarray &cfgline);
  text_tarray & getCollectionsList() { return this->collectList; }
  // get a list of all collections - those part of a super coll and those individual ones
  text_tarray & getAllCollectionsList() {return this->allCollectList; }
  text_tarray & getSuperCollectionsList() { return this->superCollectList; }
  // get the list of collections for this super coll
  text_tarray & getSuperCollectionCollections(const text_t super_coll) {
    return this->superCollectMap[super_coll]->collectionList;
  }
  // is this collection valid
  bool isValidCollection(const text_t &collection);
  // what super collections is this collection part of?
  text_tarray getSuperCollectionsForThisCollection(const text_t &collection);
  text_tset & getMetadataSet() { return this->metadataSet; }
  text_t        getMapping(const text_t &collection, const text_t &collectfield);
  text_t        getMapping(const text_t &collection, const text_t &collectfield, const text_t &format);
  text_tmap   * getInformation() { return &this->infoMap; }
  text_t        getSetName(const text_t &setSpec);
  text_t        getSetDescription(const text_t &setSpec);
  int getOAIVersion();
  int resumeAfter();
  text_t getBaseURL();
  text_t getBaseLibraryURL();
  text_t getBaseDocRoot();
  text_t getRelativeBaseDocRoot();
  text_t getRepositoryName();
  text_t getRepositoryId();
  text_t getRepositoryIdVersion();
  text_t getMaintainer();
 private:
  bool configureCollection(const text_t &gsdlhome, const text_t &collection);
  void addToAllCollectionsList(const text_t coll_name);
  text_t generateBaseServerURL();
  text_t    repositoryName; // human readable name
  text_t repositoryId; // unique (among oai servers) domain name or id for the repository
  text_t repositoryIdVersion; // 1.1 or 2.0 for identifier scheme
  text_t    baseServerURL; // URL of web server
  text_t    oaiserverPath; // relative path for oaiserver
  text_t    libraryPath; //relative path for library.cgi (used for urls to greenstone documents )
  text_t    docRootPath; // relative path for gsdl directory (used for urls to source documents and oai xsl )
  text_t    oaiVersion;        // The version of OAI running
  int       resumptionSize;    // The number of items to produce before spitting out a resumptionToken
  text_t    maintainer;

  text_tarray collectList;  // The list of collections to be taken in hand
  text_tset metadataSet; // The list of metadata sets to be supported
  text_tmap infoMap;        // Holds the information to be given in the case
                            // of an OAI identify request
  oaicollectmap collectMap; // The configuration of collections
  text_t collection;        // Used to track which collection is being configured
  text_tarray superCollectList; //a list of super collections. may be empty
  oaisupercollectmap superCollectMap; // The configuration of the super collections
  text_tarray allCollectList; //a list of all collections, includes those in collectList and those that are part of a super collection and not in collectList
};
#endif


