/**********************************************************************
 *
 * phindaction.h -- 
 *
 * Copyright 2001 Gordon W. Paynter
 * Copyright 2001 The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_PHIND_ACTION

#ifndef PHINDACTION_H
#define PHINDACTION_H

#include "action.h"

// Include MGPP functionality.
#include <TextGet.h>
#include <MGQuery.h>
#include <Terms.h>
#include <messages.h>
#include <GSDLQueryParser.h>

class phindaction : public action {
  
protected:

  bool find_phrase_number_from_word(const text_t &basepath, 
				    const text_t &query, 
				    DocNumArray &result);

  bool get_phrase_all_data(TextData &textdata, unsigned long phrase,
			   text_t &word, unsigned long &tf, unsigned long &ef,
			   unsigned long &lf, unsigned long &df,
			   vector <unsigned long> &el,
			   vector <unsigned long> &linkdest,
			   vector <UCArray> &linktype,
			   vector <unsigned long> &docnum, 
			   vector <unsigned long> &docfrq);

  bool print_thesaurus_links(const text_t &collection, bool XMLmode, 
			     TextData &textdata, vector <unsigned long> &linkdest,
			     vector <UCArray> &linktype, unsigned long first,
			     unsigned long last, displayclass &disp, 
			     outconvertclass &outconvert, ostream &textout);

  bool get_phrase_freq_data(TextData &textdata, unsigned long phrase,
			    UCArray &word, unsigned long &tf, 
			    unsigned long &ef, unsigned long &df);

  void print_expansions(const text_t &collection, bool XMLmode, 
			const text_t &body, TextData &textdata, 
			const vector <unsigned long> &elist,
			unsigned long first, unsigned long last,
			displayclass &disp, outconvertclass &outconvert,
			ostream &textout);

  void split_phrase(const UCArray &word, const UCArray &body, 
		    UCArray &prefix, UCArray &suffix);

  bool phrase_match(const UCArray &text, UCArray::const_iterator &here, 
		    UCArray::const_iterator end);

  bool print_documents(bool XMLmode, const text_t &basepath, 
		       const text_t &collection,
		       const vector <unsigned long> &docNums, 
		       const vector <unsigned long> &docFreq,
		       unsigned long first, unsigned long last,
		       displayclass &disp, outconvertclass &outconvert,
		       ostream &textout);

  bool get_document_all_data(TextData &docdata, unsigned long docNum,
			     UCArray &title, UCArray &hash);

  void toUCArray(const text_t &in, UCArray &out);
  void fromUCArray(const UCArray &arrin, text_t &txtout);

  void output_error (const text_t &message, ostream &textout, 
		     outconvertclass &outconvert,
		     displayclass & disp, ostream &logout,
		     bool XMLmode);


public:
  phindaction ();
  virtual ~phindaction ();

  text_t get_action_name () {return "phind";}

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);


};

#endif //!PHINDACTION_H
#endif //GSDL_USE_PHIND_ACTION

