/**********************************************************************
 *
 * z3950explain.cpp --
 * Copyright (C) 2000  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "z3950explain.h"

void getExplainInfo(bend_search_rr *rr, FilterResponse_t &response, comerror_t &err)
{
  text_t GSQuery = ZQueryToGSQuery(rr);
  char *GSQuery_char = GSQuery.getcstr(); 

  int i;
  if (strstr(GSQuery_char, "TargetInfo") != NULL) {
    // should be one only
    // real-life example:
    /*
      62
      explain-category targetInfo
      date-of-info Sep 22, 1999
      language eng
    */
    ResultDocInfo_t docinfo;
    docinfo.metadata["explain-category"].values.push_back("TargetInfo");
    docinfo.metadata["name"].values.push_back("Greenstone");
    docinfo.metadata["namedResultSets"].values.push_back("false");
    docinfo.metadata["multipleDBsearch"].values.push_back("true");
    docinfo.metadata["language"].values.push_back("eng");
    response.docInfo.push_back(docinfo);
    response.numDocs++;
  }
  if (strstr(GSQuery_char, "DatabaseInfo") != NULL) {
    // should be one per collection
    // real-life example:
    /*
      3
      dbnum 0
      explain-category DatabaseInfo
      database-name.1 0
      title Z39.50 EXPLAIN DB
      database-name.2 ir-explain-1
      date-of-info Sep 22, 1999
      language eng
      dbpath /usr/wald/z39.50root/explain
      dbname explain
    */
    ResultDocInfo_t docinfo;
    docinfo.metadata["explain-category"].values.push_back("DatabaseInfo");
    docinfo.metadata["database-name"].values.push_back("IR-Explain-1");
    docinfo.metadata["title"].values.push_back("Z39.50 EXPLAIN DB");
    docinfo.metadata["language"].values.push_back("eng");
    docinfo.metadata["dbname"].values.push_back("explain");
    response.docInfo.push_back(docinfo);
    response.numDocs++;
    // now get the info for each collection
    text_tarray collectlist;
    Protocol->get_collection_list(collectlist, err, cerr);
    text_tarray::iterator COLHERE = collectlist.begin();
    text_tarray::iterator COLEND = collectlist.end();
    while (COLHERE != COLEND) {
      // don't include information for non-active collections
      bool collection_active;
      Protocol->ping(*COLHERE, collection_active, err, cerr);
      if (collection_active != true) {
	COLHERE++;
	continue;
      }
      ColInfoResponse_t collectinfo;
      Protocol->get_collectinfo(*COLHERE, collectinfo, err, cerr);
      docinfo.clear();
      docinfo.metadata["name"].values.push_back(collectinfo.shortInfo.name);
      docinfo.metadata["host"].values.push_back(collectinfo.shortInfo.host);
      if (collectinfo.isPublic) {
	docinfo.metadata["isPublic"].values.push_back("true");
      } else {
	docinfo.metadata["isPublic"].values.push_back("false");
      }
      if (collectinfo.isBeta) {
	docinfo.metadata["isBeta"].values.push_back("true");
      } else {
	docinfo.metadata["isBeta"].values.push_back("false");
      }
      if (collectinfo.useBook == true) {
	docinfo.metadata["useBook"].values.push_back("true");
      } else {
	docinfo.metadata["useBook"].values.push_back("false");
      }
      docinfo.metadata["buildDate"].values.push_back(collectinfo.buildDate);
      text_tarray::iterator TEXTT_HERE = collectinfo.ccsCols.begin();
      text_tarray::iterator TEXTT_END = collectinfo.ccsCols.end();
      for (i = 1; TEXTT_HERE != TEXTT_END; i++, TEXTT_HERE++) {
	text_t tmp = "ccsCols.";
	tmp.appendint(i);
	docinfo.metadata[tmp].values.push_back(*TEXTT_HERE);
      }
      TEXTT_HERE = collectinfo.languages.begin();
      TEXTT_END = collectinfo.languages.end();
      for (i = 1; TEXTT_HERE != TEXTT_END; i++, TEXTT_HERE++) {
	text_t tmp = "languages.";
	tmp.appendint(i);
	docinfo.metadata[tmp].values.push_back(*TEXTT_HERE);
      }
      docinfo.metadata["numDocs"].values.push_back(collectinfo.numDocs);
      docinfo.metadata["numSections"].values.push_back(collectinfo.numSections);
      docinfo.metadata["numWords"].values.push_back(collectinfo.numWords);
      docinfo.metadata["numBytes"].values.push_back(collectinfo.numBytes);

      collectionmeta_map::iterator COLLMETA_MAP_HERE = collectinfo.collectionmeta.begin();
      collectionmeta_map::iterator COLLMETA_MAP_END = collectinfo.collectionmeta.end();
      for (i = 1; COLLMETA_MAP_HERE != COLLMETA_MAP_END; i++, COLLMETA_MAP_HERE++) {
	text_t tmp = "collectionmeta.";
	tmp.appendint(i);
	text_t tmp2 = COLLMETA_MAP_HERE->first;
	tmp2.appendcstr(" -> ");
	tmp2.append(COLLMETA_MAP_HERE->second[g_EmptyText]);
	docinfo.metadata[tmp].values.push_back(tmp2);
      }
      text_tmap::iterator TEXTT_MAP_HERE;
      text_tmap::iterator TEXTT_MAP_END;
      // uncomment if you want to include this in the explain record,
      // it's a bit messy to include by default
      /*
      TEXTT_MAP_HERE = collectinfo.format.begin();
      TEXTT_MAP_END = collectinfo.format.end();
      for (i = 1; TEXTT_MAP_HERE != TEXTT_MAP_END; i++, TEXTT_MAP_HERE++) {
	text_t tmp = "format.";
	tmp.appendint(i);
	text_t tmp2 = TEXTT_MAP_HERE->first;
	tmp2.appendcstr(" -> ");
	tmp2.append(TEXTT_MAP_HERE->second);
	docinfo.metadata[tmp].values.push_back(tmp2);
      }
      */
      TEXTT_MAP_HERE = collectinfo.building.begin();
      TEXTT_MAP_END = collectinfo.building.end();
      for (i = 1; TEXTT_MAP_HERE != TEXTT_MAP_END; i++, TEXTT_MAP_HERE++) {
	text_t tmp = "building.";
	tmp.appendint(i);
	text_t tmp2 = TEXTT_MAP_HERE->first;
	tmp2.appendcstr(" -> ");
	tmp2.append(TEXTT_MAP_HERE->second);
	docinfo.metadata[tmp].values.push_back(tmp2);
      }
      docinfo.metadata["receptionist"].values.push_back(collectinfo.receptionist);
      docinfo.metadata["buildType"].values.push_back(collectinfo.buildType);
      response.docInfo.push_back(docinfo);
      response.numDocs++;
      COLHERE++;
    }
  }
  if (strstr(GSQuery_char, "SchemaInfo") != NULL) {
    // should be one per collection
    // real-life example:
    /*
      10
      dbnum 1
      explain-category schemaInfo
      database-name.1 1
      database-name.2 books
      database-name.3 default
      database-name.4 cat
      date-of-info Sep 22, 1999
      language eng
      schema.1 1.2.840.10003.13.1000.3.1
      dbpath /usr/wald/z39.50root/books
      dbname books
     */
  }
  if (strstr(GSQuery_char, "AttributeSetInfo") != NULL) {
    // should be one per collection
    // real-life example:
    /*
      9
      dbnum 1
      explain-category AttributeSetInfo
      database-name.1 1
      database-name.2 books
      database-name.3 default
      database-name.4 cat
      date-of-info Sep 22, 1999
      language eng
      attribute-set.1 1.2.840.10003.13.1000.3.1
      dbpath /usr/wald/z39.50root/books
      dbname books
    */
  }
}


