/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.util.GSParams;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Action {
    protected HashMap config_params = null;
    protected Document doc = null;
    protected XMLConverter converter = new XMLConverter();
    protected ModuleInterface mr = null;
    static Logger logger = Logger.getLogger((String)Action.class.getName());

    public Action() {
        Action action = this;
        this.doc = action.converter.newDOM();
    }

    public void setConfigParams(HashMap params) {
        this.config_params = params;
    }

    public void setMessageRouter(ModuleInterface m) {
        this.mr = m;
    }

    public boolean configure() {
        return true;
    }

    public String process(String xml_in) {
        Document message_doc = this.converter.getDOM(xml_in);
        if (message_doc == null) {
            logger.error((Object)"Couldn't parse request");
            logger.error((Object)xml_in);
            return null;
        }
        Node result = this.process(message_doc);
        return XMLConverter.getString(result);
    }

    public abstract Node process(Node var1);

    public boolean getActionParameters(GSParams params) {
        return true;
    }

    protected void extractMetadataNames(Element format, HashSet meta_names) {
        NodeList nodes = format.getElementsByTagName("gsf:metadata");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element elem = (Element)nodes.item(i);
            StringBuffer metadata = new StringBuffer();
            String all = elem.getAttribute("multiple");
            String name = elem.getAttribute("name");
            String select = elem.getAttribute("select");
            String sep = elem.getAttribute("separator");
            if (all.equals("true")) {
                metadata.append("all");
                metadata.append("_");
            }
            if (!select.equals("")) {
                metadata.append(select);
                metadata.append("_");
            }
            if (!sep.equals("")) {
                metadata.append("*");
                metadata.append(sep);
                metadata.append("*");
                metadata.append("_");
            }
            metadata.append(name);
            meta_names.add(metadata.toString());
        }
    }

    protected Element createMetadataParamList(HashSet metadata_names) {
        Element param_list = this.doc.createElement("paramList");
        Element param = null;
        for (String name : metadata_names) {
            param = this.doc.createElement("param");
            param_list.appendChild(param);
            param.setAttribute("name", "metadata");
            param.setAttribute("value", name);
        }
        return param_list;
    }

    protected boolean processErrorElements(Element message, Element page) {
        NodeList error_nodes = message.getElementsByTagName("error");
        if (error_nodes.getLength() == 0) {
            return false;
        }
        Document owner = page.getOwnerDocument();
        for (int i = 0; i < error_nodes.getLength(); ++i) {
            page.appendChild(owner.importNode(error_nodes.item(i), true));
        }
        return true;
    }
}

