###########################################################################
#
# win32 makefile -- gsdl
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = $(GSDLHOME)
BUILDHOME = $(MAKEDIR)

GSDL_VC4 = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0

# tar file is "$(XLHTML_DIR)-gs.tar.gz
XLHTML_DIR = packages\xlhtml\xlhtml-0.4.9.0

MDEFINES = /f win32.mak

INSTALLDIRS = src\hashfile src\phind\generate 
JAVADIR = src\java\org\nzdl\gsdl

MAKECMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)"

!IF $(GSDL_VC4)
MAKECMD = $(MAKECMD) GSDL_VC4=1
!ENDIF
!IF $(DEBUG)
MAKECMD = $(MAKECMD) DEBUG=1
!ENDIF
!IF $(DLL)
MAKECMD = $(MAKECMD) DLL=1
!ENDIF
!IF $(DLLDEBUG)
MAKECMD = $(MAKECMD) DLLDEBUG=1
!ENDIF

MAKECLEANCMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" clean

all: win32.mak xlppt $(INSTALLDIRS) $(JAVADIR)

install: win32.mak xlppt wgetcfg $(INSTALLDIRS)

# Independent target for compiling xlhtml and ppthtml
xlppt:
	IF NOT EXIST $(XLHTML_DIR) IF EXIST "$(GSDLHOME)\bin\windows\gunzip.exe" IF EXIST "$(GSDLHOME)\bin\windows\tar.exe" "$(GSDLHOME)\bin\windows\gunzip.exe" -cd "$(XLHTML_DIR)-gs.tar.gz" | "$(GSDLHOME)\bin\windows\tar.exe" xv --directory=./packages/xlhtml
	@IF NOT EXIST $(XLHTML_DIR) echo ****** Couldn't extract archive $(XLHTML_DIR).tar.gz. Extract it manually, or check that gunzip.exe and tar.exe exist in GSDLHOME\bin\windows. ******
	@IF NOT EXIST $(XLHTML_DIR) exit /b 1
	cd "$(XLHTML_DIR)"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(BUILDHOME)"

# Independent target for installing wget config file into final location
wgetcfg:
	IF NOT EXIST "$(GSDLHOME)\bin\windows\wgetrc" copy "$(BUILDHOME)\packages\wget\wgetrc-gs.in" "$(GSDLHOME)\bin\windows\wgetrc"
        

clean:
	cd "$(BUILDHOME)"
	cd src\phind\generate
	$(MAKECLEANCMD)
	cd "$(BUILDHOME)"
	cd src\hashfile
	$(MAKECLEANCMD)
!IF EXIST ("$(XLHTML_DIR)")
	cd "$(BUILDHOME)"
	cd "$(XLHTML_DIR)"
	$(MAKECLEANCMD)
!ENDIF
	cd "$(BUILDHOME)
	cd src\java\org\nzdl\gsdl
	call winMake.bat clean
	cd "$(GSDLHOME)"

$(INSTALLDIRS): FORCE
	cd "$(BUILDHOME)"
	cd "$@"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(GSDLHOME)"

$(JAVADIR): FORCE
	cd "$(BUILDHOME)"
	cd "$@"
	call winMake.bat all 
	if NOT EXIST "$(GSDLHOME)\bin\java" mkdir "$(GSDLHOME)\bin\java"
	if EXIST "$(BUILDHOME)\$(JAVADIR)\ApplyXSLT.jar" copy "$(BUILDHOME)\$(JAVADIR)\ApplyXSLT.jar" "$(GSDLHOME)\bin\java"
	if NOT EXIST "$(BUILDHOME)\$(JAVADIR)\ApplyXSLT.jar" echo Warning: Failed to find $(BUILDHOME)\$(JAVADIR)\ApplyXSLT.jar.  Greenstone will not be able to use XSLT files during building
	
			 

FORCE:

