# this file must be UTF-8 encoded
######################################################################
#
# Vietnamese Language text and icon macros 
# -- this file contains text that is of less importance
# -- to translate when creating a new interface language
######################################################################



######################################################################
# 'home' page
package home
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_documents_ [l=vi] {tài liệu. }
_lastupdate_ [l=vi] {Cập nhập lần cuối}
_ago_ [l=vi] {cách đây.}
_colnotbuilt_ [l=vi] {Bộ sưu tập không được xây dựng.}

### taken from here

_textpoem_ [l=vi] {<br><h2>Kia papapounamu te moana</h2>

<p>kia hora te marino,
<br>kia tere te karohirohi,
<br>kia papapounamu te moana

<p>may peace and calmness surround you,
<br>may you reside in the warmth of a summer's haze,
<br>may the ocean of your travels be as smooth as the polished greenstone.
}

_textgreenstone_ [l=vi] {<p>Từ Greenstone có nghĩa là một loại đá quý được tìm thấy ở New Zealand. Trong văn hoá truyền thống Maori nó có giá trị nhất trong tất cả các vật chất được tìm thấy. Nó có thể hấp thụ và chứa đựng <i> wairua</i>, một loại sức mạnh tinh thần được làm giàu bằng những giá trị truyền thống, tất cả những thứ này tạo nên một biểu tượng phù hợp cho dự án thư viện số này. Vẻ đẹp của nó toát lên sự nhân ái, sự trong sáng và tin cậy, sự khắc nghiệt, sự can đảm và hình thù của nó toát lên cả sự công bằng. Tấm khắc được dùng trên logo của Greenstone được gọi là <i>patu</i> - một vũ khí chiến đấu, đây là một gia bảo của một thành viên trong dự án. Trong chiến đấu, mọi thứ phải được phân phối một cách nhanh chóng, chính xác và đầy đủ. Chúng tôi muốn phần mềm này cũng có các tính chất này. }  

_textaboutgreenstone_ [l=vi] {<p>Greenstone là một bộ phần mềm dùng  để xây dựng và phân phối các bộ sưu tập thư viện số. Nó cung cấp một phương pháp mới để tổ chức và xuất bản thông tin trên Internet hoặc trên CD-ROM. Greenstone là sản phẩm của dự án <b>New Zealand Digital Library</b> của trường đại học <b>University of Waikato</b>, được phát triển và  phân phối với sự tham gia của <b>UNESCO</b> và <b>Human Info NGO</b>. Đây là phần mềm mã nguồn mở được cung cấp trên <a href="http://greenstone.org">http://greenstone.org</a> theo thoả thuận đăng kí GNU General Public License.

<p>Mục tiêu của phần mềm là cung cấp cho người sử dụng, đặc biệt là các trường đại học, các thư viện hoặc trong các trụ sở công cộng xây dựng các thư viện số riêng của họ. Các thư viện số làm thay đổi nhanh chóng cách thức thông tin được thu thập và phổ biến trong các thành viên của UNESCO và các cơ quan trong lĩnh vực giáo dục, khoa học và văn hóa trên toàn thế giới, đặc biệt là ở các quốc gia đang phát triển. Chúng tôi hy vọng rằng phần mềm thư viện số này sẽ gia tăng hiệu quả trong việc chia sẻ thông tin và công bố rộng rãi chúng.


<p>Phần mềm này được phát triển và phân phối dưới sự hợp tác hiệu quả giữa ba đơn vị vào tháng 8 năm 2000.

<table border="0">
<tr valign="top">
<td>
<a href="http://nzdl.org"><b>New Zealand Digital Library Project at the University of Waikato</b></a>
<br>
Phần mềm Greenstone được mở rộng từ dự án này và ý tưởng ban đầu của dự án được phát triển bởi Communication Sub-Commission của New Zealand National Commission cho UNESCO như là một phần đóng góp của New Zealand cho các chương trình của UNESCO.
</td>
<td></td>
</tr>
<tr valign="top">
<td>
<a href="http://www.unesco.org"><b>United Nations Educational, Scientific and Cultural Organization</b></a>
<br>
Mục tiêu chính của UNESCO là quảng bá các thông tin về giáo dục, khoa học và văn hoá trên toàn thế giới, đặc biệt đối các quốc gia đang phát triển. Việc sử dụng rộng rãi các phương tiện thông tin liên lạc được xem như một công cụ quan trọng trong việc thực thi mục tiêu này
</td>
<td><a href="http://www.unesco.org"><img alt="UNESCO logo" src="_httpimg_/unesco.gif"
border="0"></a></td>
</tr>
<tr valign="top">
<td>
<a href="http://humaninfo.org"><b>The Human Info NGO, based in Antwerp, Belgium</b></a>
<br>
Dự án này hợp tác với các cơ quan UN & NGOs. Đây là hai tổ chức này nổi tiếng trên thế giới trong việc số hoá và phổ biến các tài liệu liên quan đến sự phát triển của nhân loại. 
</td>
<td><a href="http://humaninfo.org"><img alt="Human Info logo" src="_httpimg_/ghproj2.jpg" border="0"></a></td>
</tr>
</table>
}  


_textdescrselcol_ [l=vi] {chọn một bộ sưu tập}


######################################################################
# home help page
package homehelp
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_text4buts_ [l=vi] {Có bốn nút liên kết trên trang chủ}

_textnocollections_ [l=vi] {<p>Hiện tại không có bộ sưu tập nào dùng được trên bản cài đặt này. 
Để thêm các bộ sưu tập bạn phải 
<ul><li>Sử dụng chức năng <a href="_httppagecollector_">Tạo bộ sưu tập</a> để xây dựng mới các bộ sưu tập
    <li>Nếu bạn có một đĩa cd-rom Greenstone, ban có thể cài đặt các bộ sưu tập từ cd-rom
</ul>
}

_text1coll_ [l=vi] {Bản cài đặt này chứa 1 bộ sưu tập}

_textmorecolls_ [l=vi] {Bản cài đặt này chứa _1_  bộ sưu tập}

######################################################################
# external link package
package extlink
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textextlink_ [l=vi] {Liên kết bên ngoài}
_textlinknotfound_ [l=vi] {Liên kết bên trong không tìm thấy}  

_textextlinkcontent_ [l=vi] {Liên kết bạn chọn là bên ngoài đối với bộ sưu tập hiện tại của bạn.
    Nếu bạn vẫn muốn xem liên kết này và trình duyệt của bạn phải truy xuất được đến Web, bạn có
    thể <a href="_nexturl_">đi tiếp</a>đến trang này; nếu không bạn hãy sử dụng nút "back" trên trình duyệt của bạn để trở về tài liệu trước. 
    }

_textlinknotfoundcontent_ [l=vi] {Một số nguyên nhân vượt khỏi tầm kiểm soát của chúng ta, liên kết bên trong 
   bạn chọn không tồn tài. Điều này có thể do một lỗi trong source bộ sưu tập.
   Sử dụng nút "back" trên trình duyệt của bạn để chở lại tài liệu trước.
}

# should have arguments of collection, collectionname and link
_foundintcontent_ [l=vi] {<h3>Liên kết đến bộ sưu tập "_2_"</h3>

<p>Liên kết bạn chọn nằm bên ngoài bộ sưu tập "_collectionname_".
    Nếu bạn muốn xem liên kết này trong bộ sưu tập "_collectionname_" bạn có thể <a href="_httpdoc_&c=_1_&cl=_cgiargclUrlsafe_&d=_3_">đi tiếp</a>
    đến trang này; mặt khác sử dụng nút "back" trên trình duyệt của bạn để trở về tài liệu trước.
</p>
}  


######################################################################
# authentication page
package authen
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textGSDLtitle_ [l=vi] {Phần mềm thư viện số Greenstone}

_textusername_ [l=vi] {tên đăng nhập}
_textpassword_ [l=vi] {mật khẩu}

_textmustbelongtogroup_ [l=vi] {Chú ý rằng bạn phải thuộc nhóm quản trị mới truy xuất được trang này.}

_textmessageinvalid_ [l=vi] {Người dùng cần đăng nhập mới có thể truy xuất được trang thông tin này.<br>
_If_(_cgiargug_,[_textmustbelongtogroup_]<br>)
Vui lòng nhập tên đăng nhập và mật khẩu.}  

_textmessagefailed_ [l=vi] {Tên đăng nhập của bạn hoặc mật khẩu bị sai.}

_textmessagedisabled_ [l=vi] {Xin lỗi, tài khoản của bạn đã bị khoá. Vui lòng liên hệ với người quản trị.}

_textmessagepermissiondenied_ [l=vi] {Xin lỗi, bạn không có quyền truy xuất trang này.}

_textmessagestalekey_ [l=vi] {Liên kết này đã quá cũ. Bạn vui lòng nhập mật khẩu để truy xuất trang này.}


######################################################################
# 'docs' page 
package docs
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textnodocumentation_ [l=vi] {<p>Bản cài đặt này không chứa bất kỳ một tài liệu hướng dẫn nào. Điều này có thể do:
<ol>
 <li>Greenstone được cài đặt từ CD-ROM.
 <li>Greenstone được cài đặt từ một điểm phân phối trên mạng Internet.
</ol>
Trong trường hợp này bạn có thể lấy tài liệu từ thư mục <i>docs</i> của đĩa CD-ROM Greenstone hoặc bằng cách truy cập địa chỉ<a
href="http://www.greenstone.org">http://www.greenstone.org</a>.
}  

_textuserguide_ [l=vi] {Tài liệu hướng dẫn sử dụng}
_textinstallerguide_ [l=vi] {Tài liệu cài đặt phần mềm}
_textdeveloperguide_ [l=vi] {Tài liệu cho người phát triển bộ sưu tập}
_textpaperguide_ [l=vi] {Từ giấy đến bộ sưu tập}
_textorganizerguide_ [l=vi] {Sử dụng chương trình Organizer}

_textgsdocstitle_ [l=vi] {tài liệu greenstone}

######################################################################
# collectoraction
package wizard

_textbild_ [l=vi] {Xây dựng bộ sưu tập}  
_textbildsuc_ [l=vi] {Xây dựng bộ sưu tập thành công}  
_textviewbildsummary_ [l=vi] {Có thể <a href="_httppagex_(bsummary)" target=_top>xem bảng tóm tắt quá trình xây dựng</a> bộ sưu tập này biết thêm chi tiết.}  
_textview_ [l=vi] {Xem bộ sưu tập}  

_textbild1_ [l=vi] {Bộ sưu tập đang được xây dựng: mất một khoảng thời gian. Dòng bên dưới cho biết thông tin về xây dựng bộ sưu tập}  

_textbild2_ [l=vi] {Để dừng quá trình xây dựng sưu tập khi cần, kích chuột vào đây. <br>Sưu tập bạn đang thao tác với nó sẽ giữ nguyên như trước.}  

_textstopbuild_ [l=vi] {ngừng xây dựng}  

_textbild3_ [l=vi] {Nếu người dùng muốn ngừng trang này (và cũng có thể hủy bỏ tiến trình thì nhấn vào nút: "ngừng xây dựng") bộ sưu tập sẽ tiếp tục xây dựng và cài đặt thành công}  

_textbuildcancelled_ [l=vi] {Hủy bỏ xây dựng}  

_textbildcancel1_ [l=vi] {Tiến trình xây dựng bộ sưu tập bị hủy bỏ. Sử dụng nút màu vàng bên dưới để thay đổi bộ sưu tập hoặc khởi động lại tiến trình.}  

_textbsupdate1_ [l=vi] {Cập nhật trạng thái xây dựng trong một giây}  
_textbsupdate2_ [l=vi] {Cập nhật trạng thái xây dựng trong}  
_textseconds_ [l=vi] {ấn phẩm}  

_textfailmsg11_ [l=vi] {Bộ sưu tập không thể xây dựng được vì không có dữ liệu. Hãy chắc rằng tối thiểu một trong số các thư mục hoặc tập tin được chỉ định trong trang dữ liệu nguồn có tồn tại (trong trường hợp thư mục thì phải có chứa tập tin), để Greenstone có thể tiến hành.}  

_textfailmsg21_ [l=vi] {không thể tạo được bộ sưu tập này (tập tin import.pl bị hỏng.}  
_textfailmsg31_ [l=vi] {Không thể tạo được bộ sưu tập này (tập tin buildcol.pl bị hỏng).}  
_textfailmsg41_ [l=vi] {Bộ sưu tập được xây dựng thành công nhưng không cho phép cài đặt}  
_textfailmsg71_ [l=vi] {Lỗi xuất hiện trong khi xây dựng bộ sưu tập}  


_textblcont_ [l=vi] {xây dựng bản ghi bao gồm thông tin bên dưới: }  

######################################################################
# collectoraction
package collector
######################################################################



#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultstructure_ [l=vi] {cấu trúc mặc định}
_textmore_ [l=vi] {nhiều hơn}
_textinfo_ [l=vi] {Thông tin bộ sưu tập}
_textsrce_ [l=vi] {Tài liệu nguồn}
_textconf_ [l=vi] {Cấu hình bộ sưu tập}
_textdel_ [l=vi] {Xoá bộ sưu tập}
_textexpt_ [l=vi] {Xuất bản bộ sưu tập}

_textdownloadingfiles_ [l=vi] {Đang tải xuống các tập tin ...}
_textimportingcollection_ [l=vi] {Đang nhập bộ sưu tập ...}
_textbuildingcollection_ [l=vi] {Đang xây dựng bộ sưu tập ...}
_textcreatingcollection_ [l=vi] {đang tạo bộ sưu tập ...}

_textcollectorblurb_ [l=vi] {<i>
<br>Việc xây dựng và phân phối bộ sưu tập có những vấn đề mà bạn cần phải nắm rõ trước khi tiến hành quá trình tổng hợp tài liệu. Có những vấn đề pháp lí: Bạn có thể truy cập tài liệu này không có nghĩa là bạn có thể để cho những người khác tự do xem tài liệu. Có những vấn đề mang tính xã hội: Các bộ sưu tập phải phù hợp với thuần phong mỹ tục ở nơi phát hành. Có những vấn đề chủng tộc, những thứ đơn giản là chúng ta không thể phát hành rộng rãi.
<br>Hãy thận trọng với sức mạnh của thông tin và sử dụng chúng một cách đúng đắn
</i>
}

_textcb1_ [l=vi] {Tạo bộ sưu tập giúp bạn tạo mới các bộ sưu tập, thay đổi, thêm thông tin hoặc xóa các bộ sưu tập có sẵn. Để làm được điều này bạn sẽ được hướng dẫn điền những điền những thông tin cần thiết một cách tuần tự vào các trang Web yêu cầu.
}

_textcb2_ [l=vi] {Đầu tiên bạn phải chọn một trong hai thao tác sau}
_textcnc_ [l=vi] {tạo mới một bộ sưu tập}
_textwec_ [l=vi] {thêm dữ liệu vào một bộ sưu tập có sẵn hoặc xóa bộ sưu tập đó.}

_textcb3_ [l=vi] {Để xây dựng hoặc thay đổi các bộ sưu tập thư viện số bạn phải đăng nhập vào hệ thống. Điều này sẽ bảo vệ các thông tin của bạn không bị thay đổi bởi những người khác sử dụng máy tính của bạn. Chú ý, vì lý do an ninh, bạn sẽ bị tự động thoát ra khỏi hệ thống 30 phút sau khi đã đăng nhập. Khi đó, bạn đừng lo lắng - bạn sẽ được yêu cầu đăng nhập lại và tiếp tục tại vị trí bạn ra khỏi hệ thống.
}

_textcb4_ [l=vi] {Vui lòng, nhập tên đăng nhập và mật khẩu của bạn, sau đó nhấp chuột vào nút đăng nhập.
}

_textfsc_ [l=vi] {Đầu tiên bạn chọn bộ sưu tập mà bạn muốn làm việc (các bộ sưu tập không được phép ghi sẽ không được liệt kê ở đây).
}

_textwtc_ [l=vi] {Với bộ sưu tập bạn đã chọn, bạn có thể}
_textamd_ [l=vi] {Thêm dữ liệu và xây dựng lại bộ sưu tập}
_textetc_ [l=vi] {Chỉnh sửa tập tin cấu hình của bộ sưu tập và xây dựng lại bộ sưu tập}
_textdtc_ [l=vi] {Xoá bộ sưu tập}
_textetcfcd_ [l=vi] {Xuất bản bộ sưu tập ra CD-ROM}
_textcaec_ [l=vi] {Chỉnh sửa bộ sưu tập đã có}
_textnwec_ [l=vi] {Không tồn tại bộ sưu tập cho phép chỉnh sửa}
_textcianc_ [l=vi] {Tạo mới một bộ sưu tập}
_texttsosn_ [l=vi] {Thứ tự các bước cần thiết để tạo mới bộ sưu tập thư viện số là:}
_textsin_ [l=vi] {Xác định tên của bộ sưu tập (và thông tin liên quan)}
_textswts_ [l=vi] {Xác định nơi lấy tài liệu nguồn}
_textatco_ [l=vi] {Chỉnh sửa các tùy chọn cấu hình (chỉ dành cho người sử dụng cấp cao)}
_textbtc_ [l=vi] {"Xây dựng" bộ sưu tập (xem phần dưới)}
_textpvyh_ [l=vi] {Xem lại các công việc bạn đã làm}

_texttfsiw_ [l=vi] {Bước thứ tư là bước mà máy tính sẽ làm tất cả các công việc. Trong quá trình xây dựng máy tính tạo ra tất cả các chỉ mục và thu thập các thông tin liên quan. Nhưng trước tiên bạn phải xác định thông tin.  
}

_textadab_ [l=vi] {Một sơ đồ xuất hiện ở dưới sẽ giúp bạn nhận biết bạn đang ở bước nào. Nút màu xanh lá cây là nút mà bạn nhấn vào để tiếp tục. Khi bạn đi theo tuần tự các trạng thái, các nút sẽ thay đổi sang màu vàng. Bạn có thể trở về một trang trước đó bằng cách nhấn chuột vào nút màu vàng thích hợp trên sơ đồ.
}

_textwyar_ [l=vi] {Khi bạn đã sẵn sàng, nhấn nút màu xanh lá cây “thông tin bộ sưu tập” để bắt đầu tạo bộ sưu tập số mới.
}

_textcnmbs_ [l=vi] {Tên bộ sưu tập phải được xác định}
_texteambs_ [l=vi] {Địa chỉ Email phải được xác định}
_textpsea_ [l=vi] {Xác định địa chỉ emai theo mẫu: username@domain}
_textdocmbs_ [l=vi] {Mô tả về bộ sưu tập phải được xác định}

_textwcanc_ [l=vi] {Khi tạo mới một bộ sưu tập bạn cần nhập một số thông tin sơ bộ về tài liệu nguồn. Quá trình xây dựng được cấu trúc như là một loạt các trang web được giám sát bởi chức năng Xây dựng bộ sưu tập.
}

_texttfc_ [l=vi] {Tên bộ sưu tập:}

_texttctiasp_ [l=vi] {Tiêu đề của bộ sưu tập là một nhóm từ ngắn được sử dụng trong chương trình nhằm xác định nội dung của bộ sưu tập. Ví dụ các tiêu đề sau: “Computer Science Technical Reports” và "Humanity Development Library".
}

_textcea_ [l=vi] {Địa chỉ email liên hệ:}

_textteas_ [l=vi] {Địa chỉ email này là điạ chỉ liên hệ của bộ sưu tập. Khi bộ sưu tập gặp trục trặc, một báo cáo chẩn đoán sẽ được gửi tới địa chỉ này. Nhập một địa chỉ email theo mẫu đầy đủ: <tt>name@domain</tt>.
}

_textatc_ [l=vi] {Giới thiệu về bộ sưu tập:}

_texttiasd_ [l=vi] {Đây là một câu diễn tả các nguyên tắc bao trùm bộ sưu tập. Nó sẽ xuất hiện trên trang đầu khi bộ sưu tập được trình bày.
}

_textypits_ [l=vi] {Vị trí của bạn theo thứ tự được chỉ ra bởi một mũi tên ở dưới - trong trường hợp này là trạng thái “Thông tin bộ sưu tập”. Để tiếp tục, nhấn chuột vào nút màu xanh lá cây “Tài liệu nguồn”. 
}

_srcebadsources_ [l=vi] {<p>Có một hoặc nhiều tài liệu nguồn bạn xác định là không hợp lệ (đánh dấu
_iconcross_ ở dưới).

<p>Điều này có thể là do
<ul>
<li>Tập tin, vị trí FTP hoặc URL không tồn tại.
<li>Bạn cần phải kết nối vào mạng Internet trước
<li>Bạn đang cố truy xuất từ bên trong một firewall (điều này xảy ra khi bạn thường phải cung cấp tên đăng nhập và mật khẩu để truy cập Interner).
</ul>

<p>Nếu trang địa chỉ URL này có thể nhìn thấy từ trình duyệt của bạn, nó có thể là một bản sao được lưu trong máy cục bộ. Thật đáng tiếc, các bản sao này thì lại hoàn toàn hợp lệ đối với các quá trình xử lý của chúng tôi. Trong trường hợp này chúng tôi khuyên bạn tải xuống lại các trang đang sử dụng bởi trình duyệt của bạn trước.
}

_textymbyco_ [l=vi] {<p>Bạn chọn một trong hai cấu trúc sau để xây dựng bộ sưu tập của mình. <ul> <li>Cấu trúc mặc định <dl><dd>Bộ sưu tập mới phải chứa tài liệu dạng hmtl (.htm, .html), tài liệu dạng văn bản (.txt, .text), tài liệu dạng Word (.doc), tài liệu dạng PDF (.pdf) hoặc tài liệu dạng email (.mbx).</dd></dl> <li>Một bộ sưu tập đã có sẵn <dl><dd>Các tập tin trong bộ sưu tập mới của bạn phải có kiểu giống với những tập tin được dùng để xây dựng bộ sưu tập đã có.</dd></dl> </ul> }  

_textbtco_ [l=vi] {Xây dựng bộ sưu tập trên}
_textand_ [l=vi] {Thêm mới dữ liệu}
_textad_ [l=vi] {Đang thêm dữ liệu:}

_texttftysb_ [l=vi] {Các tập tin mà bạn xác định ở dưới sẽ được thêm vào bộ sưu tập. Hãy kiểm tra xem bạn có đang thêm vào một tập tin sẵn có trong bộ sưu tập không, nếu trường hợp đó xảy ra, cả 3 tập tin sẽ đều nằm trong bộ sưu tập. Các tập tin được xác định thông qua đường dẫn đầy đủ, các trang Web được xác định thông qua địa chỉ Web.
}

_textis_ [l=vi] {Tài liệu nguồn:}

_textddd1_ [l=vi] {<p>Nếu bạn sử dụng file:// hoặc ftp:// để xác định một tập tin, thì tập tin đó sẽ được lấy về.

<p>Nếu bạn sử dụng http:// thì tùy theo URL bạn sẽ nhận một trang hoặc nhiều trang web. Khi một trang được lấy về thì tất cả các trang mà liên kết trực tiếp hoặc gián tiếp với nó cũng được lấy xuống. 

<p>Khi bạn sử dụng file:// hoặc ftp:// để xác định một thư mục, hoặc cung cấp một http:// URL mà chỉ đến một danh sách các tập tin, thì mọi thứ trong thư mục và tất cả các thư mục con của nó sẽ được đưa vào bộ sưu tập. 

<p>Nhấn chuột vào nút “Thêm tài liệu” để có nhiều hộp nhập liệu hơn.
}

_textddd2_ [l=vi] {<p>Nhấn chuột một lần vào các nút màu xanh lá cây. Nếu bạn là người sử dụng cấp cao bạn có thể chỉnh sửa cấu hình của bộ sưu tập. Ngược lại, bạn đến bước xây dựng bộ sưu tập. Bạn có thể quay lại các bước trước đó bằng cách nhấn chuột vào nút màu vàng.
}

_textconf1_ [l=vi] {<p>Việc xây dựng và trình bày bộ sưu tập của bạn được điều khiển bằng các xác lập trong một tập tin cấu hình đặc biệt. Người sử dụng cấp cao có thể thay đổi các xác lập đó.

<center><p><b>Nếu không, bạn có thể di chuyển xuống cuối trang.</b></center> 

<p>Để thay thế các xác lập cấu hình có sẵn, bạn hãy thay thế dữ liệu xuất hiện ở dưới. Khi bị sai, bạn nhấn chuột vào “Làm lại” để lấy lại các xác lập ban đầu.
}

_textreset_ [l=vi] {Làm lại}


_texttryagain_ [l=vi] {<a href="_httppagecollector_" target=_top>khởi động lại chức năng xây dựng bộ sưu tập</a>
 và thử lại.
}  


_textretcoll_ [l=vi] {Quay lại Tạo bộ sưu tập}

_textdelperm_ [l=vi] {Một số hoặc tất cả _cgiargbc1dirnameHtmlsafe_ bộ sưu tập không thể được xoá. Nguyên nhân có thể là:
<ul>
<li> Greenstone không có quyền xoá thư mục _gsdlhome_/collect/_cgiargbc1dirnameHtmlsafe_ .
<br>
Bạn cần tự tay xoá bỏ thư mục này để hoàn tất việc xoá bộ sưu tập _cgiargbc1dirnameHtmlsafe_
.</li>
<li>Greenstone không thể chạy chương trình _gsdlhome_/bin/script/delcol.pl. Bạn phải bảo đảm tập tin này có thể đọc và thực thi.</li>
</ul>
}

_textdelinv_ [l=vi] {Bộ sưu tập _cgiargbc1dirnameHtmlsafe_ được bảo vệ hoặc không hợp lệ. Quá trình xoá được huỷ bỏ.
}

_textdelsuc_ [l=vi] {Bộ sưu tập _cgiargbc1dirnameHtmlsafe_ được xoá thành công.}

_textclonefail_ [l=vi] {Bộ sưu tập _cgiargclonecolHtmlsafe_ không thể sao chép. Nguyên nhân có thể là:
<ul>
<li> Bộ sưu tập _cgiargclonecolHtmlsafe_ không tồn tài
<li> Bộ sưu tập _cgiargclonecolHtmlsafe_ không có tập tin cấu hình collect.cfg
<li> Greenstone không có quyền đọc tập tin cấu hình collect.cfg
</ul>
}

_textcolerr_ [l=vi] {Xây dựng bộ sưu tập bị lỗi.}

_texttmpfail_ [l=vi] {Xây dựng bộ sưu tập không thể đọc hoặc ghi từ tập tin hoặc thư mục tạm thời. Nguyên nhân có thể là:
<ul>
<li> Greenstone không thể đọc hoặc ghi trên thư mục _gsdlhome_/tmp.
</ul>
}

_textmkcolfail_ [l=vi] {Xây dựng bộ sưu tập không thể tạo cấu trúc thư mục theo yêu cầu của bộ sưu tập mới (mkcol.pl thất bại). Nguyên nhân có thể là:
<ul>
<li> Greenstone không có quyền ghi trên thư mục _gsdlhome_/tmp.
<li> mkcol.pl perl script có lỗi.
</ul>
}

_textnocontent_ [l=vi] {Bộ sưu tập bị lỗi: bạn không cung cấp tên cho bộ sưu tập mới. Hãy khởi động lại quá trình xây dựng bộ sưu tập từ đầu.
}

_textrestart_ [l=vi] {Bắt đầu tạo bộ sưu tập}

_textreloaderror_ [l=vi] {Một lỗi xảy ra trong khi tạo một bộ sưu tập mới. Điều này xảy ra Greenstone không phân biệt được nút "reload" hoặc nút "back" trên trình duyệt của bạn (bạn nên tránh sử dụng những nút này trong khi tạo bộ sưu tập). Bạn nên bắt đầu lại quá trình xây dựng bộ sưu tập.
}

_textexptsuc_ [l=vi] {Bộ sưu tập _cgiargbc1dirnameHtmlsafe_ export thành công đến thư mục _gsdlhome_/tmp/exported\__cgiargbc1dirnameHtmlsafe_.
}

_textexptfail_ [l=vi] {<p>Export thất bại bộ sưu tập _cgiargbc1dirnameHtmlsafe_.  <p>Điều này hình như là do Greenstone được cài đặt mà không có các thành phần cần thiết để hỗ trợ chức năng  "Truy xuất Collection". <ul>   <li>Khi bạn cài đặt Greenstone từ CD-ROM các thành phần này sẽ không được được cài đặt mặc nhiên bạn phải chọn chúng trong mục "Custom". Bạn có thể thêm chúng trong bản cài đặt của bạn bằng cách chạy lại thủ tục cài đặt.   <li>Khi bạn cài đặt Greenstone từ một điểm phân phối trên Internet bạn cần tải xuống và cài đặt thêm các gói cho phép sử dụng chức năng này. Liên hệ trang web này <a href="http://www.greenstone.org">http://www.greenstone.org</a> hoặc địa chỉ email <a  href="mailto:greenstone@cs.waikato.ac.nz">greenstone@cs.waikato.ac.nz</a> để biết thêm chi tiết.  </ul> }  

######################################################################
# depositoraction
package depositor
######################################################################


_textdepositorblurb_ [l=vi] {<p> chỉ định  thông tin của những tập tin dưới đây và nhấn vào textintro bên dưới.</p>}  

_textcaec_ [l=vi] {Thêm vào bộ sưu tập đã có}  
_textbild_ [l=vi] {Mục truyền dữ liệu}  
_textintro_ [l=vi] {Chọn tập tin}  
_textconfirm_ [l=vi] {Xác nhận}  
_textselect_ [l=vi] {Chọn bộ sưu tập}  
_textmeta_ [l=vi] {Chỉ đinh Metadata}  
_textselectoption_ [l=vi] {chọn sưu tập}  

_texttryagain_ [l=vi] {<a href="_httppagedepositor_" target=_top>khởi động lại hệ thống truyền dữ liệu </a> và thử lại lần nữa}  

_textselectcol_ [l=vi] {Chọn sưu tập bạn muốn bổ sung tài liệu mới}  
_textfilename_ [l=vi] {Tên tệp}  
_textfilesize_ [l=vi] {Kích thước tệp}  

_textretcoll_ [l=vi] {Quay lại hệ thống truyền dữ liệu}  


_texttmpfail_ [l=vi] {Hệ thống truyền dữ liệu bị lỗi khi đọc hoặc ghi lên một tập tin hoặc thư mục tạm. Các nguyên nhân có thể xảy ra:
<ul>
<li> Greenstone không cấp quyền đọc/ghi cho thư mục _gsdlhome_/tmp.
</ul>
}  


######################################################################
# 'gsdl' page
package gsdl
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textgreenstone1_ [l=vi] {Greenstone là một bộ phần mềm dùng để xây dựng và phân phối các bộ sưu tập tài liệu số. Nó cung cấp một phương pháp mới để tổ chức và xuất bản thông tin trên Internet hoặc trên CD-ROM. Greenstone là sản phẩm của dự án Thư viện số New Zealand của trường đại học Waikato, được phát triển và  phân phối với sự tham gia của UNESCO và Human Info NGO. Đây là phần mềm mã nguồn mở được cung cấp trên <i>http://greenstone.org</i> theo thoả thuận của GNU General Public License.
}  

_textgreenstone2_ [l=vi] {Địa chỉ trang web của New Zealand Digital Library (http://nzdl.org) chứa nhiều bộ sưu tập mẫu, tất cả chúng được tạo với phần mềm Greenstone. Các bộ sưu tập này được công bố rộng rãi cho bạn nghiên cứu. Tất cả chúng được minh hoạ bằng nhiều ví dụ khác nhau về cách tìm kiếm và hiển thị các tùy chọn. Trang web này chứa đựng nhiều bộ sưu tập bằng tiếng Arabic, Chinese, French, Maori và Spanish cũng như tiếng English. Ngoài ra còn có các bộ sưu tập về âm nhạc.}  

_textplatformtitle_ [l=vi] {cấu hình nền}
_textgreenstone3_ [l=vi] {Greenstone tương thích với hệ điều hành Windows, Unix và Mac OS X. Việc phân phối bao gồm các bản cài đặt cho tất cả các phiên bản của Windows, Linux và Mac OS X. Nó cũng cung cấp toàn bộ source code của hệ thống để người sử dụng có thể biên dịch lại bằng Microsoft C++ hoặc gcc. Phần mềm đi kèm với Greenstone cũng đều miễn phí, ví dụ như Apache Webserver và PERL. Người sử dụng có thể dùng các trình duyệt Web điển hình là Netscape Navigator hoặc Internet Explorer. }  

_textgreenstone4_ [l=vi] {Có nhiều đĩa CD_ROM chứa sẵn các bộ sưu tập tài liệu để phục vụ cho phần mềm Greenstone. Ví dụ,  <i>Humanity Development</i> chứa 1.230 tài liệu từ kế toán tài chính cho đến vấn đề an toàn nguồn nước. Nó chạy trên các máy tính cấu hình thấp chẳng hạn như những cái thường dùng ở các nước đang phát triển. Thông tin có thể được truy xuất bằng cách tìm kiếm, trình duyệt dựa trên chủ đề, tên tiêu đề, tên tổ chức xuất bản, danh sách các gợi ý hoặc xem bìa sách một cách tùy ý.
}  

_textcustomisationtitle_ [l=vi] {tùy chỉnh}
_textgreenstone5_ [l=vi] {Greenstone được thiết kế để dễ nâng cấp và chỉnh sửa. Các định dạng mới của một tài liệu và metadata được cung cấp bằng cách viết “plugins” (trong Perl). Tương tự, việc duyệt cấu trúc của metadata có thể thực hiện bằng cách viết “classifiers”. Giao diện người sử dụng có thể được thay thế bằng cách viết các “macros”. Giao thức Corba cho phép các chương trình thông minh (ví dụ trong Java) sử dụng tất cả các tiện ích đi kèm với bộ sưu tập. Cuối cùng, source code bằng C++ và Perl được cung cấp miễn phí và cho phép sửa đổi.
}  

_textdocumentationtitle_ [l=vi] {tài liệu}
_textdocuments_ [l=vi] {Tài liệu viết thêm cho phần mềm Greenstone thì khá phổ biến.}  

#_textthreedocs_ {There are three documents that explain the Greenstone system:}
#_textinstall_ {The Greenstone Digital Library Software Installer's Guide}
#_textuser_ {The Greenstone Digital Library Software User's Guide}
#_textdevelop_ {The Greenstone Digital Library Software Developer's Guide}

_textmailinglisttitle_ [l=vi] {danh sách địa chỉ mail}
_textmailinglist_ [l=vi] {Có một danh sách những địa chỉ nhận thông tin thường xuyên mà mục đích chính là để thảo luận về phần mềm thư viện số Greenstone. Những người sử dụng của Greenstone có thể đăng ký vào danh sách này và tham gia vào các buổi thảo luận.
Để đăng ký, truy cập địa chỉ <a href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users</a>.Để gửi thông tin đến nhóm,  sử dụng địa chỉ này greenstone-users@list.scms.waikato.ac.nz
>greenstone-users@list.scms.waikato.ac.nz</a>.
}  

_textbugstitle_ [l=vi] {lỗi}
_textreport_ [l=vi] {Chúng tôi muốn bảo đảm rằng phần mềm này làm việc tốt. Bạn vui lòng thông báo các lỗi đến <a href="mailto:greenstone-users@list.scms.waikato.ac.nz" >greenstone-users@list.scms.waikato.ac.nz</a>.  }  

_textgs3title_ [l=vi] {công việc}
_textgs3_ [l=vi] {Greenstone 3 là một phiên bản được thiết kế và cài đặt lại, chứa tất cả các tính năng tiên tiến của Greenstone 2 (phiên bản hiện tại). Nó kết hợp tất cả các đặc điểm của hệ thống đã tồn tại và tương thích với tất cả các hệ thống trước: có thể xây dựng và chạy trên các bộ sưu tập đã có mà không phải chỉnh sửa. Greenstone 3 được viết bằng Java và được xây dựng như một thành phần mạng độc lập sử dụng XML để truyền thông. Những tính năng này giúp Greenstone phát triển tính khả chuyển và mở rộng. Phiên bản mới được đưa vào sử dụng thực tế vào ngày 23 tháng 12 năm 2003. Ý tưởng thiết kế ban đầu của hệ thống được phác thảo trên "The design of Greenstone 3: An agent based dynamic digital library"(<a href="http://www.greenstone.org/manuals/gs3design.pdf">PDF</a>).  }  

_textcreditstitle_ [l=vi] {Danh sách tác giả
}  

_textwhoswho_ [l=vi] {Phần mềm Greenstone là nỗ lực tập thể của nhiều người. Ian Witten là thành viên sáng lập của Dự án; Rodger McNab và Stefan Boddie là những người thiết kế và thực hiện chính đầu tiên. Những người đóng góp khác bao gồm: _contributorlist_ Những thành viên của Dự án Thư viện số New Zealand cung cấp tư vấn và truyền cảm hứng cho thiết kế hệ thống: _inspirationlist_ Chúng tôi cũng cảm ơn những người đã đóng góp vào các gói phần mềm được cấp phép theo GNU, bao gồm cả phiên bản này: _gnupackagelist_}  

_textaboutgslong_ [l=vi] {giới thiệu về phần mềm greenstone}

######################################################################
# 'users' page
package userslistusers
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textlocu_ [l=vi] {Danh sách người sử dụng hiện tại}
_textuser_ [l=vi] {người sử dụng
}
_textas_ [l=vi] {tình trạng tài khoản}
_textgroups_ [l=vi] {nhóm}
_textcomment_ [l=vi] {chú thích}
_textadduser_ [l=vi] {thêm người sử dụng}
_textedituser_ [l=vi] {chỉnh sửa}
_textdeleteuser_ [l=vi] {xoá}


######################################################################
# 'users' page
package usersedituser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textedituser_ [l=vi] {Chỉnh sửa thông tin người dùng}
_textadduser_ [l=vi] {Thêm người sử dụng}

_textaboutusername_ [l=vi] {Tên đăng nhập phải dài từ 2 đến 30 ký tự. Chúng có thể chứa các ký tự, chữ số, '.' và '_'.
}

_textaboutpassword_ [l=vi] {Mật khẩu phải dài từ 3 đến 128 ký tự. Chúng chỉ chứa các ký tự ASCII in được thông thường.
}

_textoldpass_ [l=vi] {Nếu trường này trống mật khẩu cũ sẽ được bỏ qua.}
_textenabled_ [l=vi] {cho phép}
_textdisabled_ [l=vi] {không cho phép}

_textaboutgroups_ [l=vi] {Các nhóm phân biệt bởi dấu phẩy, không đặt khoảng trắng sau dấu phẩy.
}
_textavailablegroups_ [l=vi] {Những nhóm được xác định trước gồm người quản trị và những người được trao quyền xây dựng sưu tập sử dụng Giao diện thủ thư (GLI) hoặc Bộ lưu chiểu theo phương thức từ xa: <ul> <li><b>Người quản trị</b>: Trao quyền truy cập và thay đổi cấu hình hệ thống và tài khoản người dùng. <li><b>biên tập viên sưu tập cá nhân</b>: Trao quyền tạo những sưu tập cá nhân mới <li><b><biên tập viên>  tên sưu tập</b>: Trao quyền tạo và hiệu đính "tên sưu tập" của sưu tập, thí dụ, biên tập viên sưu tập báo cáo. <li><b>biên tập viên mọi sưu tập</b>: Trao quyền tạo những sưu tập cá nhân và sưu tập chung, và biên tập <b>tất cả</b> sưu tập. Cũng trao quyền sử dụng công cụ the Collector. </ul> }  


######################################################################
# 'users' page
package usersdeleteuser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdeleteuser_ [l=vi] {Xoá người sử dụng}
_textremwarn_ [l=vi] {Bạn có thật sự muốn xoá người sử dụng không <b>_cgiargumunHtmlsafe_</b>?}


######################################################################
# 'users' page
package userschangepasswd
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textchangepw_ [l=vi] {Thay đổi mật khẩu}
_textoldpw_ [l=vi] {mật khẩu cũ}
_textnewpw_ [l=vi] {mật khẩu mới}
_textretype_ [l=vi] {đánh lại mật khẩu mới}


######################################################################
# 'users' page
package userschangepasswdok
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsuccess_ [l=vi] {Mật khẩu đã được thay đổi thành công.}


######################################################################
# 'users' page
package users
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textinvalidusername_ [l=vi] {Tên đăng nhập không tồn tại.}
_textinvalidpassword_ [l=vi] {Mật khẩu bị sai.}
_textemptypassword_ [l=vi] {Vui lòng nhập lại mật khẩu cho người dùng này.}
_textuserexists_ [l=vi] {Người sử dụng này đã tồn tại, bạn nhập tên đăng nhập khác.}

_textusernameempty_ [l=vi] {Vui lòng nhập tên đăng nhập.}
_textpasswordempty_ [l=vi] {Bạn phải nhập mật khẩu cũ.}
_textnewpass1empty_ [l=vi] {Bạn nhập mật khẩu mới sau đó đánh lại một lần nữa.}
_textnewpassmismatch_ [l=vi] {2 mật khẩu bạn nhập vào không khớp.}
_textnewinvalidpassword_ [l=vi] {Bạn nhập một mật khẩu không có giá trị.}
_textfailed_ [l=vi] {Tên đăng nhập hoặc mật khẩu của bạn bị sai.}


######################################################################
# 'status' pages
package status
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textversion_ [l=vi] {Số phiên bản Greenstone }
_textframebrowser_ [l=vi] {Bạn phải có trình duyệt hiển thị được frame.}
_textusermanage_ [l=vi] {Quản lý người dùng}
_textlistusers_ [l=vi] {danh sách người dùng}
_textaddusers_ [l=vi] {thêm người dùng mới}
_textchangepasswd_ [l=vi] {thay đổi mật khẩu}
_textinfo_ [l=vi] {Thông tin kỹ thuật}
_textgeneral_ [l=vi] {thông tin chung}
_textarguments_ [l=vi] {đối số}
_textactions_ [l=vi] {hoạt động}
_textbrowsers_ [l=vi] {cách hiển thị}
_textprotocols_ [l=vi] {các qui ước}
_textconfigfiles_ [l=vi] {Các tập tin cấu hình}
_textlogs_ [l=vi] {Nhật ký}
_textusagelog_ [l=vi] {nhật ký sử dụng}
_textinitlog_ [l=vi] {nhật ký khởi động}
_texterrorlog_ [l=vi] {nhật ký lỗi}
_textadminhome_ [l=vi] {Trang quản trị}
_textreturnhome_ [l=vi] {Trang chủ Greenstone}
_titlewelcome_ [l=vi] {Quản trị }
_textmaas_ [l=vi] {Các dịch vụ duy trì và quản trị người dùng bao gồm:}
_textvol_ [l=vi] {Xem nhật ký on-line}
_textcmuc_ [l=vi] {tạo, duy trì và cập nhật các bộ sưu tập}
_textati_ [l=vi] {truy xuất các thông tin kỹ thuật ví dụ như các đối số CGI}

_texttsaa_ [l=vi] {Những dịch vụ này được truy xuất sử dụng các thanh điều khiển ở bên trái của trang.
}

_textcolstat_ [l=vi] {Tình trạng bộ sưu tập}

_textcwoa_ [l=vi] {Các bộ sưu tập sẽ được kích hoạt nếu các tập tin build.cfg tồn tại, các tập tin này cho phép đọc, và trường ngày xây dựng của bộ sưu tập là hợp lệ và nằm trong thư mục quản lý của bộ sưu tập.
}  

_textcafi_ [l=vi] {nhấn vào <i>abbrev.</i> để xem thông tin chi tiết của một bộ sưu tập.}
_textcctv_ [l=vi] {nhấn vào  <i>collection</i> để xem tổng quan về bộ sưu tập.}
_textsubc_ [l=vi] {Cập nhật các thay đổi}
_texteom_ [l=vi] {Mở tập tin main.cfg lỗi}
_textftum_ [l=vi] {Cập nhật tập tin main.cfg thất bại}
_textmus_ [l=vi] {main.cfg cập nhập thành công}


######################################################################
# 'bsummary' pages
package bsummary
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textbsummary_ [l=vi] {Tóm tắt quá trình xây dựng bộ sưu tập "_collectionname_"}  
_textflog_ [l=vi] {Ghi nhật ký cho bộ sưu tập _collectionname_ bị thất bại}  
_textilog_ [l=vi] {Nhập khẩu bản ghi"_collectionname" cho bộ sưu tập}  

############################################################################
#
# This stuff is only used by the usability (SEND FEEDBACK) stuff
#
############################################################################
package Global

# old cusab button
_linktextusab_ [l=vi] {Gửi thông tin phản hồi}  

_greenstoneusabilitytext_ [l=vi] {Tiện ích Greenstone}

_textwhy_ [l=vi] {<p>Quá trình gửi báo cáo gặp sự cố hoặc thất bại.}  
_textextraforform_ [l=vi] {Bạn không phải điền vào mẫu -- bất kỳ thông tin hướng dẫn nào.}  
_textprivacybasic_ [l=vi] {<p>Báo cáo chỉ chứa các thông tin về trang web Greenstone và kỹ thuật mà người sử dụng đang dùng để xem nó (và bất cứ thông tin mà bạn cung cấp).}  
_textstillsend_ [l=vi] {Bạn vẫn muốn gửi báo cáo này?}  

_texterror_ [l=vi] {lỗi}
_textyes_ [l=vi] {Đồng ý}  
_textno_ [l=vi] {Không}  
_textclosewindow_ [l=vi] {Đóng cửa sổ}  
_textabout_ [l=vi] {Giới thiệu}
_textprivacy_ [l=vi] {Riêng tư}
_textsend_ [l=vi] {Gửi}
_textdontsend_ [l=vi] {Không gửi}  
_textoptionally_ [l=vi] {Tuỳ chọn}  

_textunderdev_ [l=vi] {Các chi tiết sẽ được xem trước trong phiên bản cuối cùng.}  

_textviewdetails_ [l=vi] {Xem chi tiết báo cáo }  
_textmoredetails_ [l=vi] {Chi tiết hơn}  
_texttrackreport_ [l=vi] {Theo dõi báo cáo này}  
_textcharacterise_ [l=vi] {Vấn đề gặp phải là gì?}  
_textseverity_ [l=vi] {Mức độ nghiêm trọng của vấn đề}  
 
_textbadrender_ [l=vi] {Trang bị lỗi.}  
_textcontenterror_ [l=vi] {Lỗi nội dung}  
_textstrangebehaviour_ [l=vi] {Hoạt động một cách kì lạ}  
_textunexpected_ [l=vi] {Xảy ra lỗi}  
_textfunctionality_ [l=vi] {Khó sử dụng}  
_textother_ [l=vi] {Những vấn đề khác}  

_textcritical_ [l=vi] {Nhận xét}  
_textmajor_ [l=vi] {Quan trọng}  
_textmedium_ [l=vi] {Bình thường}  
_textminor_ [l=vi] {Thứ yếu}  
_texttrivial_ [l=vi] {Hiển nhiên}  

_textwhatdoing_ [l=vi] {Bạn định làm gì?}  
_textwhatexpected_ [l=vi] {Bạn mong đợi cái gì sẽ xảy ra?}  
_textwhathappened_ [l=vi] {Vấn đề gì thực sự xảy ra?}  

_cannotfindcgierror_ [l=vi] {<h2>Lỗi!</h2> Không tìm thấy chương trình chủ cho nút "_linktextusab_".}  

_textusabbanner_ [l=vi] {the Greenstone koru-style banner}


######################################################################
# GTI text strings
package gti
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------
	
_textgtierror_ [l=vi] {Lỗi}  

_textgtihome_ [l=vi] {Những trang bên dưới giúp phát triển bộ sưu tập Greenstone theo nhiều ngôn ngữ khác nhau. Người dùng có thể:
<ul>
  <li>Dịch từng phần của Greenstone sang một ngôn ngữ mới
  <li> Cập nhật lại giao diện với một ngôn ngữ đã tồn tại khi giao diện bằng tiếng Anh bị thay đổi (eg. Đối với khả năng mới của Greenstone )
  <li>Chỉnh sửa lỗi ở bản dịch đã có.
</ul>

Một loạt các nội dung trong trang web sẽ được hiển thị, mỗi nội dung là một từ hoặc cụm từ cần dịch.
Tiến hành dịch sang ngôn ngữ khác theo từng đoạn văn.
Nhiều đoạn văn bản chứa đựng các lệnh định dạng theo kiểu HTML thì không cần phải dịch và giữ nguyên chúng. Những từ đi kèm với các dấu gạch dưới (ví dụ: _this_) thì không cần dịch. 
<p>
Nếu đang thực hiện cập nhật ngôn ngữ cho giao diện, người dùng sẽ không thể thấy ngay được kết quả đã dịch. Đôi khi một nội dung đã được dịch nhưng trên giao diện vẫn thấy hiển thị bằng tiếng Anh. Trong trường hợp này cần kiểm tra và cập nhật lại bản dịch hiện tại.
<p>
Để hiệu chỉnh lại các nội dung đã dịch, nhấn vào “Chỉnh sửa bản dịch đã có”, chức năng này được cung cấp đối với mỗi Greenstone.
<p>
Kết thúc mỗi trang là nút “_textgtisubmit _”. Khi nhấn nút này, các thay đổi ngay lập tức sẽ khởi tạo một bộ Greenstone tại nzdl.org. Mỗi trang được cung cấp một nút để truy cập vào địa chỉ này.
}  

_textgtiselecttlc_ [l=vi] {Vui lòng chọn ngôn ngữ}  

#for status page
_textgtiviewstatus_ [l=vi] {Kích chuột để xem tình trạng dịch hiện tại cho mọi ngôn ngữ}  
_textgtiviewstatusbutton_ [l=vi] {XEM TRẠNG THÁI}  
_textgtistatustable_ [l=vi] {Trạng thái bản địa hiện tại của tất cả các ngôn ngữ}  
_textgtilanguage_ [l=vi] {Ngôn ngữ}  
_textgtitotalnumberoftranslations_ [l=vi] {Tổng số mục bản địa}  

_textgtiselecttfk_ [l=vi] {Vui lòng chọn một tập tin để làm việc với}  

_textgticoredm_ [l=vi] {Giao diện chính của Greenstone 2}  
_textgtiauxdm_ [l=vi] {Giao diện phụ của Greenstone 2}  
_textgtiglidict_ [l=vi] {Từ điển GLI}  
_textgtiglihelp_ [l=vi] {trợ giúp GLI}  
_textgtiperlmodules_ [l=vi] {mooddun Perl}  
_textgtitutorials_ [l=vi] {Bài tập hướng dẫn}  
_textgtigreenorg_ [l=vi] {Tập tin Greenstone.org}  
_textgtigs3interface_ [l=vi] {Giao diện Greenstone 3}  

#for greenstone manuals
_textgtidevmanual_ [l=vi] {Tài liệu hướng dẫn phát triển Greenstone}  
_textgtiinstallmanual_ [l=vi] {Tài liệu hướng dẫn cài đặt Greenstone}  
_textgtipapermanual_ [l=vi] {Tài liệu hướng dẫn tạo bộ sưu tập số từ giấy}  
_textgtiusermanual_ [l=vi] {Tài liệu hướng dẫn sử dụng Greenstone}  

_textgtienter_ [l=vi] {Đồng ý}  

_textgticorrectexistingtranslations_ [l=vi] {Chỉnh sửa bản dịch đã có}  
_textgtidownloadtargetfile_ [l=vi] {Tải tập tin}  
_textgtiviewtargetfileinaction_ [l=vi] {Xem tập tin}  
_textgtitranslatefileoffline_ [l=vi] {Dịch tệp tin này theo cách không trực tuyến}  

_textgtinumchunksmatchingquery_ [l=vi] {Số của đoạn văn bản riêng biệt thỏa với câu truy vấn}  

_textgtinumchunkstranslated_ [l=vi] {translations done}  
_textgtinumchunksrequiringupdating_ [l=vi] {Of these, _1_ Yêu cầu cập nhật}  
_textgtinumchunksrequiringtranslation_ [l=vi] {Bản dịch còn lại}  

#for status page
_textgtinumchunkstranslated2_ [l=vi] {số mục Việt hoá đã làm}  
_textgtinumchunksrequiringupdating2_ [l=vi] {số mục dịch bản địa yêu cầu cập nhật}  
_textgtinumchunksrequiringtranslation2_ [l=vi] {số mục bản địa chưa thực hiện}  

_textgtienterquery_ [l=vi] {Nhập vào một từ hoặc một thuật ngữ }  
_textgtifind_ [l=vi] {Tìm kiếm}  

_textgtitranslatingchunk_ [l=vi] {dịch các đoạn văn bản riêng biệt <i>_1_</i>}  
_textgtiupdatingchunk_ [l=vi] {Cập nhật từng văn bản riêng biệt <i>_1_</i>}  
_textgtisubmit_ [l=vi] {Xác nhận}  

_textgtilastupdated_ [l=vi] {cập nhật gần nhất}  

_textgtitranslationfilecomplete_ [l=vi] {Tập tin này  được cập nhật xong. Có thể tải về tập tin này bằng liên kết bên dưới, và có thể thêm vào bộ sưu tập Greenstone trong tương lai.}  

_textgtiofflinetranslation_ [l=vi] {Bạn có thể dịch phần này của Greenstone theo cách không trực tuyến (offline using) sử dụng tệp tin bảng tính Microsoft Excel:  <ol> <li>Tải xuống<a href="_gwcgi_?a=gti&p=excel&tct=work&e=_compressedoptions_">this file</a> để làm toàn bộ công việc còn lại, hoặc <a href="_gwcgi_?a=gti&p=excel&tct=all&e=_compressedoptions_">this file</a> cho từng phần thông tin của modun này. <li>Mở tệp tin Microsoft Excel được tải xuống (yêu cầu có Office 2003/XP hoặc phiên bản mới hơn) và lưu tệp theo định dạng Microsoft Excel workbook (.xls). <li>Nhập phần thông tin được dịch vào ô có sẵn. <li>Khi nào hoàn thành việc dịch các đoạn tin, e-mail tệp .xls file to <a href="mailto:_gtiadministratoremail_">_gtiadministratoremail_</a>. </ol> }  



############
# gli page
############
package gli

_textglilong_ [l=vi] {giao diện thủ thư}
_textglihelp_ [l=vi] {<p>Thư viện số Greestone (GLI) cho phép dễ dàng truy cập đến các chức năng của Greentones thông qua thao tác "Kéo thả chuột". Nó cho phép bạn tập hợp tài liệu nguồn, nhập hoặc chỉ định Metadata, và xây dựng chúng vào bộ sưu tập. </p>

<p>Chú ý rằng GLI được chạy kết hợp với Greenstone và phải được cài đặt trong thư mục con của thư mục cài đặt Greenstone.  Dưới đây sẽ là một số hướng dẫn nếu bạn cài đặt từ một trong những bản phân phối của Greenstone hoặc từ một CD-ROM Greenstone.
 
 
<h4>Chạy GLI trên Windows</h4>
 
Chạy giao diện thủ thư trên Windows bằng cách chọn <i>Start\Programs\Greenstone Digital Library\Librarian Interface</i>. 

 
<h4>Chạy GLI trên Unix</h4>
 
Để chạy GLI trên Unix chuyển thư mục đến thư mục <i>gli</i> trong thư mục cài đặt Greenstone sau đó chạy tập tin <i>gli.sh</i>. 
 
<h4>Chạy GLI trên Mac OS X</h4>

Trong công cụ tìm kiếm duyệt thư mục đến <i>Applications</i> sau đó là <i>Greenstone</i>
(nếu bạn cài đặt Greenstone vào thư mục mặc định) và chạy ứng dụng <i>GLI</i>.
}  
