/**********************************************************************
 *
 * gsdltimes.h -- functions to deal with time
 * Copyright (C) 1999  DigiLib Systems Limited, New Zealand
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef GSDLTIMES_H
#define GSDLTIMES_H

#include <time.h>
#include "text_t.h"

// dates are stored in the format YYYY/MM/DD hh:mm:ss

// returns "" if an error occurs
text_t time2text (time_t time);

// returns -1 if an error occurs
time_t text2time (const text_t &timestr);


// returns formatted date in local or UTC time
// returns "" if an error occurs
text_t get_date (bool ltime);

#endif
