# this file must be UTF-8 encoded
######################################################################
#
# Spanish Language text and icon macros 
# -- this file contains text that is of less importance
######################################################################

######################################################################
# 'home' page
package home
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_documents_ [l=es] {documentos. }
_lastupdate_ [l=es] {Última actualización }
_ago_ [l=es] {días.}
_colnotbuilt_ [l=es] {Colección no creada.}

_aimofsoftware_ [l=es] {El objetivo del software es capacitar a los usuarios, particularmente universidades, bibliotecas y otras instituciones de servicio, para construir sus propias bibliotecas digitales. Las bibliotecas digitales están reformando radicalmente la manera en que la información se difunde y se adquiere en la comunidades e instituciones asociadas en los ámbitos de la educación, la ciencia y la cultura en todo el mundo y, en particular, en los países en vías de desarrollo. Esperamos que este software fomente el despliegue de bibliotecas digitales para compartir información y ubicarlas en el dominio público.}

_softwaredevel_ [l=es] {Este software es desarrollado y distribuido como un esfuerzo cooperativo establecido en Agosto del 2000 entre tres partes.}

_nzdltitle_ [l=es] {Proyecto de Biblioteca Digital de Nueva Zelanda de la Universidad de Waikato}

_nzdldescr_ [l=es] {El software Greenstone surgió de este proyecto, y esta iniciativa ha sido aprobada por la Subcomisión de Comunicación de la Comisión Nacional de Nueva Zelanda para la UNESCO como parte de la contribución de Nueva Zelanda al programa de la UNESCO.}

_unescotitle_ [l=es] {Organización de las Naciones Unidas para la Educación, la Ciencia y la Cultura}

_unescodescr_ [l=es] {La diseminación de información educacional, científica y cultural en todo el mundo y, en particular, su disponibilidad en los países en desarrollo, es central para los objetivos de la UNESCO tal como se menciona en el Programa intergubernamental "Información para todos", y las tecnologías de la información y la comunicación se consideran una herramienta importante en este contexto.}

_humaninfotitle_ [l=es] {La ONG Human Info, con sede en Antwerp, Bélgica.}
_humaninfodescr_ [l=es] {Este proyecto trabaja con agencias de la ONU y otras ONG, y ha establecido
una reputación mundial en materia de digitalización de documentación de interés
para el desarrollo humano y ponerla a disposición de forma gratuita, de 
países en desarrollo y sobre una base de recuperación de costos.}

_textdescrselcol_ [l=es] {seleccionar una colección}

######################################################################
# home help page
package homehelp
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_text4buts_ [l=es] {Hay otros cuatro botones en la página principal }

_textnocollections_ [l=es] {<p>No hay actualmente ninguna colección disponible para esta instalación
de Greenstone. Para añadir colecciones, usted puede:

<ul>

<li>utilizar el Colector para crear nuevas colecciones

<li>o bien instalar colecciones a partir del CD-ROM de Greenstone, si
dispone de uno

</ul>

}

_text1coll_ [l=es] {Esta instalación de Greenstone contiene 1 colección }

_textmorecolls_ [l=es] {Esta instalación de Greenstone contiene _1_ colecciones }

######################################################################
# external link package
package extlink
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textextlink_ [l=es] {Enlace externo }
_textlinknotfound_ [l=es] {No se encontró el enlace interno }

_textextlinkcontent_ [l=es] {El enlace que usted ha seleccionado es externo a todas las colecciones
actualmente seleccionadas. Si desea de todos modos activar este enlace y
si su navegador está conectado a Internet, puede usted <a
href="_nexturl_" onClick="follow\_escaped\_link(event, this.href)">acudir</a> a esta página; en caso contrario, pulse el
botón "Atrás" de su navegador para volver al documento anterior.

}

_textlinknotfoundcontent_ [l=es] {El enlace interno que usted seleccionó no existe. Esto se debe
probablemente a un error en la colección fuente. Pulse el botón "Atrás"
de su navegador para volver al documento anterior.

}

# should have arguments of collection, collectionname and link
_foundintcontent_ [l=es] {<h3>Enlace con la colección "_2_"</h3>

<p>El enlace que ha seleccionado es externo a la colección
"_collectionname_" (remite a la colección "_2_"). Si desea ver el
documento que corresponde a este enlace en la colección "_2_", puede
<a href="_httpdoc_&c=_1_&cl=_cgiargclUrlsafe_&d=_3_">acudir</a> a esta página;
en caso contrario, pulse el botón "Atrás" de su navegador para volver al
documento anterior.

}

######################################################################
# authentication page
package authen
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textGSDLtitle_ [l=es] {Biblioteca Digital Greenstone }

_textusername_ [l=es] {nombre de usuario}
_textpassword_ [l=es] {contraseña}

_textmustbelongtogroup_ [l=es] {Se advierte que para acceder a esta página usted debe
pertenecer al grupo "_cgiargugHtmlsafe_"}

_textmessageinvalid_ [l=es] {Para acceder a la página que usted ha solicitado es necesario conectarse.<br>
_If_(_cgiargug_, [_textmustbelongtogroup_]<br>) Teclee por favor su nombre de
usuario de Greenstone y su contraseña.

}

_textmessagefailed_ [l=es] {Error en el nombre de usuario o la contraseña}

_textmessagedisabled_ [l=es] {Lo sentimos, pero se ha invalidado su cuenta. Por favor póngase en
contacto con el administrador de este sitio.

}

_textmessagepermissiondenied_ [l=es] {Lo sentimos, pero usted no tiene permiso de acceder a esta página.

}

_textmessagestalekey_ [l=es] {El enlace que usted ha seleccionado ya no es válido. Teclee por favor su
contraseña para tener acceso a esta página.

}

######################################################################
# collectoraction
package wizard

_textbild_ [l=es] {Construir colección}
_textbildsuc_ [l=es] {Colección construida exitosamente.}
_textviewbildsummary_ [l=es] {Puede <a href="_httppagex_(bsummary)" target=_top>ver el resumen </a> de esta colección para mayores detalles.}
_textview_ [l=es] {Ver colección}

_textbild1_ [l=es] {Se está construyendo la colección: llevará algún tiempo. La línea de estado de construcción, en la parte inferior, le informará de cómo progresa la operación.}

_textbild2_ [l=es] {Para detener el proceso de creación en cualquier momento, pulse aquí.
<br>La colección en la que está trabajando permanecerá intacta.}

_textstopbuild_ [l=es] {parar de construir}

_textbild3_ [l=es] {Si abandona esta página (y no ha cancelado el proceso de construcción mediante el botón "detener construcción") la colección continuará construyéndose y se instalará tras el éxito del proceso.}

_textbuildcancelled_ [l=es] {Construcción cancelada}

_textbildcancel1_ [l=es] {El proceso de construcción de la colección fué cancelado. Use los botones amarillos de la parte inferior para hacer cambios a la colección o para reiniciar el proceso.}

_textbsupdate1_ [l=es] {Actualización del estado del proceso de construcción en 1 segundo}
_textbsupdate2_ [l=es] {Actualización del estado de construcción}
_textseconds_ [l=es] {segundos}

_textfailmsg11_ [l=es] {La colección no pudo construirse y no contiene datos. Asegúrese de que al menos uno de los directorios o ficheros que especificó en la página <i>fuente de datos</i> existe, y de que es de un tipo o, en el caso de un directorio, de que contiene ficheros de tipos que Greenstone puede procesar.}

_textfailmsg21_ [l=es] {La colección no pudo ser construida (import.fl falló)}
_textfailmsg31_ [l=es] {No pudo construirse la coleción (falló buildcol.pl)}
_textfailmsg41_ [l=es] {La construcción se construyó correctamente pero no se pudo instalar.}
_textfailmsg71_ [l=es] {Ha ocurrido un error inesperado durante el intento de construir la colección}

_textblcont_ [l=es] {El registro de construcción contiene la siguiente información:}

######################################################################
# collectoraction
package collector
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultstructure_ [l=es] {Estructura por defecto}
_textmore_ [l=es] {más}
_textinfo_ [l=es] {Informaciones sobre la colección}
_textsrce_ [l=es] {Datos fuente}
_textconf_ [l=es] {Configurar la colección}
_textdel_ [l=es] {Eliminar la colección}
_textexpt_ [l=es] {Exportar la colección}

_textdownloadingfiles_ [l=es] {Bajando ficheros...}
_textimportingcollection_ [l=es] {Importando una colección...}
_textbuildingcollection_ [l=es] {Construyendo una colección...}
_textcreatingcollection_ [l=es] {creando una colección...}

_textcollectorblurb_ [l=es] {<i>¡La pluma es más poderosa que la espada!

<br>
Antes de crear y distribuir colecciones de información, hay que
reflexionar sobre las consecuencias y las responsabilidades que ello
entraña. Hay cuestiones jurídicas de derecho de autor: poder tener
acceso a documentos no significa necesariamente poder comunicarlos a
terceros. Hay también cuestiones de tipo social: en el manejo de las
colecciones se deben respetar los usos y costumbres de la comunidad de
la que proceden los documentos. Y hay también cuestiones éticas: algunos
documentos no deben ponerse a disposición de nadie.

<br>Sea consciente del poder de la información y utilícelo con prudencia.

</i>

}

_textcb1_ [l=es] {El Colector le ayuda a crear nuevas colecciones y modificar, añadir o
suprimir colecciones. Para hacerlo, será guiado por una secuencia de
páginas Web en que se le pedirá la información necesaria.

}

_textcb2_ [l=es] {Primero, debe decidir si }
_textcnc_ [l=es] {Crear una nueva colección }
_textwec_ [l=es] {Trabajar con una colección existente, añadiéndole datos o suprimiéndola }

_textcb3_ [l=es] {Para crear o modificar colecciones de biblioteca digital es
necesario registrarse. Esto permite evitar que otras personas entren en
su computadora y alteren la información. Nota: por razones de seguridad
tendrá que conectarse de nuevo cada media hora. Si esto sucede, ¡no se
preocupe! - se le invitará a abrir una nueva sesión y podrá usted
continuar a partir de donde se encontraba en el momento de la
desconexión.

}

_textcb4_ [l=es] {Teclee por favor su nombre de usuario de Greenstone y su contraseña y
pulse el botón para conectarse.

}

_textfsc_ [l=es] {Primero seleccione la colección con la cual desea usted trabajar (las
colecciones protegidas contra la escritura no aparecerán en esta lista).

}

_textwtc_ [l=es] {Con la colección seleccionada, usted puede

}
_textamd_ [l=es] {Añadir más datos y recrear la colección

}
_textetc_ [l=es] {Modificar el fichero de configuración de la colección y recrear la
colección

}
_textdtc_ [l=es] {Suprimir la colección definitivamente

}
_textetcfcd_ [l=es] {Exportar la colección para grabarla en un CD-ROM que se instala
automáticamente en Windows

}
_textcaec_ [l=es] {Cambiar una colección existente

}
_textnwec_ [l=es] {No está disponible para su modificación ninguna colección que permita la
escritura

}
_textcianc_ [l=es] {Crear una nueva colección

}
_texttsosn_ [l=es] {La secuencia de las fases necesarias para crear una nueva colección de
biblioteca digital es la siguiente:

}
_textsin_ [l=es] {Especificar su nombre (y otras informaciones asociadas)

}
_textswts_ [l=es] {Especificar de dónde provienen los datos fuente

}
_textatco_ [l=es] {Ajustar las opciones de configuración (sólo para usuarios
experimentados)

}
_textbtc_ [l=es] {"Crear" la colección (véase más abajo)

}
_textpvyh_ [l=es] {¡Admire su obra!

}

_texttfsiw_ [l=es] {La cuarta fase es cuando la computadora hace todo el trabajo. En el
proceso de "creación" la computadora elabora todos los índices y
recopila todas las informaciones necesarias para el buen funcionamiento
de la biblioteca digital. Pero primero tiene usted que especificar
las informaciones.

}

_textadab_ [l=es] {Más abajo aparece un diagrama que le ayudará ver dónde se encuentra. El
botón verde es el que usted pulsará para continuar la secuencia. Después
de cada paso en la secuencia, los botones cambiarán al amarillo. Se
puede volver a una página anterior pulsando el botón amarillo
correspondiente en el diagrama.

}

_textwyar_ [l=es] {Cuando esté listo, pulse el botón verde "informaciones sobre la
colección" para comenzar a crear su nueva colección de biblioteca
digital.

}

_textcnmbs_ [l=es] {Se debe especificar el nombre de la colección}
_texteambs_ [l=es] {Se debe especificar la dirección de correo electrónico}
_textpsea_ [l=es] {Compruebe por favor que la dirección de correo electrónico corresponde al formato usuario@dominio}
_textdocmbs_ [l=es] {Se debe especificar la descripción de la colección}

_textwcanc_ [l=es] {Al crear una nueva colección, es necesario incorporar algunas
informaciones preliminares sobre los datos fuente. Este proceso se
estructura en forma de una serie de páginas Web, supervisadas por el
Colector. La barra en la parte inferior de la página muestra la
secuencia de las páginas que quedan.

}

_texttfc_ [l=es] {Título de la colección:

}

_texttctiasp_ [l=es] {El título de la colección es una frase corta que se utiliza en la
biblioteca digital para identificar el contenido de la colección.
Por ejemplo: "Computer Science Technical Reports" (Informes técnicos de
informática) o "Humanity Development Library" (Biblioteca para el
desarrollo de la humanidad).

}

_textcea_ [l=es] {Dirección de correo electrónico de contacto:

}

_textteas_ [l=es] {Esta dirección electrónica constituye el primer punto de contacto para
la colección. Si el programa Greenstone detecta un problema, un informe
de diagnóstico se envía a esta dirección. Teclee una dirección
electrónica en su forma completa: nombre@dominio.

}

_textatc_ [l=es] {Acerca de esta colección:

}

_texttiasd_ [l=es] {Ésta es una declaración en que se enuncian los principios que rigen los
elementos que forman parte de esta colección. Aparecerá en la primera
página de presentación de la colección.

}

_textypits_ [l=es] {Su posición en la secuencia se indica con una flecha por debajo - en
este caso, la etapa de las "informaciones de colección". Para continuar,
pulse el botón verde "datos fuente".

}

_srcebadsources_ [l=es] {<p>Uno o más de los ficheros fuente que usted especificó no está disponible
(marcados _iconcross_ abajo).

<p>Esto puede ser porque:

<ul>

<li>No existe el fichero, el sitio FTP o el URL.

<li>Hay que conectarse primero a Internet.

<li>Usted está intentando acceder a un URL que se encuentra detrás de un
cortafuego (esto ocurre normalmente cuando usted tiene que presentar un
nombre de usuario y una contraseña para acceder a Internet).

</ul>

<p>Si éste es un URL que usted puede ver en su navegador, el problema
puede provenir de una copia que se encuentra en la memoria cache local.
Desafortunadamente, estas copias son invisibles para nuestro proceso de
espejo de Greenstone. En este caso recomendamos que descargue las
páginas mediante su navegador.

}

_textymbyco_ [l=es] {Usted puede basar su colección en:

<ul>
<li>La estructura por defecto
</ul>
<dl> <dd> La nueva colección puede contener documentos HTML (.htm,
.html), documentos texto (.txt, .text), documentos MS-Word (.doc),
documentos PDF (.pdf), o documentos de correo electrónico en el formato
"m-box" (.mbx). </dd> </dl>
<li>Una colección existente
<dl> <dd> Los ficheros de su nueva colección deben ser exactamente del mismo
tipo que los utilizados para crear la colección existente. </dd> </dl>
</ul>
}

_textbtco_ [l=es] {Basar la colección en:}
_textand_ [l=es] {Añadir nuevos datos}
_textad_ [l=es] {Añadir datos:}

_texttftysb_ [l=es] {Los ficheros que usted especifique más abajo se añadirán a la colección.
Cerciórese de no volver a especificar ficheros que ya están en la
colección, pues de hacerlo habrá dos copias. Los ficheros se especifican
indicando su nombre completo y el directorio en que están almacenados,
las páginas Web se identifican por su dirección Internet absoluta.

}

_textis_ [l=es] {Datos de entrada: }

_textddd1_ [l=es] {<p>Si usted utiliza file:// o ftp:// para especificar un fichero, éste
se descargará.

<p>Si usted utiliza HTTP://, el resultado dependerá del URL y será
diferente si éste abre en su navegador una página Web o una lista de
ficheros. Si se trata de una página, ésta se descargará, al igual que
todas las páginas con las que está vinculada mediante hiperenlaces,-
siempre que se encuentren en el mismo sitio Web, en el URL inicial.

<p>Si usted utiliza file:// o ftp:// para especificar un directorio, o
si indica un URL HTTP:// que conduce a una lista de ficheros, todos los
ficheros que se encuentran en esa carpeta y en sus subcarpetas se
incluirán en la colección.

<p>Pulse el botón "más datos" para obtener más cuadros de introducción
de datos.

}

_textddd2_ [l=es] {<p>Pulse uno de los botones verdes. Si es usted un usuario
experimentado, puede desear ajustar la configuración de la colección.
Otra posibilidad es ir directamente a la etapa de creación. Recuerde, se
puede volver a un paso anterior pulsando el botón amarillo
correspondiente.

}

_textconf1_ [l=es] {<p>La creación y la presentación de su colección son controladas por
especificaciones en un "fichero de configuración" especial. Los usuarios
experimentados que lo deseen pueden modificar los parámetros de la
configuración.

<center><p><b>Si no es usted un usuario experimentado, vaya a la parte
inferior de la página.</b></center> 

<p>Para modificar los parámetros de la configuración, corrija los datos que
aparecen más abajo. Si comete una equivocación, pulse el botón
"Reinicio" para restablecer los parámetros originales de la
configuración.

}

_textreset_ [l=es] {Reiniciar}

_texttryagain_ [l=es] {Por favor <a href="_httppagecollector_" target=_top>vuelva a
arrancar el Colector</a> e intente de nuevo.

}

_textretcoll_ [l=es] {Volver al Colector

}

_textdelperm_ [l=es] {No se pudo suprimir toda o una parte de la colección _cgiargbc1dirnameHtmlsafe_ . Las causas pueden ser las siguientes:
<ul>
<li> Greenstone no tiene permiso para suprimir el directorio _gsdlhome_/collect/_cgiargbc1dirnameHtmlsafe_.<br> 
Es posible que usted necesite eliminar este directorio manualmente para poder suprimir completamente la colección _cgiargbc1dirnameHtmlsafe_ de esta computadora.</</li>
<li>Greenstone no pudo correr el programa _gsdlhome_/bin/script/delcol.pl. Asegúrese de que este fichero se pueda leer y sea ejecutable.</li>
</ul>
}

_textdelinv_ [l=es] {La colección _cgiargbc1dirnameHtmlsafe_ está protegida o no es válida. La
supresión se canceló.

}

_textdelsuc_ [l=es] {Se suprimió la colección _cgiargbc1dirnameHtmlsafe_.

}

_textclonefail_ [l=es] {No se pudo clonar la colección _cgiargclonecolHtmlsafe_. Las causas posibles
son:

<ul>
<li>La colección _cgiargclonecolHtmlsafe_ no existe
<li>La colección _cgiargclonecolHtmlsafe_ no tiene ningún archivo collect.cfg
<li>Greenstone no tiene permiso para leer el archivo de configuración
collect.cfg
</ul>

}

_textcolerr_ [l=es] {Error en el Colector. }

_texttmpfail_ [l=es] {El Colector no pudo efectuar ninguna operación de lectura o de escritura
en el fichero o directorio temporal. Las causas posibles son:

<ul>

<li>Greenstone no tiene acceso de lectura/escritura al directorio
_gsdlhome_/tmp.

</ul>

}

_textmkcolfail_ [l=es] {El Colector no pudo crear la estructura de directorios que requiere la
nueva colección (mkcol.pl falló). Las causas posibles son:

<ul>

<li>Greenstone no tiene permiso para escribir en el directorio
_gsdlhome_/tmp.

<li>Errores en el guión Perl mkcol.pl.

</ul>

}

_textnocontent_ [l=es] {Error del Colector: no se proporcionó ningún nombre para la nueva
colección. Intente volver a arrancar el Colector.

}

_textrestart_ [l=es] {Volver a arrancar el Colector

}

_textreloaderror_ [l=es] {Se produjo un error cuando se creaba la nueva colección. Es posible que
el uso de los botones "Volver a cargar" o "Atrás" de su navegador haya
perturbado a Greenstone (trate de evitar la utilización de esos botones
durante la creación de una colección con el Colector). Se recomienda
volver a arrancar el Colector.

}

_textexptsuc_ [l=es] {La colección de _cgiargbc1dirnameHtmlsafe_ se exportó al directorio
_gsdlhome_/tmp/exported\__cgiargbc1dirnameHtmlsafe_.

}

_textexptfail_ [l=es] {<p>Fallo en la exportación de la colección _cgiargbc1dirnameHtmlsafe_.

<p>Esto puede deberse a que Greenstone fue instalado sin los componentes necesarios para soportar a la función "Exportar colección".
<ul>

 <li>Si instaló una versión de Greenstone anterior a la 2.70 desde un CD-ROM 
 estos componentes no se instalan a menos que los seleccione en una instalación personalizada ("Custom"). Puede agregarlos a su sistema ejecutando nuevamente el procedimiento de instalación.

 <li>Si instaló Greenstone de una distribución descargada de la web entonces necesitará descargar un paquete adicional para habilitar esta función. Por favor, visite <a href="http://www.greenstone.org">http://www.greenstone.org</a> o 
 <a
 href="https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">la lista de mailing</a> para mayores detalles.

</ul>
}

######################################################################
# depositoraction
package depositor
######################################################################

_textdepositorblurb_ [l=es] {<p> Por favor, indique la siguiente información de fichero y selecciónelo en la parte inferior</p>}

_textcaec_ [l=es] {Añadiendo a una colección existente}
_textbild_ [l=es] {Depositar Elemento}
_textintro_ [l=es] {Seleccionar fichero}
_textconfirm_ [l=es] {Confirmación}
_textselect_ [l=es] {Seleccionar Colección}
_textmeta_ [l=es] {Especificar metadatos}
_textselectoption_ [l=es] {seleccione la colección…}

_texttryagain_ [l=es] {Por favor, <a href="_httppagedepositor_" target=_top>reinicie el acumulador</a> y pruebe de nuevo.}

_textselectcol_ [l=es] {Seleccione la colección a la que quiere añadir un documento nuevo.}
_textfilename_ [l=es] {Nombre de fichero}
_textfilesize_ [l=es] {Tamaño del fichero}

_textretcoll_ [l=es] {Volver al acumulador}

_texttmpfail_ [l=es] {El Acumulador falló en la lectura o escritura de un fichero temporal o directorio. Las causas posibles son:
<ul>
<li> Greenstone no tiene acceso de lectura/escritura para el directorio _gsdlhome_/tmp.
</ul>
}

######################################################################
# 'gsdl' page
package gsdl
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textgreenstone1_ [l=es] {<p>Greenstone es un conjunto de programas informáticos cuya
finalidad es dar acceso a colecciones de información que constituyen
una biblioteca digital y crear nuevas colecciones. Ofrece una nueva manera de organizar la información y de publicarla en Internet o en soporte removible como DVD  o un disco USB externo.  Elaborado dentro del proyecto de Biblioteca
Digital de Nueva Zelanda de la Universidad de Waikato, este producto
se distribuye en colaboración con la UNESCO y la ONG Human
Info. Es un programa informático de código fuente
abierto (<i>open-source software</i>), que puede descargarse en la
dirección <a href="_1_">http://www.greenstone.org</a>, según
las condiciones estipuladas en la Licencia Pública General de
GNU.

}

_textexamplestitle_ [l=es] {ejemplos}
_textgreenstone2_ [l=es] {El sitio web de la Biblioteca Digital de Nueva Zelandia (<a href="_1_">http://nzdl.org</a>) contiene numerosos ejemplos de colecciones, todos creados con el programa Greenstone, que se pueden consultar libremente. Ejemplifican varias opciones de búsqueda y navegación, e incluyen colecciones en árabe, chino, francés, maorí y español, así
como en inglés. Muchas de esas colecciones han sido producidas por la ONG Human Info y han sido distribuidas en CD-ROM, como por ejemplo la <a href="_2_">Biblioteca para el Desarrollo humano</a>. La <a href="_3_">página de ejemplo de Greenstone.org</a> también lista una vasta cantidad de ejemplos de bibliotecas Greenstone de todo el mundo.

}

_texttechnicaltitle_ [l=es] {técnico}
_texttechnical_ [l=es] {Consulte la <a href="_1_"> hoja de datos Greenstone</a> para obtener detalles técnicos, como versiones, soporte de la plataforma e interoperabilidad. Hay dos versiones principales del software: Greenstone 2 (el original), y Greenstone 3, que es un completo rediseño y reimplementación. Greenstone 3 está bajo desarrollo activo, y se recomienda para su descarga. Esta página es parte de es una instalación de Greenstone 2.}

_textcustomisationtitle_ [l=es] {personalización}

_textgreenstone5_ [l=es] {Greenstone está especialmente concebido para poder ampliarse y personalizarse a voluntad. Greenstone puede tratar nuevos formatos de documentos y de metadatos escribiendo "conectores" (<i>plugins</i>), en lenguaje Perl. Asimismo, se pueden implementar nuevas estructuras de navegación de metadatos escribiendo "clasificadores." La interfaz de usuario y la presentación se pueden modificar utilizando las "macros" escritas en un lenguaje de macros simple. El código fuente en C++, Perl y Java se encuentra disponible para su modificación. Para más información, ver la <a href="_1_">wiki de Greenstone</a>.

}

_textdocumentationtitle_ [l=es] {documentación}
_textdocuments_ [l=es] {La documentación completa del software Greenstone está disponible en la <a href="_1_">Wiki de Greenstone</a>, incluyendo <a href="_2_">tutoriales</a> paso a paso. }

_textsupporttitle_ [l=es] {soporte}

_textsupport_ [l=es] {Ver la página de <a href="_1_">soporte</a> para detalles acerca de listas de emails específicas en distintos idiomas, grupos de soporte regional y otros recursos.}

_textbugstitle_ [l=es] {errores lógicos o de programación}
_textreport_ [l=es] {Queremos asegurarnos de que este software le funcione correctamente. Por favor, informe cualquier error o bug a <a href="_1_">la lista de mailing</a>.
}

_textaboutgslong_ [l=es] {acerca del programa greenstone}

_textgreenstone_ [l=es] {<p>Greenstone es una piedra semipreciosa que (como este software) tiene origen en Nueva Zelanda. En la sociedad Maorí tradicional era la más preciada y buscada de todas las sustancias. Podía absorber y retener <i>wairua</i>, que es un espíritu o fuerza viva, y está dotado de virtudes tradicionales que lo convierten en un emblema apropiado para un proyecto de biblioteca digital de dominio público. Su lustre muestra caridad; su translucidez, honestidad; su
dureza, valor; y el filo que puede tomar, la justicia.}

_texttokilink_ [l=es] {Ver la imagen de toki más grande}
_texttokidesc1_ [l=es] {En Noviembre del 2000, un "toki pou tangata" (una hachuela de greenstone) fue presentada por Māori a la Biblioteca Digital de Nueva Zelanda para reconocer el importante trabajo que se está haciendo con un tesoro (taonga) tal como la <a href="_1_">Colección Niupepa</a>. El toki fue tallado por Bernard Makoare de Ngāti Whātua y descendiente de Te Rarawa.}
_texttokidescr2_ [l=es] {El toki simboliza el significado del pounamu (greenstone). Es para inspirar el trabajo que se está haciendo aquí con cualidades de maná, autoridad y liderazgo. Es una piedra dura, una conexión que hay que hacer. Se debe utilizar para esculpir y guiar la excelencia del pensamiento que se cosecha en la Biblioteca Digital de Nueva Zelanda.}

######################################################################
# 'users' page
package userslistusers
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textlocu_ [l=es] {Lista de los usuarios actuales}
_textuser_ [l=es] {usuario}
_textas_ [l=es] {estado de la cuenta}
_textgroups_ [l=es] {grupos}
_textcomment_ [l=es] {comentario}
_textadduser_ [l=es] {añadir un nuevo usuario }
_textedituser_ [l=es] {modificar}
_textdeleteuser_ [l=es] {suprimir}

######################################################################
# 'users' page
package usersedituser
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textedituser_ [l=es] {Modificar las informaciones relativas a los usuarios}
_textadduser_ [l=es] {Añadir un nuevo usuario}

_textaboutusername_ [l=es] {Los nombres de usuarios deben tener entre 2 y 30 caracteres. Pueden
estar compuestos de caracteres alfanuméricos, '.', y '_'.
}

_textaboutpassword_ [l=es] {Las contraseñas deben ser de entre 3 y 8 caracteres, y pueden comprender
todos los caracteres ASCII imprimibles.
}

_textoldpass_ [l=es] {Si este campo se deja vacío, se utilizará la antigua contraseña. }
_textenabled_ [l=es] {activado }
_textdisabled_ [l=es] {desactivado }

_textaboutgroups_ [l=es] {Los grupos son listas cuyos elementos están separados por comas, no
teclee espacios después de las comas.}
_textavailablegroups_ [l=es] {Los grupos predefinidos incluyen al administrador y otros que pueden asignar permisos para la construccion remota de colecciones usando el GLI o el Depositor: <ul> <li><b>administrator</b>: Otorga permisos para acceder y cambiar la configuración del sitio y las cuentas de usuarios. <li><b>personal-collections-editor</b>: Otorga permisos para crear nuevas colecciones personales. <li><b><nombre-coleccion>-collection-editor</b>: Otorga permisos para crear y editar la colección "nombre-coleccion", por ejemplo, reportes-collection-editor. <li><b>all-collections-editor</b>: Otorga permisos para crear nuevas colecciones globales y personales y editar <b>todas</b> las colecciones. </ul> }

######################################################################
# 'users' page
package usersdeleteuser
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdeleteuser_ [l=es] {Suprimir un usuario}
_textremwarn_ [l=es] {¿Confirma usted que desea suprimir definitivamente el usuario <b>_cgiargumunHtmlsafe_</b>?}

######################################################################
# 'users' page
package userschangepasswd
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textchangepw_ [l=es] {Cambiar la contraseña}
_textoldpw_ [l=es] {antigua contraseña}
_textnewpw_ [l=es] {nueva contraseña}
_textretype_ [l=es] {vuelva a teclear su nueva contraseña}

######################################################################
# 'users' page
package userschangepasswdok
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsuccess_ [l=es] {Se ha registrado su nueva contraseña}

######################################################################
# 'users' page
package users
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textinvalidusername_ [l=es] {El nombre de usuario no es válido.}
_textinvalidpassword_ [l=es] {La contraseña no es válida.}
_textemptypassword_ [l=es] {Teclee una contraseña inicial para este usuario.}
_textuserexists_ [l=es] {Este usuario ya existe, teclee por favor otro
nombre de usuario.}

_textusernameempty_ [l=es] {Teclee por favor su nombre de usuario.}
_textpasswordempty_ [l=es] {Tiene que teclear su antigua contraseña.}
_textnewpass1empty_ [l=es] {Teclee su nueva contraseña y vuélvala a teclear.}
_textnewpassmismatch_ [l=es] {Las dos versiones de su nueva contraseña son distintas.}
_textnewinvalidpassword_ [l=es] {La contraseña es incorrecta.}
_textfailed_ [l=es] {Es incorrecto el nombre de usuario o la contraseña.}

######################################################################
# 'status' pages
package status
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textversion_ [l=es] {Número de versión de Greenstone}
_textframebrowser_ [l=es] {Para visualizar esto se requiere un navegador que acepte los marcos ("frames").}
_textusermanage_ [l=es] {Gestión de los usuarios}
_textlistusers_ [l=es] {lista de los usuarios}
_textaddusers_ [l=es] {añadir un nuevo usuario}
_textchangepasswd_ [l=es] {cambiar de contraseña}
_textinfo_ [l=es] {Informaciones técnicas}
_textgeneral_ [l=es] {general}
_textarguments_ [l=es] {argumentos}
_textactions_ [l=es] {acciones}
_textbrowsers_ [l=es] {navegadores}
_textprotocols_ [l=es] {protocolos}
_textconfigfiles_ [l=es] {Ficheros de configuración}
_textlogs_ [l=es] {Registros}
_textusagelog_ [l=es] {registro de uso}
_textinitlog_ [l=es] {registro de inicialización}
_texterrorlog_ [l=es] {registro de errores}
_textadminhome_ [l=es] {página principal de la administración}
_textreturnhome_ [l=es] {página principal de Greenstone}
_titlewelcome_ [l=es] {Administración }
_textmaas_ [l=es] {Los servicios de mantenimiento y de administración son los siguientes:}
_textvol_ [l=es] {mostrar los registros en línea}
_textcmuc_ [l=es] {crear, mantener y actualizar colecciones}
_textati_ [l=es] {acceder a informaciones técnicas tales como los argumentos CGI}

_texttsaa_ [l=es] {Se puede acceder a estos servicios mediante la barra de navegación
situada en la parte izquierda de la página.
}

_textcolstat_ [l=es] {Estado de la colección}

_textcwoa_ [l=es] {Una colección sólo aparecerá como "running" (en funcionamiento) si el
fichero build.cfg existe, si es legible, si contiene un campo válido
"builddate" (fecha de creación), es decir &gt; 0, y si se encuentra en
el directorio "index" de la colección (es decir NO en el directorio
"build").

}

_textcafi_ [l=es] {Pulse <i>abbrev.</i> para obtener informaciones sobre una colección}
_textcctv_ [l=es] {Pulse <i>collection</i> para visualizar una colección}
_textsubc_ [l=es] {Someter cambios }
_texteom_ [l=es] {Error de lectura del fichero main.cfg}
_textftum_ [l=es] {No se pudo actualizar el fichero main.cfg }
_textmus_ [l=es] {se logró actualizar el fichero main.cfg }

######################################################################
# 'bsummary' pages
package bsummary
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textbsummary_ [l=es] {Resumen de la creación de la colección "_collectionname_"

}
_textflog_ [l=es] {Lista de errores de la colección  "_collectionname_"

}
_textilog_ [l=es] {Resumen de la importación de la colección "_collectionname_"}

############################################################################
#
# This stuff is only used by the usability (SEND FEEDBACK) stuff
#
############################################################################
package Global

# old cusab button
_linktextusab_ [l=es] {ENVIAR COMENTARIOS}

_greenstoneusabilitytext_ [l=es] {Capacidad de uso de Greenstone}

_textwhy_ [l=es] {<p>Enviar este informe es una forma de indicar que la página Web que usted estaba viendo era difícil de manejar o resultaba frustrante. }
_textextraforform_ [l=es] {Usted no tiene que llenar la forma. Cualquier información será de ayuda.}
_textprivacybasic_ [l=es] {<p>El informe sólo contendrá información sobre la página web de Greenstone que usted está viendo, y de la tecnología que está usando para verla (así como cualquier información adicional que usted proporcione).}
_textstillsend_ [l=es] {¿Todavía querría enviar este informe?}

_texterror_ [l=es] {error}
_textyes_ [l=es] {Si}
_textno_ [l=es] {No}
_textclosewindow_ [l=es] {Cerrar ventana}
_textabout_ [l=es] {Acerca de}
_textprivacy_ [l=es] {Confidencialidad}
_textsend_ [l=es] {Enviar}
_textdontsend_ [l=es] {No enviar}
_textoptionally_ [l=es] {De manera opcional}

_textunderdev_ [l=es] {Una vista previa de los detalles estará disponible en la versión final.}

_textviewdetails_ [l=es] {Ver los detalles del informe}
_textmoredetails_ [l=es] {Más detalles}
_texttrackreport_ [l=es] {Dar seguimiento a este informe}
_textcharacterise_ [l=es] {¿Qué clase de problema es?}
_textseverity_ [l=es] {¿Cúal es la importancia del problema?}

_textbadrender_ [l=es] {La página se ve extraña}
_textcontenterror_ [l=es] {Error de contenido}
_textstrangebehaviour_ [l=es] {Comportamiento extraño}
_textunexpected_ [l=es] {Sucedió algo inesperado}
_textfunctionality_ [l=es] {Difícil de usar}
_textother_ [l=es] {Otro(s)}

_textcritical_ [l=es] {Crítico}
_textmajor_ [l=es] {Serio}
_textmedium_ [l=es] {Medio}
_textminor_ [l=es] {Menor}
_texttrivial_ [l=es] {Trivial}

_textwhatdoing_ [l=es] {¿Qué estaba intentando hacer?}
_textwhatexpected_ [l=es] {¿Qué esperaba usted que pasara?}
_textwhathappened_ [l=es] {¿Qué pasó en realidad?}

_cannotfindcgierror_ [l=es] {<h2>¡Disculpe!</h2>No se pudieron encontrar los programas del servidor para el botón "_linktextusab_".}

_textusabbanner_ [l=es] {el rótulo estilo koru de Greenstone}

######################################################################
# GTI text strings
package gti
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textgtierror_ [l=es] {Ha ocurrido un error}

_textgtihome_ [l=es] {Estas páginas le ayudan a mejorar el soporte de Greenstone para otros idiomas. Usándolo, usted puede
<ul>
  <li>traducir partes de Greenstone a un nuevo idioma
  <li>actualizar una interfaz de idioma existente cuando cambie la interfaz en inglés (por ej., para incorporar nuevas prestaciones de Greenstone)
  <li>corregir errores en traducciones existentes
</ul>

Se le mostrará una serie de páginas web, cada una de las cuales contiene una frase para traducir.
Debe proceder traduciendo las frases una por una.
Muchas frases contienen etiquetas de formato HTML: no debe intentar traducirlas, sino que debe dejarlas intactas en la versión traducida. Las palabras rodeadas por guiones bajos (como _esta_) tampoco deben traducirse (son nombres de "macro" de Greenstone).
<p>
Si usted está actualziando una traducción ya existente, no se le mostrarán frases para las que ya exista traducción. En ocasiones, una traducción existe, pero el texto inglés correspondiente ha sido cambiado. En este caso se le mostrará la traducción existente y deberá comprobarla y cambiarla si es necesario.
<p>
Cada página termina con un botón "_textgtisubmit_". Cuando lo pulse, los cambios serán incorporados automáticamente a una instalación independiente de Greenstone en nzdl.org. Se mostrará en cada página un botón que permite acceder a esta instalación.}

_textgtiselecttlc_ [l=es] {Por favor, seleccione su idioma}

#for status page
_textgtiviewstatus_ [l=es] {Pulse para ver el estado actual de las traducciones de todos los idiomas}
_textgtiviewstatusbutton_ [l=es] {VER ESTADO}
_textgtistatustable_ [l=es] {Lista del estado actual de las traducciones de todos los idiomas}
_textgtilanguage_ [l=es] {Idioma}
_textgtitotalnumberoftranslations_ [l=es] {Número total de traducciones}

_textgtimodulenotes_ [l=es] {Nota: Para una versión de Greenstone3, traduzca los módulos: _textgtigs3interface_, _textgtiglidict_, _textgtigsinstaller_, _textgtiperlmodules_, _textgtiglihelp_, _textgtigs3colcfg_. <br/>Para Greenstone2, traduzca los módulos: _textgticoredm_, _textgtiauxdm_, _textgtiglidict_, _textgtigsinstaller_, _textgtiperlmodules_, _textgtiglihelp_. <br/>El módulo _textgtiauxdm_ también contiene el texto para la interfaz GTI. }
_textgtiselecttfk_ [l=es] {Por favor, seleccione un fichero sobre el que trabajar}

_textgticoredm_ [l=es] {Interfaz Greenstone 2 (Núcleo)}
_textgtiauxdm_ [l=es] {Interfaz Greenstone 2 (Auxiliar)}
_textgtiglidict_ [l=es] {Diccionario GLI}
_textgtiglihelp_ [l=es] {Ayuda de GLI}
_textgtiperlmodules_ [l=es] {Módulos de Perl}
_textgtitutorials_ [l=es] {Ejercicios de Seminario}
_textgtigreenorg_ [l=es] {Greenstone.org}
_textgtigs3interface_ [l=es] {Interfaz de Greenstone3}
_textgtigsinstaller_ [l=es] {Instalador de Greenstone}
_textgtigs3colcfg_ [l=es] {GS3 demo col-cfg}
_textgtigs3deccolcfg_ [l=es] {GS3 DEC coll-cfg}

#for greenstone manuals
_textgtidevmanual_ [l=es] {Manual de Desarrollador de Greenstone}
_textgtiinstallmanual_ [l=es] {Manual del Instalador de Greenstone}
_textgtipapermanual_ [l=es] {Manual Greenstone "Del papel a la colección"}
_textgtiusermanual_ [l=es] {Manual de Usuario de Greenstone}

_textgtienter_ [l=es] {RETORNO}

_textgticorrectexistingtranslations_ [l=es] {Corrige traducciones existentes}
_textgtidownloadtargetfile_ [l=es] {Descargar fichero}
_textgtiviewtargetfileinaction_ [l=es] {Ver este fichero en funcionamiento}
_textgtitranslatefileoffline_ [l=es] {Traducir este fichero sin conexión}

_textgtinumchunksmatchingquery_ [l=es] {Número de fragmentos de texto que cumplen la condición}

_textgtinumchunkstranslated_ [l=es] {traducciones hechas}
_textgtinumchunksrequiringupdating_ [l=es] {De éstos, _1_ requieren actualización}
_textgtinumchunksrequiringtranslation_ [l=es] {traducciones pendientes}

#for status page
_textgtinumchunkstranslated2_ [l=es] {número de traducciones hechas}
_textgtinumchunksrequiringupdating2_ [l=es] {número de traducciones que requieren actualización}
_textgtinumchunksrequiringtranslation2_ [l=es] {número de traducciones pendientes}

_textgtienterquery_ [l=es] {Introduzca una palabra o frase del fragmento de texto que quiere corregir}
_textgtifind_ [l=es] {BUSCAR}

_textgtitranslatingchunk_ [l=es] {Traduciendo el fragmento de texto <i>_1_</i>}
_textgtiupdatingchunk_ [l=es] {Actualizando el fragmento de texto <i>_1_</i>}
_textgtiremovepending_ [l=es] {<b>Nota:</b> al <i>actualizar</i> un fragmento de texto, quite cualquier ocurrencia de  "[PENDING]" en <br/>el inicio del fragmento, dado que las traducciones que comienzan con [PENDING] permanecerán ocultas.}
_textgtisubmit_ [l=es] {ENVIAR}

_textgtilastupdated_ [l=es] {Última actualización}

_textgtitranslationfilecomplete_ [l=es] {Gracias por actualizar este fichero -- ¡ahora está completo!<p> Puede descargar una copia del fichero usando el enlace superior, y podrá también ser incluido en futuras versiones de Greenstone.}

_textgtiofflinetranslation_ [l=es] {Puede traducir esta parte de Greenstone offline usando una planilla de Microsoft Excel:

<ol>
<li>Descargue  <a href="_gwcgi_?a=gti&p=excel&tct=work&e=_compressedoptions_">este archivo</a> para ver todo el trabajo pendiente, o <a href="_gwcgi_?a=gti&p=excel&tct=all&e=_compressedoptions_">este archivo</a> para ver todos los textos de este módulo.
<li>Abra el archivo descargado en Microsoft Excel (Office 2003/XP o versiones más recientes) y guárdelo en formato de Microsoft Excel (.xls).
<li>Ingrese todas las traducciones en los recuadros provistos.
<li>Cuando haya finalizado de traducir todas los textos, envie el archivo .xls a <a href="mailto:_gtiadministratoremail_">_gtiadministratoremail_</a>.
</ol>
}

############
# gli page
############
package gli

_textglilong_ [l=es] {Interfaz de la Biblioteca Digital Greenstone}
_textglihelp_ [l=es] {La Interfaz de Bibliotecario de Greenstone (GLI) le da acceso a la funcionalidad de Greenstone desde una interfaz fácil de usar con la que sólo tiene que apuntar y pulsar. Esto le permite reunir grupos de documentos, importar o asignar metadatos, e incluirlos en una colección de Greeenstone.
<p>

Recuerde que la GLI se ejecuta conjuntamente con Greenstone, por 
lo que se asume que estará instalada en un subdirectorio de su instalación de Greenstone. Si usted ya descargó una de las versiones de Greenstone o la instaló  
desde un CD-ROM, entonces éste será el caso.

<h4>Ejecución de la GLI en Windows</h4>

Ponga en marcha la Interfaz de Bibliotecario en Windows seleccionando <i>Biblioteca Digital Greenstone</i> en el submenú de <i>Programas</i> del menú de <i>Inicio</i> y eligiendo <i>Interfaz de Bibliotecario de Greenstone</i>. 

<h4>Ejecución de la GLI en UNIX</h4>

Para poner en marcha la Interfaz de Bibliotecario en UNIX cambie al directorio <i>gli</i> que se encuentra en su instalación Greenstone y ejecute el script <i>gli.sh</i>.

<h4>Ejecución de la GLI en Mac OS X</h4>

En el Finder, despliegue <i>Aplicaciones</i> y <i>Greenstone</i>
(si instaló Greenstone de la manera preestablecida), y lanze la aplicación <i>GLI</i>.}
