/**********************************************************************
 *
 * browsetools.h --
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef BROWSETOOLSCLASS_H
#define BROWSETOOLSCLASS_H

#include "gsdlconf.h"
#include "text_t.h"
#include "cgiargs.h"
#include "display.h"
#include "recptproto.h"
#include "formattools.h"
#include "browserclass.h"

class browsetoolsclass
{
public:
  
  browsetoolsclass();
  virtual ~browsetoolsclass();

  virtual void output_toc(cgiargsclass &args, browsermapclass *browsermap,
                          formatinfo_t &formatinfo, recptproto *collectproto,
                          displayclass &disp, outconvertclass &outconvert,
                          ostream &textout, ostream &logout);

  virtual text_t get_cover_image();
  virtual text_t get_assocfile_path();
  virtual void load_extended_options(text_tmap &options, cgiargsclass &args, browsermapclass *browsers, 
                                     formatinfo_t &formatinfo, recptproto *collectproto, 
                                     displayclass &disp, outconvertclass &outconvert, ostream &logout);

  virtual void expanded_contents(cgiargsclass &args, int tabcount, bool fulltoc,
                                 browsermapclass *browsermap, formatinfo_t &formatinfo, 
                                 recptproto *collectproto, displayclass &disp, 
                                 outconvertclass &outconvert, ostream &textout, 
                                 ostream &logout, bool expand_from_current_level);

  virtual void expand_show_contents(cgiargsclass &args, int tabcount, bool fulltoc,
                                    browsermapclass *browsermap, formatinfo_t &formatinfo, 
                                    recptproto *collectproto, displayclass &disp, 
                                    outconvertclass &outconvert, ostream &textout, 
                                    ostream &logout);

  virtual void contracted_contents(cgiargsclass &args, int tabcount, bool fulltoc, 
                                   browsermapclass *browsermap, formatinfo_t &formatinfo, 
                                   recptproto *collectproto, displayclass &disp, 
                                   outconvertclass &outconvert, ostream &textout, 
                                   ostream &logout);

protected:

  typedef map<text_t, format_t*, lttext_t> format_tmap; 

  virtual void recurse_contents_levels(text_tarray &parents, cgiargsclass &args, int coloffset,
                                       int tabcount, bool fulltoc, browsermapclass *browsermap,
                                       formatinfo_t &formatinfo, recptproto *collectproto,
                                       displayclass &disp, outconvertclass &outconvert,
                                       ostream &textout, ostream &logout);

  virtual void output_titles(cgiargsclass &args, recptproto *collectproto, 
                             browsermapclass *browsermap, formatinfo_t &formatinfo,
                             displayclass &disp, outconvertclass &outconvert,
                             ostream &textout, ostream &logout);

  virtual void output_controls(cgiargsclass &args, const text_tarray &ibuttons,
                               recptproto *collectproto, displayclass &disp, 
                               outconvertclass &outconvert, ostream &textout, 
                               ostream &logout);
  
  virtual void output_cover_image(cgiargsclass &args, recptproto *collectproto, 
                                  displayclass &disp, outconvertclass &outconvert, 
                                  ostream &textout, ostream &logout);

  virtual void recurse_contents(ResultDocInfo_t &section, cgiargsclass &args, bool fulltoc,
                                browserclass *bptr, text_tset &metadata, bool &getParents, 
                                format_t *formatlistptr, format_tmap &formatlistmap, 
                                formatinfo_t &formatinfo, browsermapclass *browsermap, 
                                int tabcount, recptproto *collectproto, displayclass &disp, 
                                outconvertclass &outconvert, ostream &textout, ostream &logout);

  virtual void load_formatstring(const text_t &classifytype, text_tset &metadata,
                                 bool &getParents, const text_t &classification, 
                                 browsermapclass *browsermap, formatinfo_t &formatinfo,
                                 format_tmap &formatlistmap);

  virtual void load_formatstrings(FilterResponse_t &response, text_tset &metadata,
                                  bool &getParents, const text_t &classification,
                                  browsermapclass *browsermap, formatinfo_t &formatinfo, 
                                  format_tmap &formatlistmap);

  virtual void output_parents(FilterResponse_t &response, cgiargsclass &args, 
                              browsermapclass *browsermap, formatinfo_t &formatinfo, 
                              format_tmap &formatlistmap, const text_t &classification,
                              int &tabcount, text_tset &metadata, bool &getParents,
                              recptproto *collectproto, displayclass &disp, 
                              outconvertclass &outconvert, ostream &textout, 
                              ostream &logout);
};

#endif
