/**********************************************************************
 *
 * maincfg.h -- 
 * Copyright (C) 2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef MAINCFG_H
#define MAINCFG_H


#include "text_t.h"
#include "receptionist.h"


// read main.cfg for the actions and httpprefix
void main_cfg_read (const text_t& collection, const text_t &gsdlhome, text_t &httpprefix, text_tset& actions, text_tset& browsers);

// main_cfg_read reads either collect.cfg or main.cfg and returning 
// true on success. It attempts to read collect.cfg first if a
// collection is specified and then it tries to read in main.cfg
bool main_cfg_read (receptionist &recpt, const text_t &gsdlhome,
		    const text_t& collecthome, const text_t &collection);

bool main_cfg_read (receptionist &recpt, const text_t &gsdlhome,
		    const text_t &collection);


#endif
