/**********************************************************************
 *
 * querytools.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef QUERYTOOLS_H
#define QUERYTOOLS_H

#include "cgiargs.h"
#include "recptproto.h"

void set_query_type_args(ColInfoResponse_t *cinfo, cgiargsclass &args);
void set_stem_index_args(ColInfoResponse_t *cinfo, cgiargsclass &args);

void set_basequeryfilter_options (FilterRequest_t &request, 
				  cgiargsclass &args);

void set_fulltext_queryfilter_options (FilterRequest_t &request, 
				       const text_t &querystring,
				       cgiargsclass &args);

void set_fulltext_queryfilter_options (FilterRequest_t &request, 
				       const text_t &querystring1,
				       const text_t &querystring2, 
				       cgiargsclass &args);

void set_sql_queryfilter_options (FilterRequest_t &request, 
				  cgiargsclass &args);


// don't hassle the function name ... it's been a long day ;)
void set_more_queryfilter_options (FilterRequest_t &request, cgiargsclass &args);

void format_querystring (text_t &querystring, int querymode, bool segment);

void add_dates(text_t &querystring, int startdate, int enddate, 
	       int startbc, int endbc, int ct);

// get a plain version of the query string - terms, separated by space
text_t get_plain_query_terms(const text_t &querystring, const text_t &arg_ct);

// search history tool
text_t escape_quotes(const text_t &querystring);

// some query parsing functions for form processing (only for mgpp/lucene collections)
void parse_reg_query_form(text_t &formattedstring, cgiargsclass &args, bool segment);
void parse_adv_query_form(text_t &formattedstring, cgiargsclass &args, bool segment);

// similar, but for SQL
void parse_sqlreg_query_form(text_t &formattedstring, cgiargsclass &args, bool segment);
void parse_sqladv_query_form(text_t &formattedstring, cgiargsclass &args, bool segment);

// Added for Human Info project
void addqueryelem_ex(text_t &querystring, const text_t &tag, 
		     const text_t &terms, const text_t &stem, 
		     const text_t &fold,
		     const text_t& combine, const text_t& word_combine);

void format_field_info_sql(text_t &querystring, const text_t& tagseq, 
			   const text_t& sqlcomb, int argt, int argb);

void format_field_info(text_t &querystring, text_t tag, int argct, int argt, int argb);

#endif
