/**********************************************************************
 *
 * rssaction.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef USE_RSS

#include "fileutil.h"

#include "rssaction.h"

rssaction::rssaction () {
  // this action uses cgi variable "a"
  cgiarginfo arg_ainfo;
  arg_ainfo.shortname = "a";
  arg_ainfo.longname = "action";
  arg_ainfo.multiplechar = true;
  arg_ainfo.multiplevalue = false;
  arg_ainfo.defaultstatus = cgiarginfo::weak;
  arg_ainfo.argdefault = "rss";
  arg_ainfo.savedarginfo = cgiarginfo::must;

  argsinfo.addarginfo (NULL, arg_ainfo);

}

void rssaction::get_cgihead_info (cgiargsclass &/*args*/, recptprotolistclass * /*protos*/,
				   response_t &response, text_t &response_data, 
				   ostream &/*logout*/) {
  response = content;
  response_data = "application/rdf+xml";
}

void rssaction::generate_rss_header( displayclass &disp, 
				     outconvertclass &outconvert, ostream &textout, 
				     ostream &logout)
{
  textout << outconvert << disp
	  << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
	  << "<rss version=\"2.0\"\n"
	  << "xmlns:content=\"http://purl.org/rss/1.0/modules/content/\"\n"
	  << "  xmlns:taxo=\"http://purl.org/rss/1.0/modules/taxonomy/\"\n"
	  << "  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n"
	  << "  xmlns:syn=\"http://purl.org/rss/1.0/modules/syndication/\"\n"
	  << "  xmlns:admin=\"http://webns.net/mvcb/\">\n"

	  << "<channel>\n"
	  << "  <title>_collectionname_</title>\n"
	  << "  <link>_httpdomainHtmlsafe__httppageabout_</link>\n"
	  << "  <description>_collectionextra_</description>\n"
	  << "  <language>_cgiarglHtmlsafe_</language>\n"
	  << "  <pubDate>Thu, 23 Aug 1999 07:00:00 GMT</pubDate>\n"
	  << "  <lastBuildDate>Thu, 23 Aug 1999 16:20:26 GMT</lastBuildDate>\n"
	  << "  <managingEditor>_creator_</managingEditor>\n"
	  << "  <webMaster>_maintainer_</webMaster>\n"

	  << "<image>\n"
	  << "  <title>_collectionname_</title>\n"
	  << "  <url>_iconcollection_</url>\n"
	  << "  <link>_httpdomainHtmlsafe__httppageabout_</link>\n"
	  << "  <description>_collectionextra_</description>\n"
	  << "</image>\n";
}

void rssaction::generate_rss_content(text_t& rss_items, displayclass &disp, 
				     outconvertclass &outconvert, ostream &textout, 
				     ostream &logout)
{
  textout << outconvert << disp << rss_items;
}

void rssaction::generate_rss_footer( displayclass &disp, 
				     outconvertclass &outconvert, ostream &textout, 
				     ostream &logout)
{

  textout << outconvert << disp
	  << "  </channel>\n"
	  << "</rss>\n";
}


bool rssaction::do_action (cgiargsclass &args, recptprotolistclass *protos, 
			    browsermapclass * /*browsers*/, displayclass& disp, 
			    outconvertclass &outconvert, ostream &textout, 
			    ostream &logout) {
  text_t rss_items;
  bool success = false;
  comerror_t err; 

  text_t &arg_c = args["c"];

  
  // Before resolving the _httpdomain_ macro
  // 1. Check if _httpdomain_ was defined by user in macros (packages rssfeed of rss.dm and Global). 
  // E.g. user could have defined it in package Global of zextra.dm
  // If none found, try to get it from the cgiargs hostname= (set using javascript), 
  // and set as macro for the desired package (e.g. package rss). Setting httpdomain in package Global.
  // If the httpdomain macro needs to be in package rss, then need to mention this macro as 
  // "_rss:httpdomain_" not "_httpdomain_" throughout rss-items.
  // If ever adding a custom macro file like rss.dm that mentions the package, need to list rss.dm in etc/main.cfg

  if(disp.havemacro("Global", "httpdomain") == 0) { // if using rss package, will check rss and Global packages in order. And if not found:
    
    if(!args["hostname"].empty()) {
      disp.setmacro("httpdomain", "Global", "http://" + args["hostname"]);
      disp.setmacro("httpdomainHtmlsafe", "Global", "http://" + encodeForHTML(args["hostname"]));
    } 
    else { // we shouldn't have to get here
      text_t default_domain = "http://localhost:8282";
      disp.setmacro("httpdomain", "Global", default_domain); // the default used in zextra.dm. (Could perhaps default this to localhost too)
      disp.setmacro("httpdomainHtmlsafe", "Global", encodeForHTML(default_domain));
    }
  }


  if (!args["c"].empty()) {
    recptproto* collectproto = protos->getrecptproto (arg_c, logout);    
    if (collectproto != NULL) {
      collectproto->get_rss_items (arg_c, gsdlhome, rss_items, err, logout);
      if (err == noError) success = true; 
      // else a communication error    
    }
  }

  generate_rss_header(disp,outconvert,textout,logout);
  if(success) {
    generate_rss_content(rss_items,disp,outconvert,textout,logout);
  }
  generate_rss_footer(disp,outconvert,textout,logout);

  return success;
};

#endif //USE_RSS
