/**********************************************************************
 *
 * getpw.cpp -- 
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the 
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2000  The New Zealand Digital Library Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/

#define _XOPEN_SOURCE 1
// This was added for Solaris, but it makes things worse on Solaris for me...
// #define _XOPEN_SOURCE_EXTENDED 1

// Windows version seems to be sensitive to the order of <iostream> and <crypt.h>
// having <iostream> *after* <crypt.h> lead to linking error such as:
//    __freea already defined in getpw.obj
// which seems to be caused by compiler confusion of whether it should be using
// /MD or /MT (which control dynamic or static/multi-threaded linking)

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#  include <iostream.h>
#else
#  include <iostream>
#endif

// use the standard namespace
#if !defined (GSDL_NAMESPACE_BROKEN)
#  if defined(GSDL_USE_OBJECTSPACE)
using namespace ospace::std;
#  else
using namespace std;
#  endif
#endif

#include "gsdlconf.h"

// include crypt
#if defined(_MSC_VER)
#  include <windows.h>
#  include <stdio.h>
#  include <crypt.h>
#else
#  include "config.h"
#  include <getpass.h>
#  include <crypt.h>


#  if defined(HAVE_UNISTD_H)
#  include <unistd.h>
#  endif
/* we are probably in trouble if we have neither crypt.h or unistd.h,
   but for now we'll do nothing about it... */

#endif  /* not _MSC_VER */

#include <string.h>
//#include <pwd.h>

#if defined(_MSC_VER)
char* getPassword(HANDLE hSTDIN)
{
	char a[129];
	int charCount = 0;
	DWORD cNumRead;
	INPUT_RECORD irIn[128];
	
	bool done = false;
	while (!done)
	{
		if (!ReadConsoleInput(hSTDIN, irIn, 128, &cNumRead))
		{
			cerr << "There was an error reading input from the console\n";
			return strdup("");
		}
		
		for(int j = 0; j < cNumRead; j++)
		{
			if(irIn[j].EventType == KEY_EVENT)
			{
				KEY_EVENT_RECORD keyEvent = irIn[j].Event.KeyEvent;
				if(keyEvent.bKeyDown == false)
				{
					if(keyEvent.wVirtualKeyCode == VK_RETURN)
					{
						done = true;
						cout << "\n";
					}
					else
					{
						if(charCount < 129)
						{
							a[charCount++] = keyEvent.uChar.AsciiChar;
						}
					}
				}
			}
		}
	}
	a[charCount] = '\0';
	return strdup(a);
}
#endif


#if defined(__ANDROID__)

// See:
//  http://stackoverflow.com/questions/1196418/getting-a-password-in-c-without-using-getpass-3

#include <stdio.h>
#include <stdlib.h>
#include <termios.h>

char* getpass(const char* prompt)
{
    struct termios oflags, nflags;
    char* password = (char*)malloc(64);

    /* disabling echo */
    tcgetattr(fileno(stdin), &oflags);
    nflags = oflags;
    nflags.c_lflag &= ~ECHO;
    nflags.c_lflag |= ECHONL;

    if (tcsetattr(fileno(stdin), TCSANOW, &nflags) != 0) {
        perror("tcsetattr");
        return NULL;
    }

    printf(prompt);
    fgets(password, sizeof(password), stdin);
    password[strlen(password) - 1] = 0;

    /* restore terminal */
    if (tcsetattr(fileno(stdin), TCSANOW, &oflags) != 0) {
        perror("tcsetattr");
        return NULL;
    }

    return password;
}
#endif




int main (int argc, char *argv[]) {

  int password_ok = 0;
  char c[129];
  int i;
  
  for (i=0; i<3; i++)  {
#if defined(_MSC_VER)
    HANDLE hSTDIN;
	DWORD fdwMode, fdwPrevMode;
	int counter=0;
	
	hSTDIN = GetStdHandle(STD_INPUT_HANDLE);
	if (hSTDIN == INVALID_HANDLE_VALUE)
	{
		cerr << "There was an error getting a handle to the standard input\n";
		return 1;
	}
	
	if (!GetConsoleMode(hSTDIN, &fdwPrevMode))
	{
		cerr << "There was an error getting a handle to the current console mode\n";
		return 2;
	}
	
	fdwMode = NULL;
	if (!SetConsoleMode(hSTDIN, fdwMode))
	{
		cerr << "There was an error setting the new handle mode\n";
		return 3;
	}
	
	cerr << "Enter password:";
	char* a = getPassword(hSTDIN);
#else
    char* a = getpass("Enter password:");
#endif
    int len = strlen (a);
    if (len < 3 || len > 128) {
      cerr << "Password must be between 3 and 128 characters long. Try again\n";
      continue;
    }

    strcpy (c, a);
	
#if defined(_MSC_VER)
    cerr << "Re-enter password: ";
    char* b = getPassword(hSTDIN);
#else
    char* b = getpass("Re-enter password:");  
#endif
    if ((strcmp (c, b)) == 0) {
      password_ok = 1;
      break;
    }
    else {
      cerr << "Passwords didn't match. Try again.\n";
    }
  }

  if (!password_ok) {
    cerr << "Failed to capture password." << endl;
    return -1;
  }
  
  char *salt = "Tp";
  char *pw = crypt (c, salt);

  cout << pw << "\n";

  return 0;
}
