/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.shell;

/**
 * Title:        The Gatherer<br>
 * Description:  The Gatherer: a tool for gathering and enriching digital collections.<br>
 * Copyright:    Copyright (c) 2001<br>
 * Company:      The University of Waikato<br>
 * Written:        /  /01<br>
 * Revised:      12/05/02 - Commented<br>
 *               29/05/02 - Moved into correct package<br>
 * @author John Thompson, Greenstone Digital Libraries
 * @version 2.1
 */
import java.awt.Component;
import java.util.ArrayList;
import org.greenstone.gatherer.gui.GProgressBar;

/** When implemented, this interface allows another class to monitor the progress of a <strong>GShell</strong> process. Specifically implementing classes should be designed to take the textual output from the process and then translate that message into some quanitive measure of progress which can then be shown on the progress bar.
 */
public interface GShellProgressMonitor {
    /** Method to register a new progress bar with this monitor.
     * @param progress_bar The new <strong>GProgressBar</strong>.
     */
    public void addProgressBar(GProgressBar progress_bar);

    /** Determine the script exit value according to the progress monitor. This gets around a problem where several script failures actually result with a successful exit value.
     * @return A <i>int</i> with a value of zero if and only if the script was successful.
     */
    public int exitValue();

    public GProgressBar getSharedProgress();

    /** Method to retrieve whatever control is being used as the progress indicator. Usually a <strong>GProgressBar</strong> but there may be others implemented later.
     * @return A <strong>Component</strong> on which the progress of the process is being displayed.
     */
    public Component getProgress();

    public void messageOnProgressBar(String message);

    /** Method to determine the state of the stop flag, which may be set by the visual component that created this monitor.
     * @return A <strong>boolean</strong> indicating if the process has been asked to stop.
     */
    public boolean hasSignalledStop();

    /** Inform the progress bar that it should programatically increment progress by one step. */
    public void increment();

    /** This method is used to 'feed in' a line of text captured from the process.
     * @param queue what will be used as a queue of events, but what, at the moment, should only have one event in it
     */
    public void process(ArrayList queue);

    public void reset();

    public void saving();

    /** Since the creator of this process monitor is actually in the GUI, this class provides the simpliest way to send a cancel process message between the two.
     * @param state The desired state of the stop flag as a <strong>boolean</strong>.
     */
    public void setStop(boolean state);

    /** This method resets this monitor to the start, reseting the process parsing and progress bar.
     */
    public void start();

    /** This method indicates the process is complete. 
     */
    public void stop();
}
