# this file must be UTF-8 encoded
#####################################################################
#
# English Language text and icon macros 
#
######################################################################
#
# This is the main macro file for translation when creating an 
# interface in another language.

# Under the 'text macros' comments are text macros of the form:
# _macroname_ {macro value}
# Everything between the {} is the text to be translated. This text 
# may itself contain macros (i.e. characters other than space between
# underscore characters, e.g. _about:numdocs_ or _textpage_). These
# macro names occurring within text shouldn't be translated but should
# be left as they are. Underscores or curly brackets occurring 
# naturally within the text should be escaped with a leading backslash
# (i.e. '\_', '\{' or '\}).
#
# Comment lines (other than those described above) need not be 
# translated (i.e. any lines beginning with '#', like this line).
#
# The simplest way to translate this file is to save it as something
# else (e.g. french.dm) and work through translating all the text
# macro values and icon comments.
#
######################################################################


######################################################################
# Global (base) package
package Global
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# -- Missing translation: _textperiodicals_

# these three used by the default format statement of the demo and dls collections.
# -- Missing translation: _textsource_
# -- Missing translation: _textdate_
# -- Missing translation: _textnumpages_

# -- Missing translation: _textsignin_

# -- Missing translation: _texttruncated_

# -- Missing translation: _textdefaultcontent_

# -- Missing translation: _textdefaulttitle_

# -- Missing translation: _textbadcollection_

# -- Missing translation: _textselectpage_

# -- Missing translation: _collectionextra_

# this is only used by the collector (where the above _collectionextra_
# macro will always be set to another value)
# -- Missing translation: _collectorextra_

_textdescrcollection_ [l=km] {}
# -- Missing translation: _textdescrabout_
# -- Missing translation: _textdescrhome_
# -- Missing translation: _textdescrhelp_
# -- Missing translation: _textdescrpref_
# -- Missing translation: _textdescrdeposit_
# -- Missing translation: _textdescrlogin_
# -- Missing translation: _textdescrlogout_

# -- Missing translation: _textdescrgreenstone_
# -- Missing translation: _textdescrusab_


# Metadata names and navigation bar labels

# -- Missing translation: _textSearch_
# -- Missing translation: _labelSearch_

# Dublin Core Metadata Element Set, Version 1.1
# -- Missing translation: _textTitle_
# -- Missing translation: _labelTitle_
# -- Missing translation: _textCreator_
# -- Missing translation: _labelCreator_
# -- Missing translation: _textSubject_
# -- Missing translation: _labelSubject_
# -- Missing translation: _textDescription_
# -- Missing translation: _labelDescription_
# -- Missing translation: _textPublisher_
# -- Missing translation: _labelPublisher_
# -- Missing translation: _textContributor_
# -- Missing translation: _labelContributor_
# -- Missing translation: _textDate_
# -- Missing translation: _labelDate_
# -- Missing translation: _textType_
# -- Missing translation: _labelType_
# -- Missing translation: _textFormat_
# -- Missing translation: _labelFormat_
# -- Missing translation: _textIdentifier_
# -- Missing translation: _labelIdentifier_
# -- Missing translation: _textSource_
# -- Missing translation: _labelSource_
# -- Missing translation: _textLanguage_
# -- Missing translation: _labelLanguage_
# -- Missing translation: _textRelation_
# -- Missing translation: _labelRelation_
# -- Missing translation: _textCoverage_
# -- Missing translation: _labelCoverage_
# -- Missing translation: _textRights_
# -- Missing translation: _labelRights_

# DLS metadata set
# -- Missing translation: _textOrganization_
# -- Missing translation: _labelOrganization_
# -- Missing translation: _textKeyword_
# -- Missing translation: _labelKeyword_
# -- Missing translation: _textHowto_
# -- Missing translation: _labelHowto_

# Miscellaneous Greenstone metadata
# -- Missing translation: _textPhrase_
# -- Missing translation: _labelPhrase_
# -- Missing translation: _textCollage_
# -- Missing translation: _labelCollage_
# -- Missing translation: _textBrowse_
# -- Missing translation: _labelBrowse_
# -- Missing translation: _textTo_
# -- Missing translation: _labelTo_
# -- Missing translation: _textFrom_
# -- Missing translation: _labelFrom_
# -- Missing translation: _textAcronym_
# -- Missing translation: _labelAcronym_
# -- Missing translation: _textAuthor_
# -- Missing translation: _textAuthors_

# Navigation bar tooltip - to customize this for a specific metadata, add a macro named _textdescrXXX_ where XXX is the metadata name
# -- Missing translation: _textdescrdefault_

# -- Missing translation: _textdescrSearch_
# -- Missing translation: _textdescrType_
# -- Missing translation: _textdescrIdentifier_
# -- Missing translation: _textdescrSource_
# -- Missing translation: _textdescrTo_
# -- Missing translation: _textdescrFrom_
# -- Missing translation: _textdescrCollage_
# -- Missing translation: _textdescrAcronym_
# -- Missing translation: _textdescrPhrase_
# -- Missing translation: _textdescrHowto_
# -- Missing translation: _textdescrBrowse_
# -- Missing translation: _texticontext_
# -- Missing translation: _texticonclosedbook_
# -- Missing translation: _texticonnext_
# -- Missing translation: _texticonprev_

# -- Missing translation: _texticonworld_

# -- Missing translation: _texticonmidi_
# -- Missing translation: _texticonmsword_
# -- Missing translation: _texticonmp3_
# -- Missing translation: _texticonpdf_
# -- Missing translation: _texticonps_
# -- Missing translation: _texticonppt_
# -- Missing translation: _texticonrtf_
# -- Missing translation: _texticonxls_
# -- Missing translation: _texticonogg_
# -- Missing translation: _texticonrmvideo_

# -- Missing translation: _page_
# -- Missing translation: _pages_
# -- Missing translation: _of_
# -- Missing translation: _vol_
# -- Missing translation: _num_

_textmonth00_ [l=km] {}
# -- Missing translation: _textmonth01_
# -- Missing translation: _textmonth02_
# -- Missing translation: _textmonth03_
# -- Missing translation: _textmonth04_
# -- Missing translation: _textmonth05_
# -- Missing translation: _textmonth06_
# -- Missing translation: _textmonth07_
# -- Missing translation: _textmonth08_
# -- Missing translation: _textmonth09_
# -- Missing translation: _textmonth10_
# -- Missing translation: _textmonth11_
# -- Missing translation: _textmonth12_

# -- Missing translation: _texttext_
# -- Missing translation: _labeltext_
# -- Missing translation: _textdocument_
# -- Missing translation: _textsection_
# -- Missing translation: _textparagraph_
# -- Missing translation: _textchapter_
# -- Missing translation: _textbook_

# -- Missing translation: _magazines_

# -- Missing translation: _nzdlpagefooter_

# -- Missing translation: _linktextHOME_
# -- Missing translation: _linktextHELP_
# -- Missing translation: _linktextPREFERENCES_
# -- Missing translation: _linktextDEPOSIT_
# -- Missing translation: _linktextLOGIN_
# -- Missing translation: _linktextLOGGEDIN_
# -- Missing translation: _linktextLOGOUT_


######################################################################
# 'home' page
package home
######################################################################

# -- Missing translation: _textpagetitle_

# -- Missing translation: _textnocollections_

# -- Missing translation: _textadmin_
# -- Missing translation: _textabgs_

# -- Missing translation: _textdescradmin_

# -- Missing translation: _textdescrgogreenstone_


#####################################################################
# some macros used on the home page from other packages
#####################################################################
package gli

# -- Missing translation: _textgli_
# -- Missing translation: _textdescrgli_

package collector

# -- Missing translation: _textcollector_
# -- Missing translation: _textdescrcollector_

package depositor

# -- Missing translation: _textdepositor_
# -- Missing translation: _textdescrdepositor_

# -- Missing translation: _textdepositorlocal_
package gti

# -- Missing translation: _textgti_
# -- Missing translation: _textdescrtranslator_


######################################################################
# 'about' page
package about
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# -- Missing translation: _textabcol_

# -- Missing translation: _textsubcols1_

# -- Missing translation: _textsubcols2_

# -- Missing translation: _titleabout_


######################################################################
# document package
package document
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# -- Missing translation: _texticonopenbookshelf_
# -- Missing translation: _texticonclosedbookshelf_
# -- Missing translation: _texticonopenbook_
# -- Missing translation: _texticonclosedfolder_
# -- Missing translation: _texticonclosedfolder2_
# -- Missing translation: _texticonopenfolder_
# -- Missing translation: _texticonopenfolder2_
# -- Missing translation: _texticonsmalltext_
# -- Missing translation: _texticonsmalltext2_
# -- Missing translation: _texticonpointer_
# -- Missing translation: _texticondetach_
# -- Missing translation: _texticonhighlight_
# -- Missing translation: _texticonnohighlight_
# -- Missing translation: _texticoncontracttoc_
# -- Missing translation: _texticonexpandtoc_
# -- Missing translation: _texticonexpandtext_
# -- Missing translation: _texticoncontracttext_
# -- Missing translation: _texticonwarning_
# -- Missing translation: _texticoncont_

# -- Missing translation: _textltwarning_

# -- Missing translation: _textcommentusername_
# -- Missing translation: _textaddusercomment_
# -- Missing translation: _textusercommentlogout_
# -- Missing translation: _textaddcomment_
# -- Missing translation: _textcommentsubmitted_
# -- Missing translation: _textisempty_
# -- Missing translation: _textusercommentssection_

# -- Missing translation: _textgoto_
# -- Missing translation: _textintro_

# -- Missing translation: _textCONTINUE_

# -- Missing translation: _textEXPANDTEXT_

# -- Missing translation: _textCONTRACTCONTENTS_

# -- Missing translation: _textDETACH_

# -- Missing translation: _textEXPANDCONTENTS_

# -- Missing translation: _textCONTRACT_

# -- Missing translation: _textHIGHLIGHT_

# -- Missing translation: _textNOHIGHLIGHT_

# -- Missing translation: _textPRINT_

# -- Missing translation: _textnextsearchresult_
# -- Missing translation: _textprevsearchresult_

# macros for printing page
# -- Missing translation: _textreturnoriginal_
# -- Missing translation: _textprintpage_
# -- Missing translation: _textshowcontents_
# -- Missing translation: _texthidecontents_

######################################################################
# 'search' page
package query
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# this if statement produces the text 'results n1 - nn for query: querystring' or 
# 'No matches for query: querystring', depending on whether or not there were
# any matches
# -- Missing translation: _textquerytitle_
# -- Missing translation: _textnoquerytitle_

# -- Missing translation: _textsome_
# -- Missing translation: _textall_
# -- Missing translation: _textboolean_
# -- Missing translation: _textranked_
# -- Missing translation: _textnatural_
# -- Missing translation: _textsortbyrank_
# -- Missing translation: _textsortbynone_
# -- Missing translation: _textascending_
# -- Missing translation: _textdescending_
# -- Missing translation: _texticonsearchhistorybar_

# -- Missing translation: _textifeellucky_

#alt text for query buttons
# -- Missing translation: _textusequery_
# -- Missing translation: _textfreqmsg1_
# -- Missing translation: _textpostprocess_
# -- Missing translation: _textinvalidquery_
# -- Missing translation: _textstopwordsmsg_
# -- Missing translation: _textlucenetoomanyclauses_

# -- Missing translation: _textmorethan_
# -- Missing translation: _textapprox_
# -- Missing translation: _textnodocs_
# -- Missing translation: _text1doc_
# -- Missing translation: _textlotsdocs_
# -- Missing translation: _textmatches_
# -- Missing translation: _textbeginsearch_
# -- Missing translation: _textrunquery_
# -- Missing translation: _textclearform_

#these go together in form search:
#"Words  fold case fold accents stem  ... in field"
# -- Missing translation: _textwordphrase_
# -- Missing translation: _textinfield_
# -- Missing translation: _textformcasefold_
# -- Missing translation: _textformaccentfold_
# -- Missing translation: _textformstem_

# -- Missing translation: _textadvquery_
# -- Missing translation: _textallfields_
# -- Missing translation: _texttextonly_
# -- Missing translation: _textand_
# -- Missing translation: _textor_
# -- Missing translation: _textandnot_

# _indexselection_, _jselection_, _nselection_ and _gselection_ are set from 
# within the server - _indexselection_ is always set, but the others may be 
# unset

# the space after "level" (before the right bracket) is required, otherwise no space between "Search" and "in"

# -- Missing translation: _textsimplesearch_
# -- Missing translation: _textsimplesqlsearch_

# -- Missing translation: _textadvancedsearch_

# -- Missing translation: _textadvancedmgppsearch_

# -- Missing translation: _textadvancedlucenesearch_
# -- Missing translation: _textadvancedsqlsearch_

# the space after "Search" is required, otherwise no space between "Search" and "in"

# -- Missing translation: _textformsimplesearch_
# -- Missing translation: _textformsimplesearchsql_

# -- Missing translation: _textformadvancedsearchmgpp_

# -- Missing translation: _textformadvancedsearchlucene_
# -- Missing translation: _textformadvancedsearchsql_

# -- Missing translation: _textnojsformwarning_
# -- Missing translation: _textdatesearch_
# -- Missing translation: _textstartdate_
# -- Missing translation: _textenddate_
# -- Missing translation: _textbc_
# -- Missing translation: _textad_
# -- Missing translation: _textexplaineras_

# -- Missing translation: _textstemon_

# -- Missing translation: _textsearchhistory_

#text macros for search history
# -- Missing translation: _textnohistory_
# -- Missing translation: _texthresult_
# -- Missing translation: _texthresults_
# -- Missing translation: _texthallwords_
# -- Missing translation: _texthsomewords_
# -- Missing translation: _texthboolean_
# -- Missing translation: _texthranked_
# -- Missing translation: _texthcaseon_
# -- Missing translation: _texthcaseoff_
# -- Missing translation: _texthstemon_
# -- Missing translation: _texthstemoff_


######################################################################
# 'preferences' page
package preferences
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# -- Missing translation: _textprefschanged_
# -- Missing translation: _textsetprefs_
# -- Missing translation: _textsearchprefs_
# -- Missing translation: _textcollectionprefs_
# -- Missing translation: _textpresentationprefs_
# -- Missing translation: _textpreferences_
# -- Missing translation: _textcasediffs_
# -- Missing translation: _textignorecase_
# -- Missing translation: _textmatchcase_
# -- Missing translation: _textwordends_
# -- Missing translation: _textstem_
# -- Missing translation: _textnostem_
# -- Missing translation: _textaccentdiffs_
# -- Missing translation: _textignoreaccents_
# -- Missing translation: _textmatchaccents_

# -- Missing translation: _textprefop_
# -- Missing translation: _textextlink_
# -- Missing translation: _textintlink_
# -- Missing translation: _textlanguage_
# -- Missing translation: _textencoding_
# -- Missing translation: _textformat_
# -- Missing translation: _textall_
# -- Missing translation: _textquerymode_
# -- Missing translation: _textsimplemode_
# -- Missing translation: _textadvancedmode_
# -- Missing translation: _textlinkinterm_
# -- Missing translation: _textlinkdirect_
# -- Missing translation: _textdigitlib_
# -- Missing translation: _textweb_
# -- Missing translation: _textgraphical_
# -- Missing translation: _texttextual_
# -- Missing translation: _textcollectionoption_

# -- Missing translation: _textsearchtype_
# -- Missing translation: _textformsearchtype_
# -- Missing translation: _textsqlformsearchtype_
# -- Missing translation: _textplainsearchtype_
# -- Missing translation: _textregularbox_
# -- Missing translation: _textlargebox_

# -- Missing translation: _textrelateddocdisplay_
# -- Missing translation: _textsearchhistory_
# -- Missing translation: _textnohistory_
# -- Missing translation: _texthistorydisplay_
# -- Missing translation: _textnohistorydisplay_

# -- Missing translation: _textbookoption_
# -- Missing translation: _textbookvieweron_
# -- Missing translation: _textbookvieweroff_

# html options
# -- Missing translation: _textdoclayout_
# -- Missing translation: _textlayoutnavbar_
# -- Missing translation: _textlayoutnonavbar_

# -- Missing translation: _texttermhighlight_
# -- Missing translation: _texttermhighlighton_
# -- Missing translation: _texttermhighlightoff_

#####################################################################
# 'browse' package for the dynamic browsing interface
package browse
#####################################################################

# -- Missing translation: _textsortby_
# -- Missing translation: _textalsoshowing_
# -- Missing translation: _textwith_
# -- Missing translation: _textdocsperpage_

# -- Missing translation: _textfilterby_
# -- Missing translation: _textall_
# -- Missing translation: _textany_
# -- Missing translation: _textwords_
# -- Missing translation: _textleaveblank_

# -- Missing translation: _browsebuttontext_

# -- Missing translation: _nodata_
# -- Missing translation: _docs_
######################################################################
# 'help' page -- this is lower priority for translating than the
# rest of this file
package help
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

# -- Missing translation: _textHelp_

# Macros giving a brief help message for navigation bar access buttons
# The arguments to this will be _textXXX_ and _labelXXX_, where XXX is the metadata name. For example, to print out the help message for a titles classifier, the library will use _textdefaulthelp_(_textTitle_,_labelTitle_)
# To customize this for a specific metadata, add a macro named _textXXXhelp_ where XXX is the metadata name
# -- Missing translation: _textdefaulthelp_

# -- Missing translation: _textSearchhelp_
# -- Missing translation: _textTohelp_
# -- Missing translation: _textFromhelp_
# -- Missing translation: _textBrowsehelp_
# -- Missing translation: _textAcronymhelp_
# -- Missing translation: _textPhrasehelp_

# -- Missing translation: _texthelptopicstitle_

# -- Missing translation: _textreadingdocs_

# -- Missing translation: _texthelpreadingdocs_

# help about the icons
# -- Missing translation: _texthelpopenbookshelf_
# -- Missing translation: _texthelpopenbook_
# -- Missing translation: _texthelpviewtextsection_
# -- Missing translation: _texthelpexpandtext_
# -- Missing translation: _texthelpexpandcontents_
# -- Missing translation: _texthelpdetachpage_
# -- Missing translation: _texthelphighlight_
# -- Missing translation: _texthelpsectionarrows_


# -- Missing translation: _texthelpsearchingtitle_

# -- Missing translation: _texthelpsearching_

# -- Missing translation: _texthelpquerytermstitle_
# -- Missing translation: _texthelpqueryterms_

# -- Missing translation: _texthelpmgppsearching_

# -- Missing translation: _texthelplucenesearching_

# -- Missing translation: _texthelpquerytypetitle_
# -- Missing translation: _texthelpquerytype_

# -- Missing translation: _texthelpadvancedsearchtitle_

# -- Missing translation: _texthelpadvancedsearch_

# -- Missing translation: _texthelpadvsearchmg_

# -- Missing translation: _texthelpbooleansearch_

# -- Missing translation: _texthelpadvsearchmgpp_

# -- Missing translation: _texthelpadvancedsearchextra_

# -- Missing translation: _texthelpadvsearchlucene_

# -- Missing translation: _texthelpformsearchtitle_

# -- Missing translation: _texthelpformsearch_

# -- Missing translation: _texthelpformstemming_

# -- Missing translation: _textdatesearch_

# -- Missing translation: _texthelpdatesearch_

# -- Missing translation: _texthelpdatehowtotitle_
# -- Missing translation: _texthelpdatehowto_

# -- Missing translation: _texthelpdateresultstitle_
# -- Missing translation: _texthelpdateresults_

# -- Missing translation: _textchangeprefs_

# -- Missing translation: _texthelppreferences_

# -- Missing translation: _texthelpcollectionprefstitle_
# -- Missing translation: _texthelpcollectionprefs_

# -- Missing translation: _texthelplanguageprefstitle_
# -- Missing translation: _texthelplanguageprefs_

# -- Missing translation: _texthelppresentationprefstitle_
# -- Missing translation: _texthelppresentationprefs_

# -- Missing translation: _texthelpsearchprefstitle_
# -- Missing translation: _texthelpsearchprefs_

# -- Missing translation: _textcasefoldprefs_
# -- Missing translation: _textstemprefs_
# -- Missing translation: _textaccentfoldprefs_
 
# -- Missing translation: _textstemoptionsprefs_

# -- Missing translation: _textsearchtypeprefsplain_

# -- Missing translation: _textsearchtypeprefsform_

# -- Missing translation: _textsearchtypeprefsboth_



# -- Missing translation: _texttanumbrowseoptions_

# -- Missing translation: _textsimplehelpheading_

# -- Missing translation: _texthelpscopetitle_
# -- Missing translation: _texthelpscope_
