/**********************************************************************
 *
 * sqlfilter.cpp -- 
 * Copyright (C) 2008  DL Consulting Ltd
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "fileutil.h"
#include "colservertools.h"
#include "sqlfilter.h"


sqlfilterclass::sqlfilterclass ()
 : filterclass()
{}


sqlfilterclass::~sqlfilterclass ()
{}


void sqlfilterclass::configure (const text_t &key, const text_tarray &cfgline)
{
  filterclass::configure (key, cfgline);

  if (key == "indexstem")
  {
    indexstem = cfgline[0];
  }
}

bool sqlfilterclass::init (ostream &logout)
{
  outconvertclass text_t2ascii;

  if (!filterclass::init(logout)) return false;

  if (sql_db_ptr == NULL)
  {
    // most likely a configuration problem
    logout << text_t2ascii << "configuration error: sqlfilter contains a null sqldbclass\n\n";
    return false;
  }

  if (indexstem.empty())
  {
    indexstem = collection;
  }

  // get the filename for the database and make sure it exists
  sql_db_filename = resolve_db_filename(gsdlhome, dbhome, collecthome, collection,
					indexstem,sql_db_ptr->getfileextension());
  if (!file_exists(sql_db_filename))
  {
    logout << text_t2ascii << "warning: database \"" << sql_db_filename << "\" does not exist\n\n";
    return false;
  }

  return true;
}


bool sqlfilterclass::connect_to_sqldb (FilterResponse_t &response,
				       comerror_t &err, ostream &logout)
{
  outconvertclass text_t2ascii;

  response.clear();
  err = noError;
  
  if (sql_db_ptr == NULL) {
    // most likely a configuration problem
    logout << text_t2ascii << "configuration error: sqlbrowsefilter contains a null sqldbclass\n\n";
    err = configurationError;
    return false;
  }
  
  // open the database
  sql_db_ptr->setlogout (&logout);
  if (!sql_db_ptr->opendatabase (sql_db_filename, DB_READER, 100, false)) {
    // most likely a system problem (we have already checked that the database exists)
    logout << text_t2ascii << "system problem: open on database \"" << sql_db_filename << "\" failed\n\n";
    err = systemProblem;
    return false;
  }
  
  return true;
}


void sqlfilterclass::disconnect_from_sqldb ()
{
  sql_db_ptr->closedatabase();  // Important that local library doesn't leave any files open
}
