/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.ElectionAgentThread;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Learner
extends ElectionAgentThread {
    private final ServiceDispatcher serviceDispatcher;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private Proposer.Proposal currentProposal = null;
    private Protocol.Value currentValue = null;
    public static final String SERVICE_NAME = "Learner";

    public Learner(Protocol protocol, ServiceDispatcher serviceDispatcher, NameIdPair nameIdPair) throws IOException {
        this(null, protocol, serviceDispatcher, nameIdPair);
    }

    public Learner(Protocol protocol, RepNode repNode) {
        this(repNode, protocol, repNode.getServiceDispatcher(), repNode.getNameIdPair());
    }

    private Learner(RepNode repNode, Protocol protocol, ServiceDispatcher serviceDispatcher, NameIdPair nameIdPair) {
        super(repNode, protocol, nameIdPair, "Learner Thread " + nameIdPair.getName());
        this.serviceDispatcher = serviceDispatcher;
        this.addListener(new Listener(){

            public void notify(Proposer.Proposal proposal, Protocol.Value value) {
                LoggerUtils.logMsg(Learner.this.logger, Learner.this.envImpl, Learner.this.formatter, Level.FINE, "Learner notified. Proposal:" + proposal + " Value: " + value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResult(Proposer.Proposal proposal, Protocol.Value value) {
        if (this.currentProposal != null && proposal.compareTo(this.currentProposal) < 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Ignoring obsolete winner: " + proposal);
            return;
        }
        this.currentProposal = proposal;
        this.currentValue = value;
        List<Listener> list = this.listeners;
        synchronized (list) {
            for (Listener listener : this.listeners) {
                try {
                    listener.notify(this.currentProposal, this.currentValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Exception in Learner Listener: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.serviceDispatcher.register(SERVICE_NAME, this.channelQueue);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Learner started");
        SocketChannel channel = null;
        try {
            try {
                Object var11_13;
                PrintWriter out;
                BufferedReader in;
                Socket socket;
                while (true) {
                    block21: {
                        block20: {
                            if ((channel = this.serviceDispatcher.takeChannel(SERVICE_NAME, true, this.protocol.getReadTimeout())) == null) {
                                Object var13_14 = null;
                                this.serviceDispatcher.cancel(SERVICE_NAME);
                                this.cleanup();
                                return;
                            }
                            socket = channel.socket();
                            in = null;
                            out = null;
                            try {
                                try {
                                    TextProtocol.RequestMessage requestMessage;
                                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                    String requestLine = in.readLine();
                                    if (requestLine == null) {
                                        var11_13 = null;
                                        break block20;
                                    }
                                    try {
                                        requestMessage = this.protocol.parseRequest(requestLine);
                                    }
                                    catch (TextProtocol.InvalidMessageException e) {
                                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Message format exception: " + e.getMessage());
                                        out = new PrintWriter(socket.getOutputStream(), true);
                                        Protocol protocol = this.protocol;
                                        protocol.getClass();
                                        out.println(new TextProtocol.ProtocolError(protocol, e).wireFormat());
                                        var11_13 = null;
                                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                        continue;
                                    }
                                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINEST, "learner request: " + requestMessage.getOp() + " sender: " + requestMessage.getSenderId());
                                    if (requestMessage.getOp() == this.protocol.RESULT) {
                                        Protocol.Result result = (Protocol.Result)requestMessage;
                                        this.processResult(result.getProposal(), result.getValue());
                                        break block21;
                                    }
                                    if (requestMessage.getOp() == this.protocol.MASTER_QUERY) {
                                        Learner learner = this;
                                        synchronized (learner) {
                                            if (this.currentProposal != null && this.currentValue != null) {
                                                out = new PrintWriter(socket.getOutputStream(), true);
                                                Protocol protocol = this.protocol;
                                                protocol.getClass();
                                                Protocol.MasterQueryResponse responseMessage = new Protocol.MasterQueryResponse(protocol, this.currentProposal, this.currentValue);
                                                responseMessage.setSendVersion(requestMessage.getSendVersion());
                                                out.println(responseMessage.wireFormat());
                                            }
                                            break block21;
                                        }
                                    }
                                    if (requestMessage.getOp() != this.protocol.SHUTDOWN) throw EnvironmentFailureException.unexpectedState("Unrecognized request: " + requestLine);
                                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Learner thread exiting");
                                    break;
                                }
                                catch (IOException e) {
                                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "IO exception: " + e.getMessage());
                                    var11_13 = null;
                                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                    continue;
                                }
                                catch (Exception e) {
                                    throw EnvironmentFailureException.unexpectedException(e);
                                }
                            }
                            catch (Throwable throwable) {
                                var11_13 = null;
                                Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                                throw throwable;
                            }
                        }
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                        continue;
                    }
                    var11_13 = null;
                    Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                }
                var11_13 = null;
                Utils.cleanup(this.logger, this.envImpl, this.formatter, socket, in, out);
                Object var13_15 = null;
                this.serviceDispatcher.cancel(SERVICE_NAME);
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    Object var13_16 = null;
                    this.serviceDispatcher.cancel(SERVICE_NAME);
                    this.cleanup();
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Learner unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            this.cleanup();
            return;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            this.serviceDispatcher.cancel(SERVICE_NAME);
            this.cleanup();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryForMaster(Set<InetSocketAddress> learnerSockets) {
        int threadPoolSize = Math.max(learnerSockets.size(), 10);
        ExecutorService pool = Executors.newFixedThreadPool(threadPoolSize, new StoppableThreadFactory("JE Learner", this.logger));
        try {
            Protocol.MasterQuery masterQuery = new Protocol.MasterQuery(this.protocol);
            List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(learnerSockets, SERVICE_NAME, masterQuery, pool);
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Sent master request " + masterQuery + " to " + learnerSockets);
            for (final Future<TextProtocol.MessageExchange> f : futures) {
                new Utils.WithFutureExceptionHandler(){

                    protected void processFuture() throws ExecutionException, InterruptedException {
                        TextProtocol.MessageExchange me = (TextProtocol.MessageExchange)f.get();
                        if (me.getResponseMessage() == null) {
                            return;
                        }
                        if (me.getResponseMessage().getOp() == Learner.this.protocol.MASTER_QUERY_RESPONSE) {
                            Protocol.MasterQueryResponse accept = (Protocol.MasterQueryResponse)me.getResponseMessage();
                            Learner.this.processResult(accept.getProposal(), accept.getValue());
                        }
                    }
                }.execute(this.logger, this.envImpl, this.formatter);
            }
            Object var9_8 = null;
            pool.shutdown();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            pool.shutdown();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MasterValue findMaster(final Protocol protocol, Set<InetSocketAddress> learnerSockets, final Logger logger, final RepImpl repImpl, final Formatter formatter) throws UnknownMasterException {
        int threadPoolSize = Math.max(learnerSockets.size(), 10);
        ExecutorService pool = Executors.newFixedThreadPool(threadPoolSize);
        try {
            List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(learnerSockets, SERVICE_NAME, new Protocol.MasterQuery(protocol), pool);
            final LinkedList results = new LinkedList();
            for (final Future<TextProtocol.MessageExchange> f : futures) {
                new Utils.WithFutureExceptionHandler(){

                    protected void processFuture() throws ExecutionException, InterruptedException {
                        TextProtocol.MessageExchange me = (TextProtocol.MessageExchange)f.get();
                        TextProtocol.ResponseMessage response = me.getResponseMessage();
                        if (response == null) {
                            return;
                        }
                        if (response.getOp() == protocol.MASTER_QUERY_RESPONSE) {
                            results.add((Protocol.MasterQueryResponse)response);
                        } else {
                            LoggerUtils.logMsg(logger, repImpl, formatter, Level.WARNING, "Unexpected MasterQuery response:" + response.wireFormat());
                        }
                    }
                }.execute(logger, repImpl, formatter);
            }
            Protocol.Accepted bestResponse = null;
            for (Protocol.MasterQueryResponse result : results) {
                if (bestResponse != null && result.getProposal().compareTo(bestResponse.getProposal()) <= 0) continue;
                bestResponse = result;
            }
            if (bestResponse == null) {
                throw new UnknownMasterException("Could not determine master from helpers at:" + learnerSockets.toString());
            }
            MasterValue masterValue = (MasterValue)bestResponse.getValue();
            Object var13_12 = null;
            pool.shutdown();
            return masterValue;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            pool.shutdown();
            throw throwable;
        }
    }

    public static void informLearners(Set<InetSocketAddress> learners, Proposer.WinningProposal winningProposal, Protocol protocol, ExecutorService threadPool, Logger logger, RepImpl repImpl, Formatter formatter) {
        if (learners == null || learners.size() == 0) {
            throw EnvironmentFailureException.unexpectedState("There must be at least one learner");
        }
        LoggerUtils.logMsg(logger, repImpl, formatter, Level.FINE, "Informing " + learners.size() + " learners.");
        Protocol protocol2 = protocol;
        protocol2.getClass();
        List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(learners, SERVICE_NAME, new Protocol.Result(protocol2, winningProposal.proposal, winningProposal.chosenValue), threadPool);
        int errors = 0;
        for (Future<TextProtocol.MessageExchange> f : futures) {
            try {
                TextProtocol.MessageExchange me = f.get();
                if (me.getResponseMessage() != null) continue;
                LoggerUtils.logMsg(logger, repImpl, formatter, Level.FINE, "No response from: " + me.target + " reason: " + me.exception);
            }
            catch (InterruptedException e) {
                ++errors;
                LoggerUtils.logMsg(logger, repImpl, formatter, Level.FINE, "informLearners: interrupted while informing ");
            }
            catch (ExecutionException e) {
                ++errors;
                LoggerUtils.logMsg(logger, repImpl, formatter, Level.FINE, "informLearners: exception while informing " + e.getMessage());
            }
        }
        LoggerUtils.logMsg(logger, repImpl, formatter, Level.FINE, "Informed learners: " + (learners.size() - errors));
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public static interface Listener {
        public void notify(Proposer.Proposal var1, Protocol.Value var2);
    }
}

