/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.utilint.SizeofMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class INKeyRep
extends INArrayRep<INKeyRep, Type, byte[]> {
    public INKeyRep(IN parent) {
        super(parent);
    }

    public static class MaxKeySize
    extends INKeyRep {
        private static final int LENGTH_BYTES = 1;
        private static final byte NULL_KEY = 127;
        public static final byte MAX_KEY_LENGTH = 16;
        public static final int MAX_KEYS = 256;
        private final byte[] keys;
        private final short keyLength;

        public MaxKeySize(IN parent, int nodeMaxEntries, short maxKeySize) {
            super(parent);
            assert (maxKeySize < 255);
            this.keyLength = (short)(maxKeySize + 1);
            this.keys = new byte[this.keyLength * nodeMaxEntries];
            for (int i = 0; i < nodeMaxEntries; ++i) {
                INKeyRep rep = this.set(i, null);
                assert (rep == this);
            }
        }

        public MaxKeySize(SizeofMarker marker) {
            super(null);
            this.keys = null;
            this.keyLength = 0;
        }

        public Type getType() {
            return Type.MAX_KEY_SIZE;
        }

        public INKeyRep copy(int from, int to, int n) {
            System.arraycopy(this.keys, from * this.keyLength, this.keys, to * this.keyLength, n * this.keyLength);
            return this;
        }

        public byte[] get(int idx) {
            int k = idx * this.keyLength;
            if (this.keys[k] == 127) {
                return null;
            }
            int length = this.keys[k] - -128;
            byte[] key = new byte[length];
            for (int i = 1; i <= length; ++i) {
                key[i - 1] = this.keys[k + i];
            }
            return key;
        }

        public INKeyRep set(int idx, byte[] key) {
            int ki = idx * this.keyLength;
            if (key == null) {
                this.keys[ki] = 127;
                return this;
            }
            if (key.length >= this.keyLength) {
                Default newRep = this.expandToDefaultRep();
                return newRep.set(idx, key);
            }
            this.keys[ki] = (byte)(key.length + -128);
            for (int i = 1; i <= key.length; ++i) {
                this.keys[ki + i] = key[i - 1];
            }
            return this;
        }

        private Default expandToDefaultRep() {
            int capacity = this.length();
            Default newRep = new Default(this.parent, capacity);
            int defaultKeyBytes = 0;
            for (int i = 0; i < capacity; ++i) {
                byte[] k = this.get(i);
                if (k != null) {
                    defaultKeyBytes += MemoryBudget.byteArraySize(k.length);
                }
                newRep.set(i, k);
            }
            this.noteRepChange(newRep, defaultKeyBytes);
            return newRep;
        }

        public long calculateMemorySize() {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(this.keys.length);
        }

        private static long getMemorySize(int maxKeys, int maxKeySize) {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(maxKeys * (maxKeySize + 1));
        }

        public INKeyRep compact() {
            return this;
        }

        public int length() {
            return this.keys.length / this.keyLength;
        }

        void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINCompactKey().incrementAndGet();
            } else {
                evictor.getNINCompactKey().decrementAndGet();
            }
        }
    }

    public static class Default
    extends INKeyRep {
        private final byte[][] keys;

        Default(IN parent, int nodeMaxEntries) {
            super(parent);
            this.keys = new byte[nodeMaxEntries][];
        }

        public Default(SizeofMarker marker) {
            super(null);
            this.keys = null;
        }

        public Type getType() {
            return Type.DEFAULT;
        }

        public byte[] get(int idx) {
            return this.keys[idx];
        }

        public INKeyRep set(int idx, byte[] key) {
            this.keys[idx] = key;
            return this;
        }

        public INKeyRep copy(int from, int to, int n) {
            System.arraycopy(this.keys, from, this.keys, to, n);
            return this;
        }

        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_KEYVALS_OVERHEAD + MemoryBudget.objectArraySize(this.keys.length);
        }

        public INKeyRep compact() {
            if (this.keys.length > 256) {
                return this;
            }
            int keyCount = 0;
            int maxKeyLength = 0;
            int defaultKeyBytes = 0;
            for (byte[] key : this.keys) {
                if (key == null) continue;
                ++keyCount;
                if (key.length > maxKeyLength && (maxKeyLength = key.length) > 16) {
                    return this;
                }
                defaultKeyBytes += MemoryBudget.byteArraySize(key.length);
            }
            if (keyCount == 0) {
                return this;
            }
            long defaultSizeWithKeys = this.calculateMemorySize() + (long)defaultKeyBytes;
            if (defaultSizeWithKeys > MaxKeySize.getMemorySize(this.keys.length, maxKeyLength)) {
                return this.compactToMaxKeySizeRep(maxKeyLength, defaultKeyBytes);
            }
            return this;
        }

        private MaxKeySize compactToMaxKeySizeRep(int maxKeyLength, int defaultKeyBytes) {
            MaxKeySize newRep = new MaxKeySize(this.parent, this.keys.length, (short)maxKeyLength);
            for (int i = 0; i < this.keys.length; ++i) {
                newRep.set(i, this.keys[i]);
            }
            this.noteRepChange(newRep, -defaultKeyBytes);
            return newRep;
        }

        public int length() {
            return this.keys.length;
        }

        void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DEFAULT,
        MAX_KEY_SIZE;

    }
}

