/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;

public final class Provider
implements RecordManagerProvider {
    public RecordManager createRecordManager(String string, Properties properties) throws IOException {
        RecordManager recordManager = new BaseRecordManager(string);
        String string2 = properties.getProperty("jdbm.disableTransactions", "false");
        if (string2.equalsIgnoreCase("TRUE")) {
            recordManager.disableTransactions();
        }
        string2 = properties.getProperty("jdbm.cache.size", "1000");
        int n = Integer.parseInt(string2);
        string2 = properties.getProperty("jdbm.cache.type", "normal");
        if (!string2.equalsIgnoreCase("normal")) {
            if (string2.equalsIgnoreCase("soft")) {
                throw new IllegalArgumentException("Soft reference cache not implemented");
            }
            if (string2.equalsIgnoreCase("weak")) {
                throw new IllegalArgumentException("Weak reference cache not implemented");
            }
            throw new IllegalArgumentException("Invalid cache type: " + string2);
        }
        MRU mRU = new MRU(n);
        recordManager = new CacheRecordManager(recordManager, mRU);
        return recordManager;
    }
}

