#!/bin/bash

OS_ALLCAPS=`uname | tr 'a-z' 'A-Z'`

selfcon_ext=selfcontained-cmake
installed_dir=${selfcon_ext}/cmake3-linux-64bit

echo ""
if [ ! -d $selfcon_ext ] ; then
    echo "Checking out from svn: Greenstone3's $selfcon_ext extension"
    svn co https://svn.greenstone.org/gs3-extensions/$selfcon_ext/trunk $selfcon_ext

    if [ $? != 0 ] ; then
	echo "Error encountered checking out: " 1>&2
	echo "    svn co https://svn.greenstone.org/gs3-extensions/$selfcon_ext/trunk $selfcon_ext" 1>&2
	exit 1
    fi
else
    echo "Detected directory '$selfcon_ext'"
    echo "=> Taken to mean that the svn check-out command has already been run"
fi

echo ""
if [ ! -d $installed_dir ] ; then
    echo "Runing the $selfcon_ext/PREPARE-${OS_ALLCAPS}.sh"

    cd $selfcon_ext && ./PREPARE-${OS_ALLCAPS}.sh

    if [ $? != 0 ] ; then
	echo "Error encountered running: " 1>&2
	echo "        cd $selfcon_ext && ./PREPARE-${OS_ALLCAPS}.sh" 1>&2
	exit 1
    fi
	
else
    echo "Detected directory '$installed_dir'"
    echo "=> Taken to mean that the $selfcon_ext/PREPARE-${OS_ALLCAPS}.sh command has already been run"    
fi


if [ "x$CMAKE_HOME" != "x$PWD/$installed_dir" ] ; then
    echo ""
    echo "To use this installed version of cmake, run "
    echo "    source ./SETUP-CLI.sh "
    echo "in the ext-cli folder."
    echo ""
else
    echo ""
    echo "Detected CMAKE_HOME set to \$PWD/$installed_dir"
    echo "=> Taken to mean that the $selfcon_ext SETUP.sh file has been sourced"
fi

echo ""
